/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.berechnungen.sonstiges;

import de.planetensuche.formelsammlung.berechnungen.api.IFormel;
import de.planetensuche.formelsammlung.berechnungen.util.Formel;
import de.planetensuche.formelsammlung.controls.enums.FormelnSonstiges;

public final class Oberflaechentemperatur
extends Formel
implements IFormel {
    private static final String GRAD = String.valueOf('\u00b0');
    private double leuchtkraftStern;
    private double bahnabstandInAE;
    private double albedo;
    private double treibhauseffekt;
    private double temperaturOhneAtmosphaere;
    private double temperaturMitAtmosphaere;

    @Override
    public String berechne(boolean bl) {
        double d = this.leuchtkraftStern / Math.pow(this.bahnabstandInAE, 2.0);
        this.temperaturOhneAtmosphaere = (d *= 1368.0) * (1.0 - this.albedo) / 2.26816E-7;
        this.temperaturOhneAtmosphaere = Math.sqrt(Math.sqrt(this.temperaturOhneAtmosphaere)) - 273.15;
        this.temperaturMitAtmosphaere = d * (1.0 - this.albedo) / (2.26816E-7 * this.treibhauseffekt);
        this.temperaturMitAtmosphaere = Math.sqrt(Math.sqrt(this.temperaturMitAtmosphaere)) - 273.15;
        return Long.toString(Math.round(this.temperaturOhneAtmosphaere)) + GRAD + "C / " + Long.toString(Math.round(this.temperaturMitAtmosphaere)) + GRAD + "C";
    }

    public double getTemperaturOhneAtmosphaere() {
        return this.temperaturOhneAtmosphaere;
    }

    public double getTemperaturMitAtmosphaere() {
        return this.temperaturMitAtmosphaere;
    }

    @Override
    public String getName() {
        return FormelnSonstiges.OBERFLAECHENTEMPERATUR.name();
    }

    @Override
    public void setEingaben(double d, double ... dArray) {
        this.leuchtkraftStern = d;
        this.bahnabstandInAE = dArray[0];
        this.albedo = dArray[1];
        this.treibhauseffekt = dArray[2];
    }
}

