/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.berechnungen.sonstiges;

import de.planetensuche.formelsammlung.berechnungen.api.IFormel;
import de.planetensuche.formelsammlung.berechnungen.util.Formel;
import de.planetensuche.formelsammlung.controls.enums.FormelnSonstiges;

public final class OberflaechentemperaturEinfach
extends Formel
implements IFormel {
    private static final String GRAD = String.valueOf('\u00b0');
    private double leuchtkraftStern;
    private double bahnabstandInAE;
    private double albedo;
    private double temperaturOhneAtmosphaere;

    @Override
    public String berechne(boolean bl) {
        this.temperaturOhneAtmosphaere = this.leuchtkraftStern * (1.0 - this.albedo) / (50.26548245743669 * Math.pow(this.bahnabstandInAE, 2.0) * 5.6704E-8);
        this.temperaturOhneAtmosphaere = Math.pow(this.temperaturOhneAtmosphaere, 0.25);
        return Long.toString(Math.round(this.temperaturOhneAtmosphaere)) + GRAD + "C";
    }

    public double getTemperaturOhneAtmosphaere() {
        return this.temperaturOhneAtmosphaere;
    }

    @Override
    public String getName() {
        return FormelnSonstiges.OBERFLAECHENTEMPERATUR_EINFACH.name();
    }

    @Override
    public void setEingaben(double d, double ... dArray) {
        this.leuchtkraftStern = d;
        this.bahnabstandInAE = dArray[0];
        this.albedo = dArray[1];
    }
}

