/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.berechnungen.sterne;

import de.planetensuche.formelsammlung.berechnungen.api.IFormel;
import de.planetensuche.formelsammlung.berechnungen.util.Formel;
import de.planetensuche.formelsammlung.controls.enums.FormelnSterne;

public final class SternleuchtkraftTemperatur
extends Formel
implements IFormel {
    private double radiusInKm;
    private double temperaturInKelvin;

    @Override
    public String berechne(boolean bl) {
        double d = this.getErgebnis();
        return SternleuchtkraftTemperatur.runden(bl, d);
    }

    public double getErgebnis() {
        double d = Math.pow(this.radiusInKm / 696392.0, 2.0);
        double d2 = Math.pow(this.temperaturInKelvin / 5778.0, 4.0);
        return d * d2;
    }

    @Override
    public String getName() {
        return FormelnSterne.STERNLEUCHTKRAFT_TEMPERATUR.name();
    }

    @Override
    public void setEingaben(double d, double ... dArray) {
        this.radiusInKm = d * 696392.0;
        this.temperaturInKelvin = dArray[0];
    }
}

