/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.berechnungen.zeitrechnung;

import de.planetensuche.formelsammlung.berechnungen.api.IFormel;
import de.planetensuche.formelsammlung.berechnungen.util.Formel;
import de.planetensuche.formelsammlung.controls.enums.FormelnZeitrechnung;

public final class GreenwichSternzeit
extends Formel
implements IFormel {
    private double julianischesDatum0UT;
    private double weltzeitInStunden;

    @Override
    public String berechne(boolean bl) {
        double d = 6.66452 + 0.0657098244 * (this.julianischesDatum0UT - 2451544.5) + 1.0027379093 * this.weltzeitInStunden;
        if (d < 0.0) {
            while (d < 0.0) {
                d += 24.0;
            }
        } else {
            while (d > 24.0) {
                d -= 24.0;
            }
        }
        return GreenwichSternzeit.runden(bl, d);
    }

    @Override
    public String getName() {
        return FormelnZeitrechnung.GREENWICHSTERNZEIT.name();
    }

    @Override
    public void setEingaben(double d, double ... dArray) {
        this.julianischesDatum0UT = d;
        this.weltzeitInStunden = dArray[0];
    }
}

