/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.berechnungen.zeitrechnung;

import de.planetensuche.formelsammlung.berechnungen.api.IFormel;
import de.planetensuche.formelsammlung.berechnungen.util.Formel;
import de.planetensuche.formelsammlung.controls.enums.FormelnZeitrechnung;

public final class JulianischesDatum
extends Formel
implements IFormel {
    private double weltzeitInStunden;
    private int tag;
    private int monat;
    private int jahr;

    @Override
    public String berechne(boolean bl) {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        if (this.monat > 2) {
            d = this.jahr;
            d2 = this.monat;
        } else {
            d = (double)this.jahr - 1.0;
            d2 = (double)this.monat + 12.0;
        }
        d3 = this.jahr < 1582 ? -2.0 : Math.floor(d / 400.0) - Math.floor(d / 100.0);
        double d4 = Math.floor(365.25 * d) + Math.floor(30.6001 * (d2 + 1.0)) + d3 + 1720996.5 + (double)this.tag + this.weltzeitInStunden / 24.0;
        return JulianischesDatum.runden(bl, d4);
    }

    @Override
    public String getName() {
        return FormelnZeitrechnung.JULIANISCHESDATUM.name();
    }

    @Override
    public void setEingaben(double d, double ... dArray) {
        this.weltzeitInStunden = d;
        this.tag = (int)dArray[0];
        this.monat = (int)dArray[1];
        this.jahr = (int)dArray[2];
    }
}

