/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.controls;

import de.planetensuche.formelsammlung.api.IKategoriezuweiser;
import de.planetensuche.formelsammlung.controls.GUIBuilderParameter;
import de.planetensuche.formelsammlung.controls.api.IGUIBuilder;
import de.planetensuche.formelsammlung.gui.api.IFormelAnzeige;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JTextField;

public final class GUIBuilder
implements IGUIBuilder {
    private final GUIBuilderParameter guiBuilderParameter;
    private final ISprachcontainer sprache;
    private IKategoriezuweiser kategoriezuweiser;
    private String[] eingabeLabelsKeys;
    private String[] eingabeWerte;
    private String[] konstantenLabelsKeys;
    private String[] konstantenWerte;

    public GUIBuilder(GUIBuilderParameter gUIBuilderParameter, ISprachcontainer iSprachcontainer, IKategoriezuweiser iKategoriezuweiser) {
        this.guiBuilderParameter = gUIBuilderParameter;
        this.sprache = iSprachcontainer;
        this.kategoriezuweiser = iKategoriezuweiser;
    }

    @Override
    public void loadAndShowFormelTexte(int n, String string) {
        IFormelAnzeige iFormelAnzeige = this.kategoriezuweiser.getFormelGUI(n, string);
        iFormelAnzeige.show(this);
        this.show();
    }

    private void show() {
        List<JTextField> list = this.guiBuilderParameter.getParameterWerte();
        List<JLabel> list2 = this.guiBuilderParameter.getParameterLabels();
        int n = 0;
        block5: for (int i = 0; i < list2.size(); ++i) {
            int n2 = i - this.eingabeLabelsKeys.length;
            if (i == this.eingabeLabelsKeys.length) {
                n = 1;
                if (this.konstantenLabelsKeys == null || this.konstantenLabelsKeys.length == 0) {
                    n = 2;
                }
            }
            if (n == 1 && this.konstantenLabelsKeys != null && n2 == this.konstantenLabelsKeys.length) {
                n = 2;
            }
            switch (n) {
                case 0: {
                    list2.get(i).setText(this.sprache.getString(this.eingabeLabelsKeys[i]));
                    list2.get(i).setVisible(true);
                    list.get(i).setText(this.eingabeWerte[i]);
                    list.get(i).setEditable(true);
                    list.get(i).setVisible(true);
                    continue block5;
                }
                case 1: {
                    if (this.konstantenLabelsKeys == null || this.konstantenLabelsKeys[n2] == null) continue block5;
                    list2.get(i).setText(this.sprache.getString(this.konstantenLabelsKeys[n2]));
                    list2.get(i).setVisible(true);
                    list.get(i).setText(this.konstantenWerte[n2]);
                    list.get(i).setEditable(false);
                    list.get(i).setVisible(true);
                    continue block5;
                }
                case 2: {
                    list2.get(i).setVisible(false);
                    list.get(i).setVisible(false);
                    continue block5;
                }
            }
        }
    }

    @Override
    public void setWerte(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException();
        }
        this.eingabeLabelsKeys = stringArray;
        this.eingabeWerte = stringArray2;
    }

    @Override
    public void setKonstanten(String[] stringArray, String[] stringArray2) {
        if (stringArray.length != stringArray2.length) {
            throw new IllegalArgumentException();
        }
        this.konstantenLabelsKeys = stringArray;
        this.konstantenWerte = stringArray2;
    }

    @Override
    public void setBeschreibungsText(String string) {
        this.guiBuilderParameter.getBeschreibungsLabel().setText(this.sprache.getString(string));
    }

    @Override
    public void setFormelText(String string) {
        this.guiBuilderParameter.getFormelanzeigeLabel().setText(string);
        this.setErgebnisLabelText(null, null);
    }

    @Override
    public void setBeschreibungsText(String[] stringArray) {
        JLabel jLabel = this.guiBuilderParameter.getBeschreibungsLabel();
        jLabel.setText("<html>");
        for (String string : stringArray) {
            jLabel.setText(jLabel.getText() + this.sprache.getString(string).replaceAll("<html>", "").replaceAll("</html>", ""));
        }
        jLabel.setText(jLabel.getText() + "</html>");
    }

    @Override
    public void setErgebnisLabelText(String string, String string2) {
        String string3 = string;
        Object object = string2;
        if (string3 == null || string3.isEmpty()) {
            string3 = "fs_m1";
        }
        object = object == null ? "" : " " + (String)object + ":";
        this.guiBuilderParameter.getErgebnisLabel().setText(this.sprache.getString(string3) + (String)object);
    }
}

