/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.formelsammlung.gui;

import de.planetensuche.formelsammlung.api.IKategoriezuweiser;
import de.planetensuche.formelsammlung.berechnungen.api.IFabrik;
import de.planetensuche.formelsammlung.berechnungen.api.IFormel;
import de.planetensuche.formelsammlung.controls.GUIBuilder;
import de.planetensuche.formelsammlung.controls.GUIBuilderParameter;
import de.planetensuche.formelsammlung.gui.KonstantenGui;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.JComboBoxExtended;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public final class FormelsammlungDialog
extends Basisdialog {
    private JComboBoxExtended<String> kategorie;
    private final boolean runden;
    private GUIBuilder guiBuilder;
    private final IKategoriezuweiser kategoriezuweiser;
    private IFabrik ifabrik;
    private List<String> aktuelleKategorie;
    private JLabel anz1;
    private JLabel anz2;
    private JLabel anz3;
    private JLabel anz4;
    private JLabel anz5;
    private JLabel anz6;
    private JLabel anz7;
    private JLabel anz8;
    private JButton berechnen;
    private JLabel beschreibung;
    private JLabel einheit;
    private JTextField ergebnis;
    private JComboBox formel;
    private JLabel formelanzeige;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JMenu jMenu1;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JScrollPane jScrollPane1;
    private JTextField wert1;
    private JTextField wert2;
    private JTextField wert3;
    private JTextField wert4;
    private JTextField wert5;
    private JTextField wert6;
    private JTextField wert7;
    private JTextField wert8;

    public FormelsammlungDialog(boolean bl, IKategoriezuweiser iKategoriezuweiser) {
        super(BasisdialogId.FORMELSAMMLUNG_HAUPTFENSTER);
        this.runden = bl;
        this.kategoriezuweiser = iKategoriezuweiser;
    }

    private void createKategorieComboBox() {
        this.kategorie = new JComboBoxExtended(10);
        this.kategorie.addActionListener(actionEvent -> this.kategorieActionPerformed(actionEvent));
        this.getContentPane().add(this.kategorie);
        this.kategorie.setBounds(90, 10, 220, 24);
    }

    private void beschrifteGUI() {
        this.setTitle(this.i18n.getString("fs_fenster"));
        this.jMenu1.setText(this.i18n.getString("fs_gui1"));
        this.jMenuItem1.setText(this.i18n.getString("fs_gui2"));
        this.jMenuItem2.setText(this.i18n.getString("fs_gui3"));
        this.jLabel1.setText(this.i18n.getString("fs_gui4"));
        this.jLabel2.setText(this.i18n.getString("fs_gui5"));
        this.berechnen.setText(this.i18n.getString("fs_gui6"));
        this.einheit.setText(this.i18n.getString("fs_m88"));
    }

    private void zeigeKategorien() {
        this.kategorie.removeAllItems();
        this.kategorie.addItem(this.i18n.getString("fs_gui7"));
        this.kategorie.addItem(this.i18n.getString("fs_gui8"));
        this.kategorie.addItem(this.i18n.getString("fs_gui9"));
        this.kategorie.addItem(this.i18n.getString("fs_gui10"));
        this.kategorie.addItem(this.i18n.getString("fs_gui11"));
        this.kategorie.addItem(this.i18n.getString("fs_gui12"));
        this.kategorie.setSelectedIndex(0);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.formel = new JComboBox();
        this.berechnen = new JButton();
        this.formelanzeige = new JLabel();
        this.anz1 = new JLabel();
        this.anz2 = new JLabel();
        this.anz3 = new JLabel();
        this.anz4 = new JLabel();
        this.wert1 = new JTextField();
        this.wert2 = new JTextField();
        this.wert3 = new JTextField();
        this.wert4 = new JTextField();
        this.einheit = new JLabel();
        this.ergebnis = new JTextField();
        this.anz5 = new JLabel();
        this.anz6 = new JLabel();
        this.anz7 = new JLabel();
        this.anz8 = new JLabel();
        this.wert5 = new JTextField();
        this.wert6 = new JTextField();
        this.wert7 = new JTextField();
        this.wert8 = new JTextField();
        this.jScrollPane1 = new JScrollPane();
        this.beschreibung = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.setTitle("Formelsammlung");
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.jLabel1.setText("Kategorie:");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(10, 10, 80, 18);
        this.jLabel2.setText("Formel:");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(350, 10, 70, 18);
        this.formel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormelsammlungDialog.this.formelActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.formel);
        this.formel.setBounds(430, 10, 260, 24);
        this.berechnen.setText("berechnen");
        this.berechnen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormelsammlungDialog.this.berechnenActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.berechnen);
        this.berechnen.setBounds(460, 480, 140, 24);
        this.formelanzeige.setText("jLabel3");
        this.getContentPane().add(this.formelanzeige);
        this.formelanzeige.setBounds(80, 180, 510, 18);
        this.anz1.setText("jLabel3");
        this.getContentPane().add(this.anz1);
        this.anz1.setBounds(10, 210, 380, 18);
        this.anz2.setText("jLabel3");
        this.getContentPane().add(this.anz2);
        this.anz2.setBounds(10, 240, 380, 18);
        this.anz3.setText("jLabel3");
        this.getContentPane().add(this.anz3);
        this.anz3.setBounds(10, 270, 380, 18);
        this.anz4.setText("jLabel3");
        this.getContentPane().add(this.anz4);
        this.anz4.setBounds(10, 300, 380, 18);
        this.getContentPane().add(this.wert1);
        this.wert1.setBounds(460, 210, 140, 24);
        this.getContentPane().add(this.wert2);
        this.wert2.setBounds(460, 240, 140, 24);
        this.getContentPane().add(this.wert3);
        this.wert3.setBounds(460, 270, 140, 24);
        this.getContentPane().add(this.wert4);
        this.wert4.setBounds(460, 300, 140, 24);
        this.einheit.setText("Ergebnis:");
        this.getContentPane().add(this.einheit);
        this.einheit.setBounds(10, 450, 380, 18);
        this.getContentPane().add(this.ergebnis);
        this.ergebnis.setBounds(460, 450, 200, 24);
        this.anz5.setText("jLabel3");
        this.getContentPane().add(this.anz5);
        this.anz5.setBounds(10, 330, 370, 18);
        this.anz6.setText("jLabel3");
        this.getContentPane().add(this.anz6);
        this.anz6.setBounds(10, 360, 370, 18);
        this.anz7.setText("jLabel3");
        this.getContentPane().add(this.anz7);
        this.anz7.setBounds(10, 390, 370, 18);
        this.anz8.setText("jLabel3");
        this.getContentPane().add(this.anz8);
        this.anz8.setBounds(10, 420, 370, 18);
        this.getContentPane().add(this.wert5);
        this.wert5.setBounds(460, 330, 140, 24);
        this.getContentPane().add(this.wert6);
        this.wert6.setBounds(460, 360, 140, 24);
        this.getContentPane().add(this.wert7);
        this.wert7.setBounds(460, 390, 140, 24);
        this.getContentPane().add(this.wert8);
        this.wert8.setBounds(460, 420, 140, 24);
        this.beschreibung.setText("jLabel3");
        this.jScrollPane1.setViewportView(this.beschreibung);
        this.getContentPane().add(this.jScrollPane1);
        this.jScrollPane1.setBounds(10, 40, 680, 120);
        this.jMenu1.setText("Anzeigen");
        this.jMenuItem1.setText("Konstanten");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormelsammlungDialog.this.jMenuItem1ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem2.setText("Info");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FormelsammlungDialog.this.jMenuItem2ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuBar1.add(this.jMenu1);
        this.setJMenuBar(this.jMenuBar1);
        this.setSize(new Dimension(722, 568));
        this.setLocationRelativeTo(null);
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
        KonstantenGui konstantenGui = new KonstantenGui();
        konstantenGui.setVisible(true);
    }

    private void jMenuItem2ActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, "Formelsammlung \u00a9 by Gerd Guehne", "Programminfo", 1);
    }

    private void berechnenActionPerformed(ActionEvent actionEvent) {
        IFormel iFormel = this.parseEingabefelder();
        if (iFormel != null) {
            this.berechneEingaben(iFormel);
        }
    }

    private IFormel parseEingabefelder() {
        this.ergebnis.setText("");
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        double d7 = 0.0;
        double d8 = 0.0;
        try {
            d = this.i18n.parseDouble(this.wert1.getText());
            if (this.wert2.isVisible()) {
                d2 = this.i18n.parseDouble(this.wert2.getText());
            }
            if (this.wert3.isVisible()) {
                d3 = this.i18n.parseDouble(this.wert3.getText());
            }
            if (this.wert4.isVisible()) {
                d4 = this.i18n.parseDouble(this.wert4.getText());
            }
            if (this.wert5.isVisible()) {
                d5 = this.i18n.parseDouble(this.wert5.getText());
            }
            if (this.wert6.isVisible()) {
                d6 = this.i18n.parseDouble(this.wert6.getText());
            }
            if (this.wert7.isVisible()) {
                d7 = this.i18n.parseDouble(this.wert7.getText());
            }
            if (this.wert8.isVisible()) {
                d8 = this.i18n.parseDouble(this.wert8.getText());
            }
            String string = this.aktuelleKategorie.get(this.formel.getSelectedIndex());
            IFormel iFormel = this.ifabrik.getFormelFuerEnum(string, d, d2, d3, d4, d5, d6, d7, d8);
            return iFormel;
        }
        catch (NumberFormatException numberFormatException) {
            JOptionPane.showMessageDialog(this, this.i18n.getString("fs_f1"), this.i18n.getString("db_f70_titel"), 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(this, this.i18n.getString("fs_f2"), this.i18n.getString("db_f70_titel"), 0);
        }
        return null;
    }

    private void berechneEingaben(IFormel iFormel) {
        try {
            this.ergebnis.setText(iFormel.berechne(this.runden));
        }
        catch (ArithmeticException arithmeticException) {
            JOptionPane.showMessageDialog(this, this.i18n.getString("fs_f3") + "\n" + arithmeticException.toString(), this.i18n.getString("db_f4_titel"), 0);
        }
    }

    private void formelActionPerformed(ActionEvent actionEvent) {
        if (this.formel.getSelectedIndex() > -1) {
            this.ergebnis.setText("");
            this.einheit.setText(this.i18n.getString("fs_m19"));
            try {
                String string = this.aktuelleKategorie.get(this.formel.getSelectedIndex());
                this.guiBuilder.loadAndShowFormelTexte(this.kategorie.getSelectedIndex(), string);
            }
            catch (Exception exception) {
                this.getLogger().error(exception);
            }
        }
    }

    private void kategorieActionPerformed(ActionEvent actionEvent) {
        if (this.kategorie.getSelectedIndex() > -1) {
            this.formel.removeAllItems();
            this.aktuelleKategorie = this.kategoriezuweiser.getFormelnFuerKategorie(this.kategorie.getSelectedIndex());
            this.ifabrik = this.kategoriezuweiser.getFabrikFuerKategorie(this.kategorie.getSelectedIndex());
            for (String string : this.aktuelleKategorie) {
                this.formel.addItem(this.i18n.getString(string));
            }
        }
    }

    public void showDialog() {
        if (this.berechnen != null) {
            this.setVisible(true);
            return;
        }
        this.initComponents();
        this.createKategorieComboBox();
        GUIBuilderParameter gUIBuilderParameter = new GUIBuilderParameter();
        gUIBuilderParameter.setBeschreibungsLabel(this.beschreibung);
        gUIBuilderParameter.setFormelanzeigeLabel(this.formelanzeige);
        gUIBuilderParameter.setErgebnisLabel(this.einheit);
        ArrayList<JLabel> arrayList = new ArrayList<JLabel>(8);
        arrayList.add(this.anz1);
        arrayList.add(this.anz2);
        arrayList.add(this.anz3);
        arrayList.add(this.anz4);
        arrayList.add(this.anz5);
        arrayList.add(this.anz6);
        arrayList.add(this.anz7);
        arrayList.add(this.anz8);
        gUIBuilderParameter.setParameterLabels(arrayList);
        ArrayList<JTextField> arrayList2 = new ArrayList<JTextField>(8);
        arrayList2.add(this.wert1);
        arrayList2.add(this.wert2);
        arrayList2.add(this.wert3);
        arrayList2.add(this.wert4);
        arrayList2.add(this.wert5);
        arrayList2.add(this.wert6);
        arrayList2.add(this.wert7);
        arrayList2.add(this.wert8);
        gUIBuilderParameter.setParameterWerte(arrayList2);
        this.guiBuilder = new GUIBuilder(gUIBuilderParameter, this.i18n, this.kategoriezuweiser);
        this.beschrifteGUI();
        this.zeigeKategorien();
        this.getGuiDesigner().addComponent(this.beschreibung, false);
        this.getGuiDesigner().addComponent(this.formelanzeige, true);
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            if (this.getContentPane().getComponent(i).equals(this.formelanzeige)) continue;
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
        this.setVisible(true);
    }
}

