/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.components;

import de.planetensuche.guidesigner.components.PictureViewerDataSource;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.ImageIcon;

public class LocalPicturesDataSource
implements PictureViewerDataSource {
    private final List<String> pictures;

    public LocalPicturesDataSource(Collection<String> collection) {
        this.pictures = collection == null ? Collections.emptyList() : new ArrayList<String>(collection);
    }

    @Override
    public int numberOfPictures() {
        return this.pictures.size();
    }

    @Override
    public String getPictureName(int n) {
        return this.pictures.get(n);
    }

    @Override
    public ImageIcon getPicture(int n) {
        String string = "pics" + File.separator + this.getPictureName(n);
        File file = new File(string);
        if (file.exists()) {
            ImageIcon imageIcon = new ImageIcon(string);
            return imageIcon;
        }
        return null;
    }

    @Override
    public List<String> getPictureNames() {
        return this.pictures;
    }
}

