/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.guidesigner.components;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import de.planetensuche.web.connector.windowaccess.WindowAccessDto;
import de.planetensuche.web.connector.windowaccess.WindowAccessRestClient;
import java.util.concurrent.Executors;

public class SendWindowAccessToWebService {
    private final ILogging logger = LoggingFactory.getLoggerForClass(SendWindowAccessToWebService.class);

    public void sendAsyncWithoutException(BasisdialogId basisdialogId) {
        Executors.newSingleThreadExecutor().submit(() -> {
            try {
                KonfigurationDTO konfigurationDTO = KonfiguratorFabrik.getKonfigurator().read();
                if (konfigurationDTO.isSendWindowAccess()) {
                    WindowAccessRestClient windowAccessRestClient = new WindowAccessRestClient(konfigurationDTO);
                    windowAccessRestClient.save(new WindowAccessDto(basisdialogId.getId()));
                }
            }
            catch (Exception exception) {
                this.logger.warn("BasisdialogId=" + String.valueOf((Object)basisdialogId), exception);
            }
        });
    }
}

