/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm;

import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.web.connector.statistic.UserStatisticClientService;
import de.planetensuche.web.connector.statistic.UserStatisticDtoV1;

public final class BenutzerStatistikUpdater
implements Runnable {
    private final KonfigurationDTO konfigurationsdaten;
    private final ILogging logger;

    public BenutzerStatistikUpdater(KonfigurationDTO konfigurationDTO) {
        this.konfigurationsdaten = konfigurationDTO;
        this.logger = LoggingFactory.getLoggerForClass(BenutzerStatistikUpdater.class);
    }

    @Override
    public void run() {
        boolean bl = this.konfigurationsdaten.isAnonymeBenutzerstatistikSenden();
        this.logger.info("die anonyme Benutzerstatistik ist aktiv? " + bl);
        if (!bl) {
            return;
        }
        char[] cArray = new char[]{'a', 'n', 'y'};
        UserStatisticClientService userStatisticClientService = new UserStatisticClientService(cArray, this.konfigurationsdaten);
        try {
            UserStatisticDtoV1 userStatisticDtoV1 = new UserStatisticDtoV1();
            userStatisticDtoV1.setSprache(this.konfigurationsdaten.getSprache());
            userStatisticDtoV1.setVersion(this.konfigurationsdaten.getVersion());
            userStatisticDtoV1.setOs(System.getProperty("os.name").replaceAll(" ", "_"));
            userStatisticDtoV1.setOsSprache(System.getProperty("user.language"));
            userStatisticDtoV1.setJavaVersion(JavaVersionHelperUtil.getInstalledJavaVersion());
            userStatisticDtoV1.setInternalVm(JavaVersionHelperUtil.isLocalJreAvailable());
            this.logger.debug(userStatisticDtoV1.toString());
            boolean bl2 = userStatisticClientService.save(userStatisticDtoV1);
            if (!bl2) {
                this.logger.warn("speichern der anonymen user statistic fehlgeschlagen");
            }
        }
        catch (Exception exception) {
            this.logger.error(exception);
        }
    }
}

