/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm;

import de.planetensuche.datenbank.Start;
import de.planetensuche.datenbank.api.IStart;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.IPlanetensucheModul;
import de.planetensuche.hauptprogramm.PlanetensucheModulThread;
import de.planetensuche.hauptprogramm.StartPlanetensuche;
import de.planetensuche.hauptprogramm.api.DbInitializedListener;
import de.planetensuche.hauptprogramm.voting.DatenbankModulStarter;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.leben.LebenMainGui;
import de.planetensuche.quiz.StartGui;
import de.planetensuche.sternkarte.api.SternkartenFabrik;
import java.io.IOException;
import javax.swing.JFrame;

public final class PlanetensucheModulLoader
implements DatenbankModulStarter {
    private final ILogging logger = LoggingFactory.getLoggerForClass(PlanetensucheModulLoader.class);
    private final JFrame dialog;
    private final KonfigurationDTO konfigurationsdaten;
    private IPlanetensucheModul umrechnerModul;
    private IPlanetensucheModul quizModul;
    private IPlanetensucheModul lebenModul;
    private IPlanetensucheModul formelsammlungModul;
    private IPlanetensucheModul simulationsModul;
    private IPlanetensucheModul datenbankModul;
    private IPlanetensucheModul sternenkarteModul;

    public PlanetensucheModulLoader(JFrame jFrame, KonfigurationDTO konfigurationDTO) {
        this.dialog = jFrame;
        this.konfigurationsdaten = konfigurationDTO;
    }

    public IStart starteDatenbank() {
        return this.starteDatenbank(this.dialog, null);
    }

    @Override
    public IStart starteDatenbank(JFrame jFrame, DbInitializedListener dbInitializedListener) {
        try {
            if (this.datenbankModul == null) {
                this.datenbankModul = new Start(this.konfigurationsdaten);
                StartPlanetensuche.initDatenbankService(jFrame, this.konfigurationsdaten.getSternbildSprache(), this.konfigurationsdaten.getDatenbankName(), () -> this.startePlanetensucheModul(this.datenbankModul, dbInitializedListener));
            } else {
                this.startePlanetensucheModul(this.datenbankModul, dbInitializedListener);
            }
            return (IStart)((Object)this.datenbankModul);
        }
        catch (Exception exception) {
            this.logger.error(exception);
            return null;
        }
    }

    public void starteSimulation() {
        try {
            if (this.simulationsModul == null) {
                this.simulationsModul = new de.planetensuche.simulationen.Start(this.konfigurationsdaten);
                StartPlanetensuche.initDatenbankService(this.dialog, this.konfigurationsdaten.getSternbildSprache(), this.konfigurationsdaten.getDatenbankName(), () -> this.startePlanetensucheModul(this.simulationsModul, null));
            } else {
                this.startePlanetensucheModul(this.simulationsModul, null);
            }
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
    }

    public void starteQuiz() {
        if (this.quizModul == null) {
            this.quizModul = new StartGui();
        }
        this.startePlanetensucheModul(this.quizModul, null);
    }

    public void starteLeben() {
        if (this.lebenModul == null) {
            this.lebenModul = new LebenMainGui();
        }
        this.startePlanetensucheModul(this.lebenModul, null);
    }

    public void starteFormelsammlung() {
        if (this.formelsammlungModul == null) {
            this.formelsammlungModul = new de.planetensuche.formelsammlung.Start(this.konfigurationsdaten);
        }
        this.startePlanetensucheModul(this.formelsammlungModul, null);
    }

    public void starteUmrechner() {
        try {
            if (this.umrechnerModul == null) {
                this.umrechnerModul = new de.planetensuche.umrechner.StartGui(this.konfigurationsdaten);
            }
            this.startePlanetensucheModul(this.umrechnerModul, null);
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
    }

    void starteSternenkarte() {
        try {
            if (this.sternenkarteModul == null) {
                this.sternenkarteModul = new SternkartenFabrik(this.konfigurationsdaten.getKoordinatenFormat());
                StartPlanetensuche.initDatenbankService(this.dialog, this.konfigurationsdaten.getSternbildSprache(), this.konfigurationsdaten.getDatenbankName(), () -> this.startePlanetensucheModul(this.sternenkarteModul, null));
            } else {
                this.startePlanetensucheModul(this.sternenkarteModul, null);
            }
        }
        catch (RuntimeException runtimeException) {
            this.logger.error(runtimeException);
        }
    }

    private void startePlanetensucheModul(IPlanetensucheModul iPlanetensucheModul, DbInitializedListener dbInitializedListener) {
        PlanetensucheModulThread planetensucheModulThread = new PlanetensucheModulThread(iPlanetensucheModul, dbInitializedListener);
        planetensucheModulThread.start();
    }
}

