/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.hauptprogramm.ProgramminfoDialog;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.awt.Desktop;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;

public final class ProgramminfoControler {
    private final ILogging logging;
    private final KonfigurationDTO konfiguration;
    private ProgramminfoDialog dialog;

    public ProgramminfoControler(KonfigurationDTO konfigurationDTO) {
        this.konfiguration = konfigurationDTO;
        this.logging = LoggingFactory.getLoggerForClass(ProgramminfoControler.class);
    }

    public void showDialog() {
        this.dialog = new ProgramminfoDialog(this.konfiguration);
        this.erstelleListener();
        this.dialog.setVisible(true);
    }

    public boolean isDialogVisible() {
        return this.dialog.isVisible();
    }

    private void erstelleListener() {
        this.dialog.jLabel18.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProgramminfoControler.this.zeigeWebseite("https://java.sun.com");
            }
        });
        this.dialog.marioWeigandLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProgramminfoControler.this.zeigeWebseite("https://www.skytrip.de");
            }
        });
        this.dialog.peterWienerroitherLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProgramminfoControler.this.zeigeWebseite("https://peter-wienerroither.at/");
            }
        });
        this.dialog.bernhardHublLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProgramminfoControler.this.zeigeWebseite("http://www.astrophoton.com");
            }
        });
        this.dialog.autorHomepageLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                ProgramminfoControler.this.zeigeWebseite("https://www." + ProgramminfoControler.this.konfiguration.getHomepageHostname());
            }
        });
    }

    private void zeigeWebseite(String string) {
        try {
            if (this.konfiguration.isStandardBrowser() && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI(string));
            } else if (!this.konfiguration.isStandardBrowser()) {
                Runtime.getRuntime().exec(this.konfiguration.getBrowserpfad() + " \"" + string + "\"");
            }
        }
        catch (IOException | URISyntaxException exception) {
            this.logging.error(exception);
        }
    }
}

