/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm;

import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.io.IOException;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class ProgramminfoDialog
extends Basisdialog {
    private final ISprachcontainer sprache;
    private final KonfigurationDTO konfiguration;
    private JLabel autorEmailLabel;
    JLabel autorHomepageLabel;
    private JLabel autorLabel;
    JLabel bernhardHublLabel;
    private JLabel copyrightLabel;
    private JLabel jLabel1;
    private JLabel jLabel12;
    JLabel jLabel18;
    private JLabel jLabel6;
    private JLabel jLabel8;
    private JLabel jLabelUsedJre;
    private JLabel lizenzLabel;
    JLabel marioWeigandLabel;
    JLabel peterWienerroitherLabel;
    private JLabel versionsLabel;
    private JLabel zuletztAktualisiertLabel;

    public ProgramminfoDialog(KonfigurationDTO konfigurationDTO) {
        super(BasisdialogId.HAUPTPROGRAMM_INFO);
        this.konfiguration = konfigurationDTO;
        this.sprache = this.getSprachcontainer();
        this.initComponents();
        this.beschrifteGUI();
        ArrayList<JComponent> arrayList = new ArrayList<JComponent>(4);
        arrayList.add(this.jLabel1);
        arrayList.add(this.jLabel6);
        arrayList.add(this.jLabel8);
        this.getGuiDesigner().addComponents(arrayList, true);
        List<Component> list = Arrays.asList(this.getContentPane().getComponents());
        list.parallelStream().filter(component -> !arrayList.contains((JComponent)component)).forEach(component -> this.getGuiDesigner().addComponent((JComponent)component, false));
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.versionsLabel = new JLabel();
        this.zuletztAktualisiertLabel = new JLabel();
        this.lizenzLabel = new JLabel();
        this.autorLabel = new JLabel();
        this.autorEmailLabel = new JLabel();
        this.autorHomepageLabel = new JLabel();
        this.jLabel6 = new JLabel();
        this.peterWienerroitherLabel = new JLabel();
        this.marioWeigandLabel = new JLabel();
        this.jLabel12 = new JLabel();
        this.copyrightLabel = new JLabel();
        this.jLabel8 = new JLabel();
        this.jLabel18 = new JLabel();
        this.bernhardHublLabel = new JLabel();
        this.jLabelUsedJre = new JLabel();
        this.setTitle("Programminformationen");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ProgramminfoDialog.this.formMouseMoved(mouseEvent);
            }
        });
        this.getContentPane().setLayout(null);
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setText("Planetensuche");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(20, 20, 150, 17);
        this.versionsLabel.setFont(new Font("Tahoma", 0, 12));
        this.versionsLabel.setText("Version 4.0.0 Beta");
        this.getContentPane().add(this.versionsLabel);
        this.versionsLabel.setBounds(20, 40, 180, 15);
        this.zuletztAktualisiertLabel.setFont(new Font("Tahoma", 0, 12));
        this.zuletztAktualisiertLabel.setText("zuletzt aktualisiert am: 09.08.2007");
        this.getContentPane().add(this.zuletztAktualisiertLabel);
        this.zuletztAktualisiertLabel.setBounds(20, 60, 280, 15);
        this.lizenzLabel.setFont(new Font("Tahoma", 0, 12));
        this.lizenzLabel.setText("Lizenz: Freeware");
        this.getContentPane().add(this.lizenzLabel);
        this.lizenzLabel.setBounds(20, 80, 170, 15);
        this.autorLabel.setFont(new Font("Tahoma", 0, 12));
        this.autorLabel.setText("Autor: Gerd Guehne (Nickname Marfir)");
        this.getContentPane().add(this.autorLabel);
        this.autorLabel.setBounds(20, 120, 380, 15);
        this.autorEmailLabel.setFont(new Font("Tahoma", 0, 12));
        this.autorEmailLabel.setText("E-Mail: gerd.guehne@googlemail.de");
        this.getContentPane().add(this.autorEmailLabel);
        this.autorEmailLabel.setBounds(20, 140, 290, 15);
        this.autorHomepageLabel.setFont(new Font("Tahoma", 0, 12));
        this.autorHomepageLabel.setText("Homepage: https://www.planetensuche.de");
        this.autorHomepageLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ProgramminfoDialog.this.autorHomepageLabelMouseMoved(mouseEvent);
            }
        });
        this.getContentPane().add(this.autorHomepageLabel);
        this.autorHomepageLabel.setBounds(20, 160, 530, 15);
        this.jLabel6.setFont(new Font("Tahoma", 1, 14));
        this.jLabel6.setText("Folgende Hobbyastronomen haben Ihre Bilder zur Verfuegung gestellt:");
        this.getContentPane().add(this.jLabel6);
        this.jLabel6.setBounds(20, 200, 540, 17);
        this.peterWienerroitherLabel.setFont(new Font("Tahoma", 0, 12));
        this.peterWienerroitherLabel.setText("Peter Wienerroither, https://peter-wienerroither.at/");
        this.peterWienerroitherLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ProgramminfoDialog.this.peterWienerroitherLabelMouseMoved(mouseEvent);
            }
        });
        this.getContentPane().add(this.peterWienerroitherLabel);
        this.peterWienerroitherLabel.setBounds(20, 220, 530, 15);
        this.marioWeigandLabel.setFont(new Font("Tahoma", 0, 12));
        this.marioWeigandLabel.setText("Mario Weigand, https://www.skytrip.de");
        this.marioWeigandLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ProgramminfoDialog.this.marioWeigandLabelMouseMoved(mouseEvent);
            }
        });
        this.getContentPane().add(this.marioWeigandLabel);
        this.marioWeigandLabel.setBounds(20, 240, 400, 15);
        this.jLabel12.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.getContentPane().add(this.jLabel12);
        this.jLabel12.setBounds(20, 400, 540, 10);
        this.copyrightLabel.setFont(new Font("Tahoma", 0, 12));
        this.copyrightLabel.setText("\u00a9 2002-2017 by Gerd Guehne");
        this.getContentPane().add(this.copyrightLabel);
        this.copyrightLabel.setBounds(30, 420, 260, 15);
        this.jLabel8.setFont(new Font("Tahoma", 1, 14));
        this.jLabel8.setText("Technische Hinweise:");
        this.getContentPane().add(this.jLabel8);
        this.jLabel8.setBounds(20, 300, 500, 17);
        this.jLabel18.setFont(new Font("Tahoma", 0, 12));
        this.jLabel18.setText("Programm komplett in Java 1.6 geschrieben, https://java.sun.com");
        this.jLabel18.setVerticalAlignment(1);
        this.jLabel18.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ProgramminfoDialog.this.jLabel18MouseMoved(mouseEvent);
            }
        });
        this.getContentPane().add(this.jLabel18);
        this.jLabel18.setBounds(20, 320, 540, 40);
        this.bernhardHublLabel.setFont(new Font("Tahoma", 0, 12));
        this.bernhardHublLabel.setText("Bernhard Hubl und Herbert Walter, http://www.astrophoton.com");
        this.bernhardHublLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent mouseEvent) {
                ProgramminfoDialog.this.bernhardHublLabelMouseMoved(mouseEvent);
            }
        });
        this.getContentPane().add(this.bernhardHublLabel);
        this.bernhardHublLabel.setBounds(20, 260, 480, 15);
        this.jLabelUsedJre.setText("verwendete JRE: 11");
        this.getContentPane().add(this.jLabelUsedJre);
        this.jLabelUsedJre.setBounds(20, 370, 480, 18);
        this.setSize(new Dimension(585, 491));
        this.setLocationRelativeTo(null);
    }

    private void beschrifteGUI() {
        this.setTitle(this.sprache.getString("h_pinfo_titel"));
        try {
            String string = this.konfiguration.getZuletztAktualisiertDatum();
            int n = LocalDate.parse(string, DateTimeFormatter.ofPattern("dd.MM.yyyy")).getYear();
            this.copyrightLabel.setText("\u00a9 2002-" + n + " by Gerd G\u00fchne");
            String string2 = this.sprache.toLocalisedDate(string);
            this.zuletztAktualisiertLabel.setText(this.sprache.getString("zuletzt_aktualisiert") + " " + string2);
        }
        catch (DateTimeParseException dateTimeParseException) {
            this.getLogger().error(dateTimeParseException);
        }
        this.versionsLabel.setText("Version " + this.konfiguration.getVersion());
        this.lizenzLabel.setText(this.sprache.getString("lizenz"));
        this.autorLabel.setText(this.sprache.getString("autor"));
        this.autorEmailLabel.setText(this.sprache.getString("email") + " gerd.guehne@googlemail.com");
        this.autorHomepageLabel.setText(this.sprache.getString("homepage") + " https://www." + this.konfiguration.getHomepageHostname() + " / https://www.exoplanet-search.com");
        this.jLabel6.setText(this.sprache.getString("h_pinfo1"));
        this.jLabel8.setText(this.sprache.getString("h_pinfo3"));
        this.jLabel18.setText("<html>" + this.sprache.getString("h_pinfo4") + ":<br><href a=\"https://www.oracle.com/technetwork/java/index.html\">www.orcale.com/technetwork/java</href></html>");
        try {
            this.jLabelUsedJre.setText(this.sprache.getString("inst_m3") + " " + JavaVersionHelperUtil.getInstalledJavaVersion());
        }
        catch (IOException iOException) {
            this.jLabelUsedJre.setText(this.sprache.getString("inst_m3") + " ???");
            this.getLogger().error(iOException);
        }
    }

    private void jLabel18MouseMoved(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(12));
    }

    private void marioWeigandLabelMouseMoved(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(12));
    }

    private void autorHomepageLabelMouseMoved(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(12));
    }

    private void formMouseMoved(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(0));
    }

    private void peterWienerroitherLabelMouseMoved(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(12));
    }

    private void bernhardHublLabelMouseMoved(MouseEvent mouseEvent) {
        this.setCursor(new Cursor(12));
    }

    void zeigeFehlermeldungWennWebseiteNichtErreichbar(Exception exception) {
        JOptionPane.showMessageDialog(this, this.sprache.getString("zeige_website") + "\n" + exception.toString(), this.sprache.getString("zeige_website_titel"), 0);
    }
}

