/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm;

import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.datamodel.api.IKoordinate;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.icons.IconPoolCustom;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.guidesigner.icons.IconPoolDevelopment;
import de.planetensuche.hauptprogramm.BenutzerStatistikUpdater;
import de.planetensuche.hauptprogramm.PlanetensucheModulLoader;
import de.planetensuche.hauptprogramm.ProgramminfoControler;
import de.planetensuche.hauptprogramm.api.IHauptprogramm;
import de.planetensuche.hauptprogramm.featurerequest.FeatureRequestController;
import de.planetensuche.hauptprogramm.konfiguration.IStartDialog;
import de.planetensuche.hauptprogramm.konfiguration.KonfigurationsdialogControler;
import de.planetensuche.hauptprogramm.threads.Diashowthread;
import de.planetensuche.hauptprogramm.threads.IntroThread;
import de.planetensuche.hauptprogramm.threads.LastVotingTimerTask;
import de.planetensuche.hauptprogramm.threads.Zeitupdater;
import de.planetensuche.hauptprogramm.threads.api.IIntroDialog;
import de.planetensuche.hauptprogramm.threads.api.IVotingLabel;
import de.planetensuche.hauptprogramm.threads.api.IZeitaktualisierGUI;
import de.planetensuche.hauptprogramm.update.UpdateDialog;
import de.planetensuche.hauptprogramm.update.UpdateFileHandler;
import de.planetensuche.hauptprogramm.update.UpdateHintergrundsucher;
import de.planetensuche.hauptprogramm.update.UpdateScriptWriter;
import de.planetensuche.hauptprogramm.voting.LastVotingLabelClickHandler;
import de.planetensuche.konfigurator.api.IBeobachtungsortkonfiguration;
import de.planetensuche.konfigurator.api.IFinsternisseKonfiguration;
import de.planetensuche.konfigurator.api.IKonfigurator;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import de.planetensuche.web.connector.voting.RemoteVotingService;
import de.planetensuche.web.connector.voting.VotingService;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Executors;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;

public final class StartDialog
extends Basisdialog
implements IZeitaktualisierGUI,
IStartDialog,
IVotingLabel {
    private static final int VOTING_TIMER_PERIOD_IN_MS = 60000;
    private static final int ASTRO_TIMER_PERIOD_IN_MS = 1000;
    private final IHauptprogramm hauptprogramm;
    private final boolean updateFortsetzen;
    private boolean showVoting = true;
    private VotingService votingService;
    private LastVotingLabelClickHandler lastVotingLabelClickHandler;
    private Thread intro;
    private JLabel utLabel;
    private JLabel jdLabel;
    private JLabel greenwichSternzeitLabel;
    private JLabel lokaleSternzeitLabel;
    private JLabel lastVotingLabel;
    private IKonfigurator konfigurator;
    private KonfigurationDTO globalConfig;
    private final IBeobachtungsortkonfiguration beobachtungsortKonfiguration;
    private PlanetensucheModulLoader planetensucheModulLoader;
    private Timer astroTimer;
    private Timer votingTimer;
    private FeatureRequestController featureRequestController;
    private JMenuItem datenbank;
    private JLabel deltaAquaridenLabel;
    private JLabel deltaAquaridenWert;
    private JMenuItem einstellung;
    private JLabel etaAquaridenLabel;
    private JLabel etaAquaridenWert;
    private JMenuItem formeln;
    private JLabel geminidenLabel;
    private JLabel geminidenWert;
    private JMenuItem hilfe;
    private JLabel hintergrundbild;
    private JMenuItem info;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel7;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenu jMenu3;
    private JMenuBar jMenuBar1;
    private JSeparator jSeparatorDown;
    private JSeparator jSeparatorTop;
    private JMenuItem leben;
    private JLabel leonidenLabel;
    private JLabel leonidenWert;
    private JLabel lyridenLabel;
    private JLabel lyridenWert;
    private JMenuItem menuItemReportBugImprovement;
    private JMenuItem menuStarMap;
    private JLabel mondfinsternis;
    private JLabel orionidenLabel;
    private JLabel orionidenWert;
    private JLabel perseidenLabel;
    private JLabel perseidenWert;
    private JLabel quadrantidenLabel;
    private JLabel quadrantidenWert;
    private JMenuItem quiz;
    private JMenuItem simulationen;
    private JLabel sonnenfinsternis;
    private JLabel tauridenLabel;
    private JLabel tauridenWert;
    private JMenuItem umrechner;
    private JMenuItem update;
    private JLabel ursidenLabel;
    private JLabel ursidenWert;
    private JMenuItem votingMenuItem;

    public StartDialog(IHauptprogramm iHauptprogramm, boolean bl, boolean bl2) {
        super(BasisdialogId.HAUPTPROGRAMM_HAUPTFENSTER);
        this.hauptprogramm = iHauptprogramm;
        this.updateFortsetzen = bl2;
        this.beobachtungsortKonfiguration = KonfiguratorFabrik.getBeobachtungskonfiguration();
        this.initComponents();
        this.setSize(765, 520);
        this.resizeToCenter(this.getWidth(), this.getHeight());
        this.erzeugeVotingLabel();
        this.erzeugeZeitangabenLabels();
        this.beschrifteGUI();
        this.setCursor(new Cursor(3));
        this.getGuiDesigner().addComponent(this.jLabel1, true);
        this.getGuiDesigner().addComponent(this.jLabel7, true);
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            if (this.getContentPane().getComponent(i).equals(this.jLabel1) || this.getContentPane().getComponent(i).equals(this.jLabel7)) continue;
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
        if (bl) {
            this.setVisible(false);
            this.setzteInstallationFort();
        } else {
            this.starteNormal();
        }
    }

    @Override
    public void hideDialog() {
        this.setVisible(false);
    }

    @Override
    public void starteNormal() {
        Object object;
        this.setVisible(true);
        this.hintergrundbild.setBounds(0, 0, this.getWidth(), this.getHeight());
        String string = "hintergrund" + File.separator + "hauptprogramm.jpg";
        this.hintergrundbild.setIcon(new ImageIcon(string));
        this.konfigurator = KonfiguratorFabrik.getKonfigurator();
        this.pruefeAufPlanetensucheNew();
        try {
            this.globalConfig = this.konfigurator.read();
        }
        catch (IOException iOException) {
            this.getLogger().error(iOException);
            JOptionPane.showMessageDialog(this, "Da die Programmeinstellungen nicht richtig geladen werden konnten,\n wird das Programm ggf. nicht richtig funktionieren!\nThe program settings can't read completly! Likely in the next time more errors occours...\n" + iOException.toString(), "Fehler beim Einlesen der Einstellungen / can't read the program settings", 0);
            this.globalConfig = this.konfigurator.getDefault();
        }
        this.showVoting = this.globalConfig.isVotingActive();
        char[] cArray = new char[]{'a', 'n', 'y'};
        this.votingService = new RemoteVotingService(cArray, this.globalConfig.getHomepageHostname(), this.globalConfig.getPort());
        GuiDesignerFabrik.init(this.globalConfig.getSchriftgroesseInPixel());
        this.getLogger().setLogdateigroesseInKB(this.globalConfig.getLogFileInKb());
        this.getLogger().setLevel(this.globalConfig.getLogLevel());
        this.getLogger().info("Planetensuche gestartet...");
        this.getLogger().info("Planetensuche-Version " + this.globalConfig.getVersion());
        this.getLogger().info("Einstellungen geladen fuer: " + this.globalConfig.getBeobachtungsortLand().name() + ", " + this.globalConfig.getBeobachtungsortStadt());
        this.getLogger().debug("debug Modus enabled");
        if (this.getLogger().isDebugEnabled()) {
            try {
                this.getLogger().debug("wird lokale jre verwendet? " + JavaVersionHelperUtil.isLocalJreAvailable());
                this.getLogger().debug("aktueller jre pfad? " + JavaVersionHelperUtil.getCurrentJavaPath());
                this.getLogger().debug("installierte jre version? " + JavaVersionHelperUtil.getInstalledJavaVersion());
            }
            catch (IOException iOException) {
                this.getLogger().error(iOException);
            }
        }
        if (this.globalConfig.isIntroZeigen()) {
            this.zeigeGUIKomponenten(false);
            final int n = this.getWidth();
            object = new IIntroDialog(){

                @Override
                public int getWidth() {
                    return n;
                }

                @Override
                public void finishIntro() {
                    StartDialog.this.zeigeGUIKomponenten(true);
                    StartDialog.this.starteGUIAktualisiererThreadUndUpdateThreadUndStarteDiashow();
                }
            };
            this.intro = new IntroThread((IIntroDialog)object, this.hintergrundbild);
            this.intro.start();
        } else {
            this.starteGUIAktualisiererThreadUndUpdateThreadUndStarteDiashow();
        }
        new UpdateFileHandler().verarbeiteUpdateDatei();
        this.ladeFinsternisse();
        new UpdateScriptWriter().aktualisiereBatchDateien(this.globalConfig.getVersion(), this.globalConfig.getXmxInMB());
        if (this.updateFortsetzen) {
            try {
                this.getLogger().info("setzte nach Update des Updaters Update-Prozess fort...");
                Runtime.getRuntime().exec(JavaVersionHelperUtil.getCurrentJavaPath() + " -Xmx" + this.globalConfig.getXmxInMB() + "m -XX:+UseStringDeduplication -jar updater.jar " + this.globalConfig.getVersion() + " -update");
                this.dispose();
                this.hauptprogramm.programmSchliessen(this, 0);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        } else {
            BenutzerStatistikUpdater benutzerStatistikUpdater = new BenutzerStatistikUpdater(this.globalConfig);
            object = Executors.newSingleThreadExecutor();
            object.execute(benutzerStatistikUpdater);
            this.setVisible(true);
        }
        this.planetensucheModulLoader = new PlanetensucheModulLoader(this, this.globalConfig);
        this.addVotingClickHandler(this.planetensucheModulLoader);
    }

    public void zeigeGUIKomponenten(boolean bl) {
        for (Component component : this.getContentPane().getComponents()) {
            if (component.equals(this.hintergrundbild)) continue;
            component.setVisible(bl);
        }
    }

    public void starteGUIAktualisiererThreadUndUpdateThreadUndStarteDiashow() {
        this.setCursor(new Cursor(0));
        boolean bl = this.globalConfig.isFilmFensterZeigen();
        if (bl) {
            int n = this.getWidth() - 170;
            this.hintergrundbild.setBounds(n, 0, 160, 160);
            Timer timer = new Timer();
            timer.schedule((TimerTask)new Diashowthread(this.hintergrundbild), 100L, 4000L);
        } else {
            this.hintergrundbild.setVisible(false);
        }
        if (this.globalConfig.isNachUpdatesSuchen()) {
            this.starteUpdateSucher();
        }
        this.pruefeObVersionAelterAlsEinJahr();
        this.starteZeitaktualisierer();
        if (this.showVoting) {
            this.starteLastVotingTimer();
        }
    }

    @Override
    public void setLastVotingText(String string) {
        this.lastVotingLabel.setText(string);
    }

    @Override
    public void disableVotingOverview() {
        this.votingMenuItem.setEnabled(false);
        this.lastVotingLabel.setEnabled(false);
        this.lastVotingLabel.removeMouseListener(this.lastVotingLabelClickHandler);
    }

    private void beschrifteMeteorstroeme() {
        this.quadrantidenLabel.setText(this.i18n.getString("h_meteorstrom_quadrantiden"));
        this.quadrantidenWert.setText(this.i18n.getString("h_meteorstrom_quadrantiden_wert"));
        this.lyridenLabel.setText(this.i18n.getString("h_meteorstrom_lyriden"));
        this.lyridenWert.setText(this.i18n.getString("h_meteorstrom_lyriden_wert"));
        this.etaAquaridenLabel.setText(this.i18n.getString("h_meteorstrom_etaAquariden"));
        this.etaAquaridenWert.setText(this.i18n.getString("h_meteorstrom_etaAquariden_wert"));
        this.deltaAquaridenLabel.setText(this.i18n.getString("h_meteorstrom_deltaAquariden"));
        this.deltaAquaridenWert.setText(this.i18n.getString("h_meteorstrom_deltaAquariden_wert"));
        this.perseidenLabel.setText(this.i18n.getString("h_meteorstrom_perseiden"));
        this.perseidenWert.setText(this.i18n.getString("h_meteorstrom_perseiden_wert"));
        this.orionidenLabel.setText(this.i18n.getString("h_meteorstrom_orioniden"));
        this.orionidenWert.setText(this.i18n.getString("h_meteorstrom_orioniden_wert"));
        this.tauridenLabel.setText(this.i18n.getString("h_meteorstrom_tauriden"));
        this.tauridenWert.setText(this.i18n.getString("h_meteorstrom_tauriden_wert"));
        this.leonidenLabel.setText(this.i18n.getString("h_meteorstrom_leoniden"));
        this.leonidenWert.setText(this.i18n.getString("h_meteorstrom_leoniden_wert"));
        this.geminidenLabel.setText(this.i18n.getString("h_meteorstrom_geminiden"));
        this.geminidenWert.setText(this.i18n.getString("h_meteorstrom_geminiden_wert"));
        this.ursidenLabel.setText(this.i18n.getString("h_meteorstrom_ursiden"));
        this.ursidenWert.setText(this.i18n.getString("h_meteorstrom_ursiden_wert"));
    }

    private void starteZeitaktualisierer() {
        try {
            if (this.astroTimer != null || this.globalConfig == null) {
                return;
            }
            this.getLogger().info("Timer gestartet am: " + new Date().toString());
            IKoordinate iKoordinate = this.globalConfig.getBeobachtungsortKoordinate();
            String string = this.globalConfig.getZeitzoneFuerBeobachtungsort();
            Zeitupdater zeitupdater = new Zeitupdater(this.i18n, iKoordinate, string, this);
            this.astroTimer = new Timer("astroTimer");
            this.astroTimer.schedule((TimerTask)zeitupdater, 100L, 1000L);
        }
        catch (NumberFormatException numberFormatException) {
            this.getLogger().error(numberFormatException);
            JOptionPane.showMessageDialog(this, this.i18n.getString("start_jd_error"), this.i18n.getString("start_jd_error_titel"), 0);
        }
    }

    private void ladeFinsternisse() {
        try {
            IFinsternisseKonfiguration iFinsternisseKonfiguration = KonfiguratorFabrik.getFinsternisseKonfiguration(this.i18n.isAktuelleSpracheDeutsch());
            iFinsternisseKonfiguration.lesen();
            this.mondfinsternis.setText(iFinsternisseKonfiguration.getNaechsteMondfinsternis());
            this.sonnenfinsternis.setText(iFinsternisseKonfiguration.getNaechsteSonnenfinsternis());
        }
        catch (IOException iOException) {
            this.getLogger().error(iOException);
            JOptionPane.showMessageDialog(this, this.i18n.getString("finsternis_error") + "\n" + iOException.toString(), this.i18n.getString("finsternis_error_titel"), 0);
        }
    }

    private void pruefeAufPlanetensucheNew() {
        try {
            boolean bl = this.konfigurator.updateConfigurationFromOldConfFile();
            this.globalConfig = this.konfigurator.read();
            if (bl) {
                this.getLogger().info("Update der planetensuche.conf und globalConfig.xml auf " + this.globalConfig.getVersion() + " erfolgreich!");
                JOptionPane.showMessageDialog(this, "Planetensuche auf neuste Version aktualisiert!\nPlanetensuche was successfuly updated!", "Update abgeschlossen / Update successful", 1);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.getLogger().info("keine planetensuche.new gefunden...");
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, "Fehler beim Installieren des neuen Updates!\nPlanetensuche wasn't update successfuly!", "Update abgebrochen / Update canceled", 0);
        }
    }

    private void starteUpdateSucher() {
        try {
            UpdateHintergrundsucher updateHintergrundsucher = new UpdateHintergrundsucher(this.globalConfig.getVersion(), this.i18n, this.hauptprogramm, this.globalConfig.getUpdateUrl(), this.globalConfig.getXmxInMB());
            updateHintergrundsucher.start();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            this.getLogger().error("Fehler beim CheckUpdate starten", illegalThreadStateException);
        }
    }

    private void pruefeObVersionAelterAlsEinJahr() {
        int n = Integer.parseInt(this.globalConfig.getZuletztAktualisiertDatum().substring(0, 2));
        int n2 = Integer.parseInt(this.globalConfig.getZuletztAktualisiertDatum().substring(3, 5));
        int n3 = Integer.parseInt(this.globalConfig.getZuletztAktualisiertDatum().substring(6, 10));
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.set(n3 + 1, n2, n);
        if (gregorianCalendar.before(new GregorianCalendar())) {
            JOptionPane.showMessageDialog(this, this.i18n.getString("h_m1"), this.i18n.getString("h_m1_titel"), 2);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.mondfinsternis = new JLabel();
        this.sonnenfinsternis = new JLabel();
        this.jLabel7 = new JLabel();
        this.quadrantidenLabel = new JLabel();
        this.lyridenLabel = new JLabel();
        this.quadrantidenWert = new JLabel();
        this.lyridenWert = new JLabel();
        this.etaAquaridenLabel = new JLabel();
        this.etaAquaridenWert = new JLabel();
        this.deltaAquaridenLabel = new JLabel();
        this.deltaAquaridenWert = new JLabel();
        this.perseidenLabel = new JLabel();
        this.perseidenWert = new JLabel();
        this.orionidenLabel = new JLabel();
        this.orionidenWert = new JLabel();
        this.tauridenLabel = new JLabel();
        this.tauridenWert = new JLabel();
        this.leonidenLabel = new JLabel();
        this.leonidenWert = new JLabel();
        this.geminidenLabel = new JLabel();
        this.geminidenWert = new JLabel();
        this.ursidenLabel = new JLabel();
        this.ursidenWert = new JLabel();
        this.hintergrundbild = new JLabel();
        this.jSeparatorTop = new JSeparator();
        this.jSeparatorDown = new JSeparator();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.leben = new JMenuItem();
        this.formeln = new JMenuItem();
        this.simulationen = new JMenuItem();
        this.datenbank = new JMenuItem();
        this.menuStarMap = new JMenuItem();
        this.umrechner = new JMenuItem();
        this.quiz = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.einstellung = new JMenuItem();
        this.votingMenuItem = new JMenuItem();
        this.update = new JMenuItem();
        this.jMenu3 = new JMenu();
        this.hilfe = new JMenuItem();
        this.menuItemReportBugImprovement = new JMenuItem();
        this.info = new JMenuItem();
        this.setDefaultCloseOperation(0);
        this.setTitle("Planetensuche");
        this.setCursor(new Cursor(0));
        this.setResizable(false);
        this.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                StartDialog.this.formFocusGained(focusEvent);
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                StartDialog.this.formFocusLost(focusEvent);
            }
        });
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowGainedFocus(WindowEvent windowEvent) {
                StartDialog.this.formWindowGainedFocus(windowEvent);
            }

            @Override
            public void windowLostFocus(WindowEvent windowEvent) {
                StartDialog.this.formWindowLostFocus(windowEvent);
            }
        });
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                StartDialog.this.formWindowClosing(windowEvent);
            }

            @Override
            public void windowActivated(WindowEvent windowEvent) {
                StartDialog.this.formWindowActivated(windowEvent);
            }

            @Override
            public void windowDeactivated(WindowEvent windowEvent) {
                StartDialog.this.formWindowDeactivated(windowEvent);
            }
        });
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent keyEvent) {
                StartDialog.this.formKeyPressed(keyEvent);
            }
        });
        this.getContentPane().setLayout(null);
        this.jLabel1.setFont(new Font("Tahoma", 1, 14));
        this.jLabel1.setText("aktuelles (Zeitangaben nach MEZ):");
        this.getContentPane().add(this.jLabel1);
        this.jLabel1.setBounds(20, 20, 370, 17);
        this.jLabel2.setFont(new Font("Tahoma", 0, 12));
        this.jLabel2.setText("in Deutschland sichtbar:");
        this.getContentPane().add(this.jLabel2);
        this.jLabel2.setBounds(20, 50, 180, 15);
        this.jLabel3.setFont(new Font("Tahoma", 0, 12));
        this.jLabel3.setText("naechte Mondfinsternis:");
        this.getContentPane().add(this.jLabel3);
        this.jLabel3.setBounds(20, 80, 170, 15);
        this.jLabel4.setFont(new Font("Tahoma", 0, 12));
        this.jLabel4.setText("naechte Sonnenfinsternis:");
        this.getContentPane().add(this.jLabel4);
        this.jLabel4.setBounds(20, 100, 170, 15);
        this.mondfinsternis.setFont(new Font("Tahoma", 0, 12));
        this.mondfinsternis.setText("07.09.2006 um 19:51 (partiell)");
        this.getContentPane().add(this.mondfinsternis);
        this.mondfinsternis.setBounds(190, 80, 320, 14);
        this.sonnenfinsternis.setFont(new Font("Tahoma", 0, 12));
        this.sonnenfinsternis.setText("01.08.2008 um 11:21 Uhr (partiell)");
        this.getContentPane().add(this.sonnenfinsternis);
        this.sonnenfinsternis.setBounds(190, 100, 320, 15);
        this.jLabel7.setFont(new Font("Tahoma", 1, 14));
        this.jLabel7.setText("Meteorstroeme (fuer mittlere noerdliche Breiten, Auswahl):");
        this.getContentPane().add(this.jLabel7);
        this.jLabel7.setBounds(20, 140, 500, 17);
        this.quadrantidenLabel.setFont(new Font("Tahoma", 0, 12));
        this.quadrantidenLabel.setText("Quadrantiden:");
        this.getContentPane().add(this.quadrantidenLabel);
        this.quadrantidenLabel.setBounds(20, 170, 130, 15);
        this.lyridenLabel.setFont(new Font("Tahoma", 0, 12));
        this.lyridenLabel.setText("Lyriden:");
        this.getContentPane().add(this.lyridenLabel);
        this.lyridenLabel.setBounds(20, 190, 100, 15);
        this.quadrantidenWert.setFont(new Font("Tahoma", 0, 12));
        this.quadrantidenWert.setText("01.01. - 05.01. (Maximum 03.01.); rund 120 Meteore/h");
        this.getContentPane().add(this.quadrantidenWert);
        this.quadrantidenWert.setBounds(190, 170, 470, 15);
        this.lyridenWert.setFont(new Font("Tahoma", 0, 12));
        this.lyridenWert.setText("16.04. - 25.04. (Maximum 22.04.); rund 18 Meteore/h");
        this.getContentPane().add(this.lyridenWert);
        this.lyridenWert.setBounds(190, 190, 480, 15);
        this.etaAquaridenLabel.setFont(new Font("Tahoma", 0, 12));
        this.etaAquaridenLabel.setText("Eta-Aquariden:");
        this.getContentPane().add(this.etaAquaridenLabel);
        this.etaAquaridenLabel.setBounds(20, 210, 120, 15);
        this.etaAquaridenWert.setFont(new Font("Tahoma", 0, 12));
        this.etaAquaridenWert.setText("19.04. - 28.05. (Maximum 05.05.); rund 60 Meteore/h");
        this.getContentPane().add(this.etaAquaridenWert);
        this.etaAquaridenWert.setBounds(190, 210, 470, 15);
        this.deltaAquaridenLabel.setFont(new Font("Tahoma", 0, 12));
        this.deltaAquaridenLabel.setText("Delta-Aquariden:");
        this.getContentPane().add(this.deltaAquaridenLabel);
        this.deltaAquaridenLabel.setBounds(20, 230, 130, 15);
        this.deltaAquaridenWert.setFont(new Font("Tahoma", 0, 12));
        this.deltaAquaridenWert.setText("12.07. - 19.08. (Maximum 28.07.); rund 20 Meteore/h");
        this.getContentPane().add(this.deltaAquaridenWert);
        this.deltaAquaridenWert.setBounds(190, 230, 470, 15);
        this.perseidenLabel.setFont(new Font("Tahoma", 0, 12));
        this.perseidenLabel.setText("Perseiden:");
        this.getContentPane().add(this.perseidenLabel);
        this.perseidenLabel.setBounds(20, 250, 130, 15);
        this.perseidenWert.setFont(new Font("Tahoma", 0, 12));
        this.perseidenWert.setText("17.07. - 24.08. (Maximum 12.08.); rund 100 Meteore/h");
        this.getContentPane().add(this.perseidenWert);
        this.perseidenWert.setBounds(190, 250, 470, 15);
        this.orionidenLabel.setFont(new Font("Tahoma", 0, 12));
        this.orionidenLabel.setText("Orioniden:");
        this.getContentPane().add(this.orionidenLabel);
        this.orionidenLabel.setBounds(20, 270, 130, 15);
        this.orionidenWert.setFont(new Font("Tahoma", 0, 12));
        this.orionidenWert.setText("02.10. - 07.11. (Maximum 21.10.); rund 23 Meteore/h");
        this.getContentPane().add(this.orionidenWert);
        this.orionidenWert.setBounds(190, 270, 470, 15);
        this.tauridenLabel.setFont(new Font("Tahoma", 0, 12));
        this.tauridenLabel.setText("noerdliche Tauriden:");
        this.getContentPane().add(this.tauridenLabel);
        this.tauridenLabel.setBounds(20, 290, 160, 15);
        this.tauridenWert.setFont(new Font("Tahoma", 0, 12));
        this.tauridenWert.setText("01.10. - 25.11. (Maximum 12.11.); rund 5 Meteore/h");
        this.getContentPane().add(this.tauridenWert);
        this.tauridenWert.setBounds(190, 290, 470, 15);
        this.leonidenLabel.setFont(new Font("Tahoma", 0, 12));
        this.leonidenLabel.setText("Leoniden:");
        this.getContentPane().add(this.leonidenLabel);
        this.leonidenLabel.setBounds(20, 310, 130, 15);
        this.leonidenWert.setFont(new Font("Tahoma", 0, 12));
        this.leonidenWert.setText("14.11. - 21.11. (Maximum 19.11.); >100 Meteore/h");
        this.getContentPane().add(this.leonidenWert);
        this.leonidenWert.setBounds(190, 310, 470, 15);
        this.geminidenLabel.setFont(new Font("Tahoma", 0, 12));
        this.geminidenLabel.setText("Geminiden:");
        this.getContentPane().add(this.geminidenLabel);
        this.geminidenLabel.setBounds(20, 330, 120, 15);
        this.geminidenWert.setFont(new Font("Tahoma", 0, 12));
        this.geminidenWert.setText("07.12. - 17.12. (Maximum 14.12.); rund 120 Meteore/h");
        this.getContentPane().add(this.geminidenWert);
        this.geminidenWert.setBounds(190, 330, 470, 15);
        this.ursidenLabel.setFont(new Font("Tahoma", 0, 12));
        this.ursidenLabel.setText("Ursiden:");
        this.getContentPane().add(this.ursidenLabel);
        this.ursidenLabel.setBounds(20, 350, 130, 15);
        this.ursidenWert.setFont(new Font("Tahoma", 0, 12));
        this.ursidenWert.setText("17.12. - 26.12. (Maximum 22.12.); rund 10 Meteore/h");
        this.getContentPane().add(this.ursidenWert);
        this.ursidenWert.setBounds(190, 350, 470, 15);
        this.hintergrundbild.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.hintergrundbild.setDoubleBuffered(true);
        this.hintergrundbild.setOpaque(true);
        this.getContentPane().add(this.hintergrundbild);
        this.hintergrundbild.setBounds(470, 0, 150, 150);
        this.getContentPane().add(this.jSeparatorTop);
        this.jSeparatorTop.setBounds(0, 370, 670, 10);
        this.getContentPane().add(this.jSeparatorDown);
        this.jSeparatorDown.setBounds(0, 390, 670, 10);
        this.jMenu1.setText("Module");
        this.leben.setText("Entstehung von Leben (F3)");
        this.leben.setToolTipText("Welche Voraussetzungen benoetigen Lebewesen?");
        this.leben.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.lebenActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.leben);
        this.formeln.setText("Formelsammlung (F4)");
        this.formeln.setToolTipText("Formeln aus Physik und Astronomie");
        this.formeln.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.formelnActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.formeln);
        this.simulationen.setText("Simulationen (F5)");
        this.simulationen.setToolTipText("Diagramme, Sternenkarte, Planetenbahnen etc.");
        this.simulationen.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.simulationenActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.simulationen);
        this.datenbank.setText("Datenbank (F6)");
        this.datenbank.setToolTipText("Daten mit Erklaerung und Bild, Rekorde, etc.");
        this.datenbank.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.datenbankActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.datenbank);
        this.menuStarMap.setText("sternkarte");
        this.menuStarMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.menuStarMapActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.menuStarMap);
        this.umrechner.setText("Umrechner (F7)");
        this.umrechner.setToolTipText("Entfernungseinheiten umrechen mit Vergleich");
        this.umrechner.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.umrechnerActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.umrechner);
        this.quiz.setText("Quiz (F8)");
        this.quiz.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.quizActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.quiz);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Optionen");
        this.einstellung.setText("Einstellungen");
        this.einstellung.setToolTipText("Programmeinstellungen aendern");
        this.einstellung.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.einstellungActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.einstellung);
        this.votingMenuItem.setText("Voting Statistik");
        this.votingMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.votingMenuItemActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.votingMenuItem);
        this.update.setText("Update");
        this.update.setToolTipText("das Programm ueber das Internet aktualisieren");
        this.update.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.updateActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.update);
        this.jMenuBar1.add(this.jMenu2);
        this.jMenu3.setText("Hilfe");
        this.hilfe.setText("Programmhilfe (F1)");
        this.hilfe.setToolTipText("Readme mit FAQ, Versionshistory etc.");
        this.hilfe.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.hilfeActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.hilfe);
        this.menuItemReportBugImprovement.setText("bug melden");
        this.menuItemReportBugImprovement.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.menuItemReportBugImprovementActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.menuItemReportBugImprovement);
        this.info.setText("Info (F2)");
        this.info.setToolTipText("ueber das Programm und den Autor");
        this.info.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                StartDialog.this.infoActionPerformed(actionEvent);
            }
        });
        this.jMenu3.add(this.info);
        this.jMenuBar1.add(this.jMenu3);
        this.setJMenuBar(this.jMenuBar1);
        this.setSize(new Dimension(691, 468));
        this.setLocationRelativeTo(null);
    }

    @Override
    public synchronized void setTextUT(String string) {
        this.utLabel.setText(string);
    }

    @Override
    public synchronized void setTextJD(String string) {
        this.jdLabel.setText(string);
    }

    @Override
    public synchronized void setTextGreenwichSternzeit(String string) {
        this.greenwichSternzeitLabel.setText(string);
        this.greenwichSternzeitLabel.setToolTipText(string);
    }

    @Override
    public synchronized void setTextLokaleSternzeit(String string) {
        this.lokaleSternzeitLabel.setText(string);
        this.lokaleSternzeitLabel.setToolTipText(string);
    }

    private void erzeugeZeitangabenLabels() {
        int n = this.getHeight() - 100;
        this.utLabel = new JLabel();
        this.utLabel.setHorizontalAlignment(0);
        this.utLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.getContentPane().add(this.utLabel);
        this.utLabel.setBounds(10, n, 95, 20);
        this.jdLabel = new JLabel();
        this.jdLabel.setHorizontalAlignment(this.utLabel.getHorizontalAlignment());
        this.jdLabel.setBorder(this.utLabel.getBorder());
        this.getContentPane().add(this.jdLabel);
        this.jdLabel.setBounds(105, n, 140, 20);
        this.greenwichSternzeitLabel = new JLabel();
        this.greenwichSternzeitLabel.setHorizontalAlignment(this.utLabel.getHorizontalAlignment());
        this.greenwichSternzeitLabel.setBorder(this.utLabel.getBorder());
        this.getContentPane().add(this.greenwichSternzeitLabel);
        this.greenwichSternzeitLabel.setBounds(245, n, 275, 20);
        this.lokaleSternzeitLabel = new JLabel();
        this.lokaleSternzeitLabel.setHorizontalAlignment(this.utLabel.getHorizontalAlignment());
        this.lokaleSternzeitLabel.setBorder(this.utLabel.getBorder());
        this.getContentPane().add(this.lokaleSternzeitLabel);
        this.lokaleSternzeitLabel.setBounds(520, n, 235, 20);
    }

    private void beschrifteGUI() {
        this.jMenu1.setText(this.i18n.getString("h_module"));
        this.leben.setText(this.i18n.getString("h_leben"));
        this.leben.setToolTipText(this.i18n.getString("h_leben_tipp"));
        this.leben.setIcon(new ImageIcon(IconPoolCustom.MODUL_LEBEN.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.formeln.setText(this.i18n.getString("h_formeln"));
        this.formeln.setToolTipText(this.i18n.getString("h_formeln_tipp"));
        this.formeln.setIcon(new ImageIcon(IconPoolCustom.MODUL_FORMELSAMMLUNG.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.simulationen.setText(this.i18n.getString("h_simulationen"));
        this.simulationen.setToolTipText(this.i18n.getString("h_simulationen_tipp"));
        this.simulationen.setIcon(new ImageIcon(IconPoolCustom.MODUL_SIMULATIONEN.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.datenbank.setText(this.i18n.getString("h_datenbank"));
        this.datenbank.setToolTipText(this.i18n.getString("h_datenbank_tipp"));
        this.datenbank.setIcon(new ImageIcon(IconPoolCustom.MODUL_DATENBANK.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.menuStarMap.setText(this.i18n.getString("sim_gui67"));
        this.menuStarMap.setIcon(new ImageIcon(IconPoolCustom.STERNBILD_ORION.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.umrechner.setText(this.i18n.getString("h_umrechner"));
        this.umrechner.setToolTipText(this.i18n.getString("h_umrechner_tipp"));
        this.umrechner.setIcon(new ImageIcon(IconPoolCustom.MODUL_UMRECHNER.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.quiz.setText(this.i18n.getString("h_quiz"));
        this.quiz.setToolTipText(this.i18n.getString("h_quiz_tipp"));
        this.quiz.setIcon(new ImageIcon(IconPoolCustom.MODUL_QUIZ.getImageIcon().getImage().getScaledInstance(39, 29, 4)));
        this.jMenu2.setText(this.i18n.getString("h_optionen"));
        this.einstellung.setText(this.i18n.getString("h_einstellungen"));
        this.einstellung.setToolTipText(this.i18n.getString("h_einstellungen_tipp"));
        this.einstellung.setIcon(IconPoolDefault.PREFERENCES.getImageIcon());
        this.votingMenuItem.setText(this.i18n.getString("h_voting_overview"));
        this.votingMenuItem.setIcon(IconPoolDefault.HISTORY.getImageIcon());
        this.update.setText(this.i18n.getString("h_update"));
        this.update.setToolTipText(this.i18n.getString("h_update_tipp"));
        this.update.setIcon(IconPoolDefault.INTERNET_SEARCH.getImageIcon());
        this.jMenu3.setText(this.i18n.getString("h_hilfe"));
        this.hilfe.setText(this.i18n.getString("h_programmhilfe"));
        this.hilfe.setToolTipText(this.i18n.getString("h_programmhilfe_tipp"));
        this.hilfe.setIcon(IconPoolDefault.HELP.getImageIcon());
        this.info.setText(this.i18n.getString("h_info"));
        this.info.setToolTipText(this.i18n.getString("h_info_tipp"));
        this.info.setIcon(IconPoolDefault.INFO.getImageIcon());
        this.menuItemReportBugImprovement.setText(this.i18n.getString("h_bugmelden"));
        this.menuItemReportBugImprovement.setIcon(IconPoolDevelopment.INTERNET.getImageIcon());
        this.jLabel1.setText(this.i18n.getString("ueberschrift1"));
        this.jLabel2.setText(this.i18n.getString("indsichtbar"));
        this.jLabel3.setText(this.i18n.getString("naechstemondf"));
        this.jLabel4.setText(this.i18n.getString("naechstesonnenf"));
        this.jLabel7.setText(this.i18n.getString("ueberschrift2"));
        this.utLabel.setToolTipText(this.i18n.getString("h_ut_tipp"));
        this.jdLabel.setToolTipText(this.i18n.getString("h_jd_tipp"));
        this.greenwichSternzeitLabel.setToolTipText(this.i18n.getString("mdgreenwich"));
        this.lokaleSternzeitLabel.setToolTipText(this.i18n.getString("mdsternzeit"));
        this.beschrifteMeteorstroeme();
    }

    private void formKeyPressed(KeyEvent keyEvent) {
        if (keyEvent.getKeyCode() == 112) {
            this.starteHilfe();
        } else if (keyEvent.getKeyCode() == 113) {
            this.zeigeProgramminfo();
        } else if (keyEvent.getKeyCode() == 114) {
            this.planetensucheModulLoader.starteLeben();
        } else if (keyEvent.getKeyCode() == 115) {
            this.planetensucheModulLoader.starteFormelsammlung();
        } else if (keyEvent.getKeyCode() == 116) {
            this.planetensucheModulLoader.starteSimulation();
        } else if (keyEvent.getKeyCode() == 117) {
            this.planetensucheModulLoader.starteDatenbank();
        } else if (keyEvent.getKeyCode() == 118) {
            this.planetensucheModulLoader.starteUmrechner();
        } else if (keyEvent.getKeyCode() == 119) {
            this.planetensucheModulLoader.starteQuiz();
        }
    }

    private void zeigeProgramminfo() {
        ProgramminfoControler programminfoControler = new ProgramminfoControler(this.globalConfig);
        programminfoControler.showDialog();
    }

    private void updateActionPerformed(ActionEvent actionEvent) {
        UpdateDialog updateDialog = new UpdateDialog(this.hauptprogramm, this.globalConfig);
        updateDialog.setVisible(true);
    }

    private void starteHilfe() {
        try {
            File file = new File(this.i18n.getLinkZumHandbuch());
            if (this.globalConfig.isStandardBrowser() && Desktop.isDesktopSupported()) {
                Desktop.getDesktop().open(file);
            } else if (!this.globalConfig.isStandardBrowser()) {
                Runtime.getRuntime().exec(this.globalConfig.getBrowserpfad() + " \"" + file.getAbsolutePath() + "\"");
            }
        }
        catch (IOException iOException) {
            this.getLogger().error(iOException);
            JOptionPane.showMessageDialog(this, this.i18n.getString("start_hilfe-starten_ioException") + "\n" + iOException.toString(), this.i18n.getString("start_hilfe-starten_error_titel"), 0);
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, this.i18n.getString("start_hilfe-starten_error") + "\n" + exception.toString(), this.i18n.getString("start_hilfe-starten_error_titel"), 0);
        }
    }

    private void hilfeActionPerformed(ActionEvent actionEvent) {
        this.starteHilfe();
    }

    private void einstellungActionPerformed(ActionEvent actionEvent) {
        KonfigurationsdialogControler konfigurationsdialogControler = new KonfigurationsdialogControler(this.beobachtungsortKonfiguration, BeanFactory.getInjector().getInstance(IDatenbankService.class));
        konfigurationsdialogControler.showDialog(false);
    }

    private void umrechnerActionPerformed(ActionEvent actionEvent) {
        this.planetensucheModulLoader.starteUmrechner();
    }

    private void simulationenActionPerformed(ActionEvent actionEvent) {
        this.planetensucheModulLoader.starteSimulation();
    }

    private void formelnActionPerformed(ActionEvent actionEvent) {
        this.planetensucheModulLoader.starteFormelsammlung();
    }

    private void lebenActionPerformed(ActionEvent actionEvent) {
        this.planetensucheModulLoader.starteLeben();
    }

    private void datenbankActionPerformed(ActionEvent actionEvent) {
        this.planetensucheModulLoader.starteDatenbank();
    }

    private void infoActionPerformed(ActionEvent actionEvent) {
        this.zeigeProgramminfo();
    }

    private void formWindowClosing(WindowEvent windowEvent) {
        this.hauptprogramm.programmSchliessen(this, -1);
    }

    private void quizActionPerformed(ActionEvent actionEvent) {
        this.planetensucheModulLoader.starteQuiz();
    }

    private void menuItemReportBugImprovementActionPerformed(ActionEvent actionEvent) {
        if (this.featureRequestController == null) {
            this.featureRequestController = new FeatureRequestController(this.globalConfig);
        }
        this.featureRequestController.showDialog();
    }

    private void votingMenuItemActionPerformed(ActionEvent actionEvent) {
        MouseListener[] mouseListenerArray;
        for (MouseListener mouseListener : mouseListenerArray = this.lastVotingLabel.getMouseListeners()) {
            mouseListener.mouseClicked(null);
        }
    }

    private void menuStarMapActionPerformed(ActionEvent actionEvent) {
        this.planetensucheModulLoader.starteSternenkarte();
    }

    private void formWindowLostFocus(WindowEvent windowEvent) {
        if (this.astroTimer != null) {
            this.astroTimer.cancel();
            this.astroTimer.purge();
            this.astroTimer = null;
        }
        if (this.votingTimer != null) {
            this.votingTimer.cancel();
            this.votingTimer.purge();
            this.votingTimer = null;
        }
    }

    private void formWindowGainedFocus(WindowEvent windowEvent) {
        this.starteZeitaktualisierer();
        this.starteLastVotingTimer();
    }

    private void formWindowDeactivated(WindowEvent windowEvent) {
        if (this.astroTimer != null) {
            this.astroTimer.cancel();
            this.astroTimer.purge();
            this.astroTimer = null;
        }
        if (this.votingTimer != null) {
            this.votingTimer.cancel();
            this.votingTimer.purge();
            this.votingTimer = null;
        }
    }

    private void formWindowActivated(WindowEvent windowEvent) {
        this.starteZeitaktualisierer();
        this.starteLastVotingTimer();
    }

    private void formFocusGained(FocusEvent focusEvent) {
        this.starteZeitaktualisierer();
        this.starteLastVotingTimer();
    }

    private void formFocusLost(FocusEvent focusEvent) {
        if (this.astroTimer != null) {
            this.astroTimer.cancel();
            this.astroTimer.purge();
            this.astroTimer = null;
        }
        if (this.votingTimer != null) {
            this.votingTimer.cancel();
            this.votingTimer.purge();
            this.votingTimer = null;
        }
    }

    private void setzteInstallationFort() {
        this.setVisible(false);
        IDatenbankService iDatenbankService = BeanFactory.getInjector().getInstance(IDatenbankService.class);
        KonfigurationsdialogControler konfigurationsdialogControler = new KonfigurationsdialogControler(this, this.beobachtungsortKonfiguration, iDatenbankService);
        konfigurationsdialogControler.showDialog(true);
    }

    private void erzeugeVotingLabel() {
        this.jSeparatorTop.setBounds(10, this.getHeight() - 145, this.getWidth() - 20, 20);
        this.jSeparatorDown.setBounds(10, this.getHeight() - 110, this.getWidth() - 20, 20);
        int n = this.getHeight() - 135;
        this.lastVotingLabel = new JLabel();
        this.lastVotingLabel.setHorizontalAlignment(2);
        this.lastVotingLabel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.getContentPane().add(this.lastVotingLabel);
        this.lastVotingLabel.setBounds(10, n, this.getWidth() - 20, 20);
        this.lastVotingLabel.setToolTipText(this.i18n.getString("h_voting_click"));
    }

    private void addVotingClickHandler(PlanetensucheModulLoader planetensucheModulLoader) {
        this.lastVotingLabelClickHandler = new LastVotingLabelClickHandler(this, this.lastVotingLabel, this.votingService, planetensucheModulLoader);
        this.lastVotingLabel.addMouseListener(this.lastVotingLabelClickHandler);
    }

    private void starteLastVotingTimer() {
        if (this.votingTimer == null && this.votingService != null) {
            LastVotingTimerTask lastVotingTimerTask = new LastVotingTimerTask(this.i18n, this, this.votingService);
            this.votingTimer = new Timer("votingTimer");
            this.votingTimer.schedule((TimerTask)lastVotingTimerTask, 500L, 60000L);
        }
    }
}

