/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm;

import de.planetensuche.bugreport.main.BugreportDialog;
import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.dateihelfer.ScriptWriter;
import de.planetensuche.datenbank.Start;
import de.planetensuche.datenbankkern.BeanFactory;
import de.planetensuche.datenbankkern.Datenbanksteuerer;
import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.datenbankkern.impl.intern.DatabaseInitialisationException;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LogLevel;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.hauptprogramm.Observer;
import de.planetensuche.hauptprogramm.StartDialog;
import de.planetensuche.hauptprogramm.api.IHauptprogramm;
import de.planetensuche.hauptprogramm.install.BetriebssystemerkennungDialog;
import de.planetensuche.hauptprogramm.install.InstallationCountService;
import de.planetensuche.konfigurator.api.IKonfigurator;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import de.planetensuche.mutex.IMutex;
import de.planetensuche.mutex.Mutex;
import de.planetensuche.mutex.ProcessTypes;
import java.awt.HeadlessException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public final class StartPlanetensuche
implements IHauptprogramm {
    private static ILogging logger;
    private IMutex processBlocker;
    private final AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();

    private void initHauptprogramm() throws IOException {
        this.processBlocker = new Mutex(ProcessTypes.HAUPTPROGRAMM);
        if (this.processBlocker.istBereitsGestartet() || !this.processBlocker.isBereit()) {
            logger.warn("Planetensuche-Modul bereits gestartet...");
            int n = JOptionPane.showConfirmDialog(null, "Das Modul wurde bereits gestartet und kann nicht nochmals gestartet werden! (siehe Handbuch)\nThe program is already running and can't run in more as one instance! (see user guide - folder handbuch)\n\nFalls Planetensuche vorher abgest\u00fcrzt war und Sie sich sicher sind, dass es nicht mehr l\u00e4uft, best\u00e4tigen Sie bitte den Start mit ja.\nIf Planetensuche crashed before and you are sure that the program did not run currently, then please confirm the startup with yes.", "Modul laeuft bereits / Modul is already running", 1);
            if (n == 0) {
                this.processBlocker.alleProzesseBeenden();
            } else {
                StartPlanetensuche.exit(1);
            }
        }
        this.processBlocker.prozessGestartet();
        File file = new File(KonfiguratorFabrik.KONFIG_DATEI_GLOBAL);
        if (file.exists()) {
            logger.info("normaler Start");
            File file2 = new File("updater.new");
            this.oeffneHauptprogramm(false, file2.exists());
        } else {
            logger.info("starte Installation...");
            BetriebssystemerkennungDialog betriebssystemerkennungDialog = new BetriebssystemerkennungDialog(this);
            betriebssystemerkennungDialog.setVisible(true);
            betriebssystemerkennungDialog.zeigeSprachauswahl();
        }
    }

    @Override
    public void programmSchliessen(JFrame jFrame, int n) {
        this.asyncLoadingScreenCallbackExecutor.execute(jFrame, () -> {
            try {
                Datenbanksteuerer.schliessen();
            }
            catch (SQLException sQLException) {
                logger.error(sQLException);
            }
            logger.debug("prozess log bereinigen...");
            try {
                this.processBlocker.prozessBeendet();
            }
            catch (IOException iOException) {
                logger.error(iOException);
            }
            this.asyncLoadingScreenCallbackExecutor.disableWaitingDialog();
            logger.debug("fertig; system.exit aufrufen...");
            logger.info("-----------------------------------------");
            StartPlanetensuche.exit(n);
        });
    }

    protected static void initDatenbankService(JFrame jFrame, SternbildSprache sternbildSprache, String string, Observer observer) {
        AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
        asyncLoadingScreenCallbackExecutor.execute(jFrame, () -> {
            try {
                String string2 = new File("").getAbsolutePath() + "/database" + File.separator + string;
                logger.debug("\u00f6ffne Datenbank " + string2);
                Datenbanksteuerer.oeffnen(true, string2);
                IDatenbankService iDatenbankService = BeanFactory.getInjector().getInstance(IDatenbankService.class);
                iDatenbankService.setSternbildsprache(sternbildSprache);
                logger.debug("Datenbank mit '" + string + "' hochgefahren...");
                observer.finished();
            }
            catch (DatabaseInitialisationException | IOException | ClassNotFoundException | SQLException exception) {
                logger.error(exception);
            }
        });
    }

    public static void main(String[] stringArray) {
        try {
            StartPlanetensuche.createLogger();
            IKonfigurator iKonfigurator = KonfiguratorFabrik.getKonfigurator();
            KonfigurationDTO konfigurationDTO = iKonfigurator.getDefault();
            LoggingFactory.addBugreport(new BugreportDialog(konfigurationDTO));
            logger.setLevel(LogLevel.INFO);
            StartPlanetensuche.checkJavaFxAvailable();
            GuiDesignerFabrik.init(12);
            StartPlanetensuche.updateKonfigToHigherXmx(stringArray);
            if (stringArray == null || stringArray.length == 0) {
                logger.info("Planetensuche ohne Argumente gestartet...");
                StartPlanetensuche.runWithoutArguments();
            } else {
                logger.info("Planetensuche mit Argumenten '" + Arrays.toString(stringArray) + "' gestartet...");
                StartPlanetensuche.runWithArguments(stringArray, konfigurationDTO);
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            logger.error(illegalArgumentException);
        }
        catch (IOException iOException) {
            logger.error(iOException);
            StartPlanetensuche.exit(1);
        }
    }

    private static void runWithArguments(String[] stringArray, KonfigurationDTO konfigurationDTO) {
        if ("check".equals(stringArray[0])) {
            System.out.println("ok");
            return;
        }
        AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
        asyncLoadingScreenCallbackExecutor.execute(null, () -> {
            logger.setLevel(konfigurationDTO.getLogLevel());
            logger.debug("init DB...");
            StartPlanetensuche.initDatenbankService(null, konfigurationDTO.getSternbildSprache(), konfigurationDTO.getDatenbankName(), () -> {
                try {
                    logger.debug("call Datenbank Modul main mit args: " + Arrays.toString(stringArray));
                    Start.main(stringArray);
                }
                catch (IOException iOException) {
                    logger.error(iOException);
                    StartPlanetensuche.exit(1);
                }
            });
        });
    }

    private static void runWithoutArguments() throws IOException {
        StartPlanetensuche startPlanetensuche = new StartPlanetensuche();
        startPlanetensuche.initHauptprogramm();
    }

    private static void checkJavaFxAvailable() throws HeadlessException {
        try {
            Class.forName("javafx.embed.swing.JFXPanel");
        }
        catch (ClassNotFoundException classNotFoundException) {
            JOptionPane.showMessageDialog(null, "Kein JavaFX verf\u00fcgbar! Bitte installieren Sie das Oracle Java mit JavaFX.\nNo JavaFX available! Please install a Orcale Java with JavaFX.", "Schwerer Fehler / Fatal Error", 0);
            StartPlanetensuche.exit(1);
        }
    }

    private static void createLogger() throws HeadlessException {
        logger = LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG);
        if (!logger.isBereit()) {
            JOptionPane.showMessageDialog(null, "Fehler beim Erstellen der Logdatei 'planetensuche.log'!\nCan't create the logfile 'planetensuche.log'!", "Schwerer Fehler / Fatal Error", 0);
            StartPlanetensuche.exit(1);
        }
    }

    static void updateKonfigToHigherXmx(String[] stringArray) {
        try {
            Object object;
            int n = 2560;
            int n2 = Math.round(Runtime.getRuntime().maxMemory() / 1024L / 1024L);
            System.out.println("current process will not use more then " + n2 + " MB");
            IKonfigurator iKonfigurator = KonfiguratorFabrik.getKonfigurator();
            KonfigurationDTO konfigurationDTO = iKonfigurator.read();
            int n3 = konfigurationDTO.getXmxInMB();
            if (n3 >= n && n2 >= n) {
                return;
            }
            if (n3 < n) {
                System.out.println("zu wenig Speicher, erh\u00f6he auf 2,5 GB / not enough memory, increase to 2.5 GB");
                if (logger != null) {
                    logger.info("zu wenig Speicher, erh\u00f6he auf 2,5 GB / not enough memory, increase to 2.5 GB");
                }
                konfigurationDTO.setXmxInMB(n);
                iKonfigurator.write(konfigurationDTO);
                object = new ScriptWriter();
                ((ScriptWriter)object).writeScripts(n, null);
            }
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            if (logger == null) {
                throw new IllegalStateException("logger ist unerwartet null, wird aber ab hier ben\u00f6tigt");
            }
            object = JavaVersionHelperUtil.getCurrentJavaPath() + " -Xmx" + n + "m -XX:+UseStringDeduplication -jar planetensuche.jar " + stringArray[0] + (String)(stringArray.length > 1 ? " " + stringArray[1] : "");
            String string = "starte neue Instanz mit mehr heap size: " + (String)object;
            logger.info(string);
            System.out.println(string);
            Process process = Runtime.getRuntime().exec((String)object);
            StartPlanetensuche.readProcessOutputInExtraThreads(process);
            int n4 = process.waitFor();
            logger.info("neue Instanz beendet mit Status " + n4 + ", beende Prozess...");
            StartPlanetensuche.exit(0);
        }
        catch (FileNotFoundException fileNotFoundException) {
            LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG).debug(fileNotFoundException);
        }
        catch (IOException | InterruptedException | RuntimeException exception) {
            LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG).error("Fehler beim erh\u00f6hen des ben\u00f6tigen Speichers", exception);
            StartPlanetensuche.exit(1);
        }
    }

    private static void readProcessOutputInExtraThreads(Process process) throws InterruptedException {
        Callable<Void> callable = () -> {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    System.out.println(string);
                }
            }
            return null;
        };
        Callable<Void> callable2 = () -> {
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));){
                String string;
                while ((string = bufferedReader.readLine()) != null) {
                    System.err.println(string);
                }
            }
            return null;
        };
        Executors.newFixedThreadPool(2).invokeAll(List.of(callable, callable2));
    }

    private static void exit(int n) {
        SwingUtilities.invokeLater(() -> System.exit(n));
    }

    private void oeffneHauptprogramm(boolean bl, boolean bl2) {
        StartDialog startDialog = new StartDialog(this, bl, bl2);
        if (!bl) {
            startDialog.setVisible(true);
            InstallationCountService installationCountService = new InstallationCountService();
            installationCountService.sendInstallationCountIfNecessary();
        }
    }

    @Override
    public void setzteInstallationFort() {
        logger.info("erzeuge Standardkonfiguration...");
        IKonfigurator iKonfigurator = KonfiguratorFabrik.getKonfigurator();
        try {
            iKonfigurator.updateConfigurationFromOldConfFile();
            this.oeffneHauptprogramm(true, false);
        }
        catch (IOException iOException) {
            logger.error(iOException);
        }
    }
}

