/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.featurerequest;

import de.planetensuche.core.Check;
import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.hauptprogramm.featurerequest.FeatureRequestDialog;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.web.connector.featurerequest.FeatureRequestClientService;
import de.planetensuche.web.connector.featurerequest.FeatureRequestDtoV1;
import de.planetensuche.web.connector.featurerequest.FeatureRequestSaveFailedException;
import de.planetensuche.web.connector.featurerequest.FeatureRequestType;
import de.planetensuche.web.connector.featurerequest.PlanetensucheModul;
import java.awt.Desktop;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import javax.swing.JOptionPane;

public class FeatureRequestController {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private final FeatureRequestDialog dialog;
    private final FeatureRequestClientService restService;
    private final KonfigurationDTO globalConfig;

    public FeatureRequestController(KonfigurationDTO konfigurationDTO) {
        this.globalConfig = konfigurationDTO;
        this.restService = new FeatureRequestClientService(konfigurationDTO);
        this.dialog = new FeatureRequestDialog();
        this.dialog.getSendButton().addActionListener(actionEvent -> {
            if (this.isRequiredFieldEmpty()) {
                JOptionPane.showMessageDialog(this.dialog, this.dialog.getI18n().getString("h_m1"), this.dialog.getI18n().getString("h_m1_title"), 1);
                return;
            }
            if (this.isDescribtionTooLong()) {
                JOptionPane.showMessageDialog(this.dialog, this.dialog.getI18n().getString("h_m4"), this.dialog.getI18n().getString("h_m4_title"), 1);
                return;
            }
            this.sendFeatureRequest();
        });
        this.dialog.getOpenMantis().addActionListener(actionEvent -> this.openMantisBt(konfigurationDTO));
    }

    private void openMantisBt(KonfigurationDTO konfigurationDTO) {
        try {
            if (Desktop.isDesktopSupported()) {
                Desktop.getDesktop().browse(new URI("https://www." + konfigurationDTO.getHomepageHostname() + "/mantis/"));
            }
        }
        catch (IOException | URISyntaxException exception) {
            this.logger.error(exception);
        }
    }

    private void sendFeatureRequest() {
        FeatureRequestDtoV1 featureRequestDtoV1 = new FeatureRequestDtoV1();
        try {
            String string = this.dialog.getBugOrImprovement().getSelectedItem().toString();
            if (this.dialog.getI18n().getString("h_gui9").equals(string)) {
                featureRequestDtoV1.setType(FeatureRequestType.BUG);
            } else {
                featureRequestDtoV1.setType(FeatureRequestType.FEATURE);
            }
            String string2 = this.dialog.getEffectedModule().getSelectedItem().toString();
            featureRequestDtoV1.setModule(this.getSelectedModule(string2));
            featureRequestDtoV1.setDescribtion(this.dialog.getDescribtion().getText());
            featureRequestDtoV1.setEmailAnswer(this.dialog.getEmail().getText());
            featureRequestDtoV1.setHostname(InetAddress.getLocalHost().getHostName());
            featureRequestDtoV1.setJavaVersion(JavaVersionHelperUtil.getInstalledJavaVersion());
            featureRequestDtoV1.setPlanetensucheVersion(this.globalConfig.getVersion());
            featureRequestDtoV1.setPlanetensucheLanguage(this.globalConfig.getSprache());
            featureRequestDtoV1.setOsName(System.getProperty("os.name").replaceAll(" ", "_"));
            featureRequestDtoV1.setOsLanguage(System.getProperty("user.language"));
            this.logger.info("send bug/feature request: " + featureRequestDtoV1.toString());
            this.restService.save(featureRequestDtoV1);
            JOptionPane.showMessageDialog(this.dialog, this.dialog.getI18n().getString("h_m2"), this.dialog.getI18n().getString("h_m2_title"), 1);
            this.hideDialog();
        }
        catch (UnknownHostException unknownHostException) {
            JOptionPane.showMessageDialog(this.dialog, this.dialog.getI18n().getString("db_m450"), this.dialog.getI18n().getString("h_m3_title"), 2);
        }
        catch (FeatureRequestSaveFailedException | IOException exception) {
            JOptionPane.showMessageDialog(this.dialog, this.dialog.getI18n().getString("h_m3"), this.dialog.getI18n().getString("h_m3_title"), 0);
            this.logger.error("fail to send " + featureRequestDtoV1.toString(), exception);
        }
    }

    private boolean isRequiredFieldEmpty() {
        return Check.isEmpty(this.dialog.getBugOrImprovement().getSelectedItem()) || Check.isEmpty(this.dialog.getEffectedModule().getSelectedItem()) || Check.isEmpty(this.dialog.getDescribtion().getText());
    }

    public void showDialog() {
        this.dialog.setVisible(true);
    }

    public void hideDialog() {
        this.dialog.setVisible(false);
    }

    private PlanetensucheModul getSelectedModule(String string) {
        if (this.dialog.getI18n().getString("h_gui_genesis").equals(string)) {
            return PlanetensucheModul.GENESIS;
        }
        if (this.dialog.getI18n().getString("h_gui_formula").equals(string)) {
            return PlanetensucheModul.FORMULA;
        }
        if (this.dialog.getI18n().getString("h_gui_db").equals(string)) {
            return PlanetensucheModul.DATABASE;
        }
        if (this.dialog.getI18n().getString("h_gui_simulation").equals(string)) {
            return PlanetensucheModul.SIMULATION;
        }
        if (this.dialog.getI18n().getString("h_gui_starmap").equals(string)) {
            return PlanetensucheModul.STAR_MAP;
        }
        if (this.dialog.getI18n().getString("h_gui_calc").equals(string)) {
            return PlanetensucheModul.CALCULATOR;
        }
        if (this.dialog.getI18n().getString("h_gui_quiz").equals(string)) {
            return PlanetensucheModul.QUIZ;
        }
        return PlanetensucheModul.GENERAL;
    }

    private boolean isDescribtionTooLong() {
        return this.dialog.getDescribtion().getText().length() > 2048;
    }
}

