/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.install;

import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.hauptprogramm.api.IHauptprogramm;
import de.planetensuche.hauptprogramm.install.LizenzDialog;
import de.planetensuche.hauptprogramm.install.Zugriffsrechte;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;

public final class BetriebssystemerkennungDialog
extends Basisdialog {
    public static final String RUN_PATH = System.getProperty("user.dir");
    private final IHauptprogramm hauptprogramm;
    private JLabel anforderungen;
    private JLabel info;
    private JLabel jre;
    private JLabel os;
    private JButton weiterButton;

    public BetriebssystemerkennungDialog(IHauptprogramm iHauptprogramm) {
        super(BasisdialogId.HAUPTPROGRAMM_BETRIEBSSYSTEM_ERKENNUNG);
        this.hauptprogramm = iHauptprogramm;
        this.initComponents();
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
    }

    public void zeigeSprachauswahl() {
        try {
            Object object;
            this.setVisible(false);
            Object[] objectArray = new Object[this.i18n.getUnterstuetzteSprachen().size()];
            int n = 0;
            Object object2 = this.i18n.getUnterstuetzteSprachen().iterator();
            while (object2.hasNext()) {
                objectArray[n] = object = object2.next();
                ++n;
            }
            object2 = Locale.GERMANY.equals(Locale.getDefault()) || Locale.GERMAN.equals(Locale.getDefault()) ? objectArray[0] : objectArray[1];
            object = JOptionPane.showInputDialog(this, "Bitte waehlen Sie eine Sprache aus.\nPlease select a language.", "Sprache auswaehlen / Coose your language", 3, null, objectArray, object2);
            if (object == null) {
                this.hauptprogramm.programmSchliessen(this, 0);
                return;
            }
            String string = object.toString();
            this.getLogger().info("Sprache '" + string + "' ausgew\u00e4hlt");
            this.i18n.setAktuelleSprache(string);
            this.setTitle(this.i18n.getString("inst_fenster2"));
            this.info.setText(this.i18n.getString("inst_m1"));
            this.anforderungen.setText(this.i18n.getString("inst_m2"));
            this.weiterButton.setText(this.i18n.getString("inst_gui3"));
            this.setVisible(true);
            Zugriffsrechte zugriffsrechte = new Zugriffsrechte(RUN_PATH);
            zugriffsrechte.pruefeZugriffsrechte();
            this.pruefeJavaRE();
            this.pruefeBetriebssystem();
        }
        catch (Exception exception) {
            this.getLogger().error(exception);
            JOptionPane.showMessageDialog(this, exception.getLocalizedMessage(), "Error", 0);
            this.hauptprogramm.programmSchliessen(this, -1);
        }
    }

    private void pruefeJavaRE() {
        block7: {
            try {
                this.jre.setText("<html>" + this.i18n.getString("inst_m3") + " " + JavaVersionHelperUtil.getInstalledJavaVersion() + "</html>");
                if (JavaVersionHelperUtil.isRequiredVersionAlreadyInstalled()) break block7;
                if (JavaVersionHelperUtil.isVersionNewerAndUntested()) {
                    try {
                        JavaVersionHelperUtil.showJavaUpdateRequiredMessage(this, this.i18n.getHtmlString("inst_m13"), this.i18n.getString("inst_m13_titel"));
                    }
                    catch (IOException | URISyntaxException exception) {
                        this.getLogger().error(exception);
                    }
                    break block7;
                }
                try {
                    JavaVersionHelperUtil.showJavaUpdateRequiredMessage(this, this.i18n.getHtmlString("inst_m12"), this.i18n.getString("inst_m12_titel"));
                }
                catch (IOException | URISyntaxException exception) {
                    this.getLogger().error(exception);
                }
                this.hauptprogramm.programmSchliessen(this, 0);
            }
            catch (IOException iOException) {
                this.getLogger().error(iOException);
                this.hauptprogramm.programmSchliessen(this, -1);
            }
        }
    }

    private void pruefeBetriebssystem() {
        String string = System.getProperty("os.name");
        String string2 = this.i18n.getString("inst_m5") + " " + string;
        if (string.contains("Windows") || string.contains("Linux")) {
            string2 = string2 + " .......... OK";
        } else {
            LoggingFactory.getLoggerForClass(this.getClass()).warn("found unsupported os '" + string + "'");
            string2 = string2 + " .......... " + this.i18n.getString("inst_m6");
            JOptionPane.showMessageDialog(this, this.i18n.getString("inst_m7"), this.i18n.getString("inst_m7_titel"), 2);
        }
        this.os.setText("<html>" + string2.replaceAll("<html>", "").replaceAll("</html>", "") + "</html>");
    }

    private void initComponents() {
        this.info = new JLabel();
        this.weiterButton = new JButton();
        this.anforderungen = new JLabel();
        this.os = new JLabel();
        this.jre = new JLabel();
        this.setDefaultCloseOperation(3);
        this.setTitle("Planetensuche Konfigurationsprogramm v1.3");
        this.setResizable(false);
        this.getContentPane().setLayout(null);
        this.info.setText("jLabel1");
        this.getContentPane().add(this.info);
        this.info.setBounds(10, 10, 500, 180);
        this.weiterButton.setText("weiter");
        this.weiterButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BetriebssystemerkennungDialog.this.weiterButtonActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add(this.weiterButton);
        this.weiterButton.setBounds(420, 480, 90, 24);
        this.anforderungen.setText("jLabel1");
        this.getContentPane().add(this.anforderungen);
        this.anforderungen.setBounds(10, 190, 500, 130);
        this.os.setText("jLabel1");
        this.getContentPane().add(this.os);
        this.os.setBounds(10, 360, 500, 100);
        this.jre.setText("jLabel1");
        this.getContentPane().add(this.jre);
        this.jre.setBounds(10, 330, 500, 18);
        this.setSize(new Dimension(535, 548));
        this.setLocationRelativeTo(null);
    }

    private void weiterButtonActionPerformed(ActionEvent actionEvent) {
        try {
            LizenzDialog lizenzDialog = new LizenzDialog(this.hauptprogramm);
            lizenzDialog.setVisible(true);
            this.setVisible(false);
        }
        catch (IOException iOException) {
            this.getLogger().error(iOException);
        }
    }
}

