/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.install;

import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import de.planetensuche.web.connector.install.InstallationCountClientService;
import de.planetensuche.web.connector.install.InstallationCountDtoV1;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.concurrent.Executors;
import org.apache.commons.io.FileUtils;

public class InstallationCountService {
    private final String notSendFileName = "temp/not_send.data";
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());

    public void sendInstallationCountIfNecessary() {
        File file = new File("temp/not_send.data");
        if (file.exists()) {
            Executors.newSingleThreadExecutor().submit(() -> {
                try {
                    InstallationCountDtoV1 installationCountDtoV1 = this.loadUnsendDto();
                    KonfigurationDTO konfigurationDTO = KonfiguratorFabrik.getKonfigurator().read();
                    InstallationCountClientService installationCountClientService = new InstallationCountClientService(konfigurationDTO);
                    if (installationCountClientService.save(installationCountDtoV1)) {
                        this.logger.debug("installation count was sucessfully send later; delete temp file...");
                        FileUtils.deleteQuietly(file);
                    }
                }
                catch (IOException iOException) {
                    this.logger.warn("failed to send again installation count", iOException);
                }
            });
        }
    }

    public boolean countInstallation() {
        InstallationCountDtoV1 installationCountDtoV1 = null;
        try {
            KonfigurationDTO konfigurationDTO = KonfiguratorFabrik.getKonfigurator().read();
            installationCountDtoV1 = this.mapTo(konfigurationDTO);
            InstallationCountClientService installationCountClientService = new InstallationCountClientService(konfigurationDTO);
            if (installationCountClientService.save(installationCountDtoV1)) {
                this.logger.debug("installation count successfully send");
                return true;
            }
            this.logger.warn("send installation count failed, data: " + String.valueOf(installationCountDtoV1));
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
        }
        if (installationCountDtoV1 != null) {
            this.saveTempDataFile(installationCountDtoV1);
        }
        return false;
    }

    private void saveTempDataFile(InstallationCountDtoV1 installationCountDtoV1) {
        try {
            String string = installationCountDtoV1.toCsv();
            File file = new File("temp/not_send.data");
            FileUtils.write(file, (CharSequence)string, StandardCharsets.UTF_8);
        }
        catch (IOException iOException) {
            this.logger.warn("fail to save temp file for installation count", iOException);
        }
    }

    private InstallationCountDtoV1 loadUnsendDto() throws IOException {
        File file = new File("temp/not_send.data");
        String string = FileUtils.readFileToString(file, StandardCharsets.UTF_8);
        return InstallationCountDtoV1.fromCsv(string);
    }

    InstallationCountDtoV1 mapTo(KonfigurationDTO konfigurationDTO) throws IOException {
        InstallationCountDtoV1 installationCountDtoV1 = new InstallationCountDtoV1();
        installationCountDtoV1.setPlanetensucheVersion(konfigurationDTO.getVersion());
        installationCountDtoV1.setPlanetensucheSprache(konfigurationDTO.getSprache());
        installationCountDtoV1.setOsName(System.getProperty("os.name").replaceAll(" ", "_"));
        installationCountDtoV1.setOsSprache(System.getProperty("user.language"));
        installationCountDtoV1.setJavaVersion(JavaVersionHelperUtil.getInstalledJavaVersion());
        installationCountDtoV1.setInternalVm(JavaVersionHelperUtil.isLocalJreAvailable());
        this.logger.debug(installationCountDtoV1.toString());
        return installationCountDtoV1;
    }
}

