/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.konfiguration;

import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.JComboBoxExtended;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.hauptprogramm.install.InstallationCountService;
import de.planetensuche.hauptprogramm.konfiguration.IStartDialog;
import de.planetensuche.hauptprogramm.konfiguration.api.KonfigDialogFachlich;
import de.planetensuche.hauptprogramm.konfiguration.fachlich.FachlichAllgemeinDto;
import de.planetensuche.hauptprogramm.konfiguration.fachlich.KonfigurationssubdialogFachlich;
import de.planetensuche.hauptprogramm.konfiguration.technisch.KonfigurationssubdialogTechnisch;
import de.planetensuche.hauptprogramm.konfiguration.technisch.TechnischDto;
import de.planetensuche.konfigurator.api.Land;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.io.File;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;

public final class Konfigurationsdialog
extends Basisdialog {
    private KonfigurationssubdialogTechnisch technikSubDialog;
    private KonfigurationssubdialogFachlich fachlichSubDialog;
    private final IStartDialog hauptprogrammDialog;
    private JLabel meldungsLabel;
    JButton speichernButton;
    JTabbedPane tabbedPane;
    private JToolBar toolBar;

    public Konfigurationsdialog(TechnischDto technischDto, FachlichAllgemeinDto fachlichAllgemeinDto) {
        super(BasisdialogId.HAUPTPROGRAMM_KONFIG);
        this.hauptprogrammDialog = null;
        this.init(technischDto, fachlichAllgemeinDto);
    }

    public Konfigurationsdialog(IStartDialog iStartDialog, TechnischDto technischDto, FachlichAllgemeinDto fachlichAllgemeinDto) {
        super(BasisdialogId.HAUPTPROGRAMM_KONFIG);
        this.hauptprogrammDialog = iStartDialog;
        this.init(technischDto, fachlichAllgemeinDto);
        this.setDefaultCloseOperation(0);
        JOptionPane.showMessageDialog(null, this.i18n.getString("inst_m11"), this.i18n.getString("inst_m11_titel"), 1);
        this.hauptprogrammDialog.hideDialog();
    }

    private void init(TechnischDto technischDto, FachlichAllgemeinDto fachlichAllgemeinDto) {
        this.initComponents();
        this.toolBar.setFloatable(false);
        this.beschrifteGUI();
        this.initTabs(technischDto, fachlichAllgemeinDto);
        for (Component component : this.getContentPane().getComponents()) {
            this.getGuiDesigner().addComponent((JComponent)component, false);
        }
    }

    private void initTabs(TechnischDto technischDto, FachlichAllgemeinDto fachlichAllgemeinDto) {
        this.technikSubDialog = new KonfigurationssubdialogTechnisch();
        this.fachlichSubDialog = new KonfigurationssubdialogFachlich();
        this.tabbedPane.addTab(this.i18n.getString("h_einstellungen_g20"), this.technikSubDialog);
        this.tabbedPane.addTab(this.i18n.getString("h_einstellungen_g21"), this.fachlichSubDialog);
        try {
            this.technikSubDialog.setzeDaten(technischDto);
            this.fachlichSubDialog.setzeDaten(fachlichAllgemeinDto);
        }
        catch (IOException iOException) {
            this.meldungsLabel.setText(this.i18n.getString("h_einstellungen_fehler3"));
            this.getLogger().error(iOException);
        }
        SwingUtilities.updateComponentTreeUI(this.fachlichSubDialog);
    }

    private void beschrifteGUI() {
        this.setTitle(this.i18n.getString("h_einstellungen_titel"));
        this.meldungsLabel.setText("");
        this.speichernButton.setText(null);
        this.speichernButton.setIcon(IconPoolDefault.SAVE.getImageIcon());
        this.speichernButton.setToolTipText(this.i18n.getString("h_einstellungen_g15"));
    }

    private void initComponents() {
        this.toolBar = new JToolBar();
        this.speichernButton = new JButton();
        this.meldungsLabel = new JLabel();
        this.tabbedPane = new JTabbedPane();
        this.setDefaultCloseOperation(2);
        this.setAlwaysOnTop(true);
        this.setMinimumSize(new Dimension(357, 400));
        this.setPreferredSize(new Dimension(357, 400));
        this.getContentPane().setLayout(new BorderLayout());
        this.toolBar.setRollover(true);
        this.speichernButton.setText("speichernButton");
        this.speichernButton.setFocusable(false);
        this.speichernButton.setHorizontalTextPosition(0);
        this.speichernButton.setVerticalTextPosition(3);
        this.toolBar.add(this.speichernButton);
        this.meldungsLabel.setText("Speichern war erfolgreich!");
        this.toolBar.add(this.meldungsLabel);
        this.getContentPane().add((Component)this.toolBar, "First");
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        this.setSize(new Dimension(558, 502));
        this.setLocationRelativeTo(null);
    }

    public KonfigDialogFachlich getFachlichSubDialog() {
        return this.fachlichSubDialog;
    }

    public void nachDemSpeichern() {
        this.meldungsLabel.setText(this.i18n.getString("h_einstellungen_gesichert"));
        if (this.hauptprogrammDialog != null) {
            try {
                InstallationCountService installationCountService = new InstallationCountService();
                installationCountService.countInstallation();
                this.setDefaultCloseOperation(2);
                if (Desktop.isDesktopSupported()) {
                    Desktop.getDesktop().open(new File(this.i18n.getLinkZumHandbuch()));
                }
                this.hauptprogrammDialog.starteNormal();
            }
            catch (IOException iOException) {
                this.getLogger().error(iOException);
            }
        }
    }

    public void nachDemSpeichern(IOException iOException) {
        this.meldungsLabel.setText(this.i18n.getString("h_einstellungen_fehler") + "\n" + iOException.toString());
    }

    public TechnischDto getTechnischDto() throws IOException {
        return this.technikSubDialog.holeDaten();
    }

    public FachlichAllgemeinDto getFachlichDto() {
        return this.fachlichSubDialog.holeDaten();
    }

    public JComboBoxExtended<Land> getBeobachtungslandComboBox() {
        return this.fachlichSubDialog.getBeobachtungslandComboBox();
    }

    public JComboBox getOrt() {
        return this.fachlichSubDialog.getOrt();
    }

    public JButton getOrtHinzufuegenButton() {
        return this.fachlichSubDialog.getOrtHinzufuegenButton();
    }

    public void fehlerBeiAuswahlDesOrts() {
        JOptionPane.showMessageDialog(this, this.i18n.getString("h_einstellungen_fehler4"), this.i18n.getString("h_einstellungen_fehler4_titel"), 0);
    }
}

