/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.konfiguration;

import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.JComboBoxExtended;
import de.planetensuche.hauptprogramm.konfiguration.IStartDialog;
import de.planetensuche.hauptprogramm.konfiguration.Konfigurationsdialog;
import de.planetensuche.hauptprogramm.konfiguration.fachlich.FachlichAllgemeinDto;
import de.planetensuche.hauptprogramm.konfiguration.fachlich.KonfigurationsServiceFachlich;
import de.planetensuche.hauptprogramm.konfiguration.neuerOrt.BeobachtungsortControler;
import de.planetensuche.hauptprogramm.konfiguration.neuerOrt.BeobachtungsortService;
import de.planetensuche.hauptprogramm.konfiguration.technisch.KonfigurationsServiceTechnisch;
import de.planetensuche.hauptprogramm.konfiguration.technisch.TechnischDto;
import de.planetensuche.konfigurator.api.IBeobachtungsortkonfiguration;
import de.planetensuche.konfigurator.api.IKonfigurator;
import de.planetensuche.konfigurator.api.Land;
import de.planetensuche.konfigurator.impl.KonfiguratorFabrik;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.List;
import javax.swing.JOptionPane;

public final class KonfigurationsdialogControler {
    private final ILogging logger = LoggingFactory.getLoggerForClass(this.getClass());
    private Konfigurationsdialog dialog;
    private KonfigurationsServiceFachlich serviceFachlich;
    private KonfigurationsServiceTechnisch serviceTechnisch;
    private final IBeobachtungsortkonfiguration ortKonfigService;
    private final IDatenbankService datenbankService;
    private boolean firstOpen;

    public KonfigurationsdialogControler(IBeobachtungsortkonfiguration iBeobachtungsortkonfiguration, IDatenbankService iDatenbankService) {
        this.ortKonfigService = iBeobachtungsortkonfiguration;
        this.datenbankService = iDatenbankService;
        this.initServices();
        this.initDialog(null);
    }

    public KonfigurationsdialogControler(IStartDialog iStartDialog, IBeobachtungsortkonfiguration iBeobachtungsortkonfiguration, IDatenbankService iDatenbankService) {
        this.ortKonfigService = iBeobachtungsortkonfiguration;
        this.datenbankService = iDatenbankService;
        this.initServices();
        this.initDialog(iStartDialog);
    }

    private ActionListener erzeugeActionListenerFuerBeobachtungsland() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JComboBoxExtended<Land> jComboBoxExtended = KonfigurationsdialogControler.this.dialog.getBeobachtungslandComboBox();
                if (jComboBoxExtended.getSelectedIndex() == -1 || jComboBoxExtended.getSelectedInternalValue() == null) {
                    return;
                }
                try {
                    List<String> list = KonfigurationsdialogControler.this.serviceFachlich.getStaedteFuerLand(jComboBoxExtended.getSelectedInternalValue());
                    KonfigurationsdialogControler.this.dialog.getOrt().removeAllItems();
                    for (String string : list) {
                        KonfigurationsdialogControler.this.dialog.getOrt().addItem(string);
                    }
                }
                catch (IOException iOException) {
                    KonfigurationsdialogControler.this.logger.error(iOException);
                }
            }
        };
    }

    private ActionListener erzeugeActionListenerFuerOrtHinzufuegen() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BeobachtungsortService beobachtungsortService = new BeobachtungsortService(KonfigurationsdialogControler.this.ortKonfigService, KonfigurationsdialogControler.this.dialog.getFachlichSubDialog());
                BeobachtungsortControler beobachtungsortControler = new BeobachtungsortControler(beobachtungsortService);
                beobachtungsortControler.showDialog();
            }
        };
    }

    private ActionListener erzeugeActionListenerFuerSpeichern() {
        return new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (KonfigurationsdialogControler.this.dialog.tabbedPane.getSelectedIndex() == -1) {
                    return;
                }
                try {
                    TechnischDto technischDto = KonfigurationsdialogControler.this.dialog.getTechnischDto();
                    KonfigurationsdialogControler.this.serviceTechnisch.write(technischDto);
                    FachlichAllgemeinDto fachlichAllgemeinDto = KonfigurationsdialogControler.this.dialog.getFachlichDto();
                    KonfigurationsdialogControler.this.serviceFachlich.write(fachlichAllgemeinDto);
                    KonfigurationsdialogControler.this.dialog.nachDemSpeichern();
                }
                catch (IOException iOException) {
                    KonfigurationsdialogControler.this.logger.error(iOException);
                    KonfigurationsdialogControler.this.dialog.nachDemSpeichern(iOException);
                }
            }
        };
    }

    private void initServices() {
        if (this.ortKonfigService == null) {
            throw new IllegalArgumentException("ortKonfigService ist null!");
        }
        IBeobachtungsortkonfiguration iBeobachtungsortkonfiguration = KonfiguratorFabrik.getBeobachtungskonfiguration();
        IKonfigurator iKonfigurator = KonfiguratorFabrik.getKonfigurator();
        this.serviceFachlich = new KonfigurationsServiceFachlich(iBeobachtungsortkonfiguration, iKonfigurator, this.datenbankService);
        this.serviceTechnisch = new KonfigurationsServiceTechnisch(iKonfigurator);
    }

    private void initDialog(IStartDialog iStartDialog) {
        try {
            FachlichAllgemeinDto fachlichAllgemeinDto = this.serviceFachlich.read();
            TechnischDto technischDto = this.serviceTechnisch.read();
            technischDto.setSprache(SprachcontainerFabrik.getSprachcontainer().getAktuelleSprache());
            this.dialog = iStartDialog == null ? new Konfigurationsdialog(technischDto, fachlichAllgemeinDto) : new Konfigurationsdialog(iStartDialog, technischDto, fachlichAllgemeinDto);
            this.dialog.speichernButton.addActionListener(this.erzeugeActionListenerFuerSpeichern());
            this.dialog.getBeobachtungslandComboBox().addActionListener(this.erzeugeActionListenerFuerBeobachtungsland());
            this.dialog.getOrtHinzufuegenButton().addActionListener(this.erzeugeActionListenerFuerOrtHinzufuegen());
        }
        catch (IOException iOException) {
            this.logger.error(iOException);
            ISprachcontainer iSprachcontainer = SprachcontainerFabrik.getSprachcontainer();
            JOptionPane.showMessageDialog(null, iSprachcontainer.getString("h_einstellungen_fehler3"), iSprachcontainer.getString("h_einstellungen_fehler4_titel"), 0);
        }
    }

    public void showDialog(boolean bl) {
        this.firstOpen = bl;
        this.dialog.setVisible(true);
    }
}

