/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.konfiguration.fachlich;

import de.planetensuche.datenbankkern.api.IDatenbankService;
import de.planetensuche.hauptprogramm.konfiguration.fachlich.FachlichAllgemeinDto;
import de.planetensuche.hauptprogramm.konfiguration.fachlich.IKonfigurationsServiceFachlich;
import de.planetensuche.konfigurator.api.IBeobachtungsortkonfiguration;
import de.planetensuche.konfigurator.api.IKonfigurator;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import de.planetensuche.konfigurator.api.Land;
import java.io.IOException;
import java.util.Collections;
import java.util.List;

public final class KonfigurationsServiceFachlich
implements IKonfigurationsServiceFachlich {
    private final IBeobachtungsortkonfiguration beobachtungsortkonfig;
    private final IKonfigurator konfigurator;
    private final IDatenbankService datenbankService;

    public KonfigurationsServiceFachlich(IBeobachtungsortkonfiguration iBeobachtungsortkonfiguration, IKonfigurator iKonfigurator, IDatenbankService iDatenbankService) {
        this.beobachtungsortkonfig = iBeobachtungsortkonfiguration;
        this.konfigurator = iKonfigurator;
        this.datenbankService = iDatenbankService;
    }

    @Override
    public FachlichAllgemeinDto read() throws IOException {
        FachlichAllgemeinDto fachlichAllgemeinDto = new FachlichAllgemeinDto();
        KonfigurationDTO konfigurationDTO = this.konfigurator.read();
        fachlichAllgemeinDto.setKoordinatenFormat(konfigurationDTO.getKoordinatenFormat());
        fachlichAllgemeinDto.setLand(konfigurationDTO.getBeobachtungsortLand());
        fachlichAllgemeinDto.setOrt(konfigurationDTO.getBeobachtungsortStadt());
        fachlichAllgemeinDto.setOerterFuerLand(this.getStaedteFuerLand(konfigurationDTO.getBeobachtungsortLand()));
        fachlichAllgemeinDto.setKoordinate(konfigurationDTO.getBeobachtungsortKoordinate());
        fachlichAllgemeinDto.setZahlenRunden(konfigurationDTO.isErgebnisseRunden());
        fachlichAllgemeinDto.setZeitzone(konfigurationDTO.getZeitzoneFuerBeobachtungsort());
        fachlichAllgemeinDto.setSternbildSprache(konfigurationDTO.getSternbildSprache());
        fachlichAllgemeinDto.setVotingActive(konfigurationDTO.isVotingActive());
        fachlichAllgemeinDto.setUseFlickr(konfigurationDTO.isUseFlickr());
        return fachlichAllgemeinDto;
    }

    @Override
    public void write(FachlichAllgemeinDto fachlichAllgemeinDto) throws IOException {
        KonfigurationDTO konfigurationDTO = this.konfigurator.read();
        konfigurationDTO.setKoordinatenFormat(fachlichAllgemeinDto.getKoordinatenFormat());
        konfigurationDTO.setBeobachtungsortLand(fachlichAllgemeinDto.getLand());
        konfigurationDTO.setBeobachtungsortStadt(fachlichAllgemeinDto.getOrt());
        konfigurationDTO.setBeobachtungsortKoordinate(fachlichAllgemeinDto.getKoordinate());
        konfigurationDTO.setErgebnisseRunden(fachlichAllgemeinDto.isZahlenRunden());
        konfigurationDTO.setZeitzoneFuerBeobachtungsort(fachlichAllgemeinDto.getZeitzone());
        konfigurationDTO.setSternbildSprache(fachlichAllgemeinDto.getSternbildSprache());
        konfigurationDTO.setVotingActive(fachlichAllgemeinDto.isVotingActive());
        konfigurationDTO.setUseFlickr(fachlichAllgemeinDto.isUseFlickr());
        this.konfigurator.write(konfigurationDTO);
        this.datenbankService.setSternbildsprache(fachlichAllgemeinDto.getSternbildSprache());
    }

    @Override
    public List<String> getStaedteFuerLand(Land land) throws IOException {
        List<String> list = this.beobachtungsortkonfig.getBeobachtungsoerterFuerLand(land);
        Collections.sort(list);
        return list;
    }
}

