/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.konfiguration.fachlich;

import de.planetensuche.datamodel.api.KoordinatenFormat;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.guidesigner.components.JComboBoxExtended;
import de.planetensuche.hauptprogramm.konfiguration.api.BeobachtungsortDto;
import de.planetensuche.hauptprogramm.konfiguration.api.KonfigDialogFachlich;
import de.planetensuche.hauptprogramm.konfiguration.fachlich.FachlichAllgemeinDto;
import de.planetensuche.konfigurator.api.Land;
import de.planetensuche.konfigurator.helfer.KoordinatenUmwandler;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public final class KonfigurationssubdialogFachlich
extends JPanel
implements KonfigDialogFachlich {
    private final JComboBoxExtended<Land> beobachtungsland;
    private final JComboBoxExtended<SternbildSprache> sternbildSprache;
    private final ISprachcontainer sprachcontainer = SprachcontainerFabrik.getSprachcontainer();
    private JComboBox koordinatenFormatAuswahl;
    private JLabel koordinatenFormatLabel;
    private JLabel labelLand;
    private JLabel labelOrt;
    private JLabel labelZeitzone;
    private JComboBox ort;
    private JButton ortHinzufuegenButton;
    private JCheckBox runden;
    private JLabel rundenLabel;
    private JLabel sternbildspracheLabel;
    private JCheckBox useFlickrCheckbox;
    private JLabel useFlickrLabel;
    private JCheckBox votingFunctionCheck;
    private JLabel votingFunctionLabel;
    private JComboBox zeitzone;

    public KonfigurationssubdialogFachlich() {
        this.beobachtungsland = new JComboBoxExtended(5);
        this.sternbildSprache = new JComboBoxExtended(5);
        this.initComponents();
        this.initLandComboBox();
        this.initSternbildComboBox();
        this.beschrifteGUI();
        this.fuelleLaenderComboBox();
        this.fuelleSternbildComboBox();
        this.fuelleZeitzonenComboBox();
        this.koordinatenFormatAuswahl.addItem("5,5616189h");
        this.koordinatenFormatAuswahl.addItem("5h 33m 41.83s");
        for (Component component : this.getComponents()) {
            GuiDesignerFabrik.getInstance().addComponent((JComponent)component, false);
        }
    }

    public JComboBoxExtended<Land> getBeobachtungslandComboBox() {
        return this.beobachtungsland;
    }

    public JComboBox<String> getOrt() {
        return this.ort;
    }

    private void initLandComboBox() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        this.add(this.beobachtungsland, gridBagConstraints);
    }

    private void initSternbildComboBox() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.add(this.sternbildSprache, gridBagConstraints);
    }

    public void setzeDaten(FachlichAllgemeinDto fachlichAllgemeinDto) throws IOException {
        this.sternbildSprache.setSelectedItem(fachlichAllgemeinDto.getSternbildSprache().getSprache());
        this.runden.setSelected(fachlichAllgemeinDto.isZahlenRunden());
        if (KoordinatenFormat.STUNDEN_DEZIMAL.name().equals(fachlichAllgemeinDto.getKoordinatenFormat().name())) {
            this.koordinatenFormatAuswahl.setSelectedIndex(0);
        } else {
            this.koordinatenFormatAuswahl.setSelectedIndex(1);
        }
        this.zeitzone.setSelectedItem(fachlichAllgemeinDto.getZeitzone());
        this.beobachtungsland.setSelectedItem((Object)fachlichAllgemeinDto.getLand());
        for (String string : fachlichAllgemeinDto.getOerterFuerLand()) {
            this.ort.addItem(string);
        }
        String string = fachlichAllgemeinDto.getOrt() + " (" + KoordinatenUmwandler.toStringOldFormat(fachlichAllgemeinDto.getKoordinate()) + ")";
        this.ort.setSelectedItem(string);
        this.votingFunctionCheck.setSelected(fachlichAllgemeinDto.isVotingActive());
        this.useFlickrCheckbox.setSelected(fachlichAllgemeinDto.isUseFlickr());
    }

    public FachlichAllgemeinDto holeDaten() {
        FachlichAllgemeinDto fachlichAllgemeinDto = new FachlichAllgemeinDto();
        fachlichAllgemeinDto.setSternbildSprache(this.sternbildSprache.getSelectedInternalValue());
        fachlichAllgemeinDto.setZahlenRunden(this.runden.isSelected());
        if (this.koordinatenFormatAuswahl.getSelectedIndex() == 0) {
            fachlichAllgemeinDto.setKoordinatenFormat(KoordinatenFormat.STUNDEN_DEZIMAL);
        } else {
            fachlichAllgemeinDto.setKoordinatenFormat(KoordinatenFormat.STUNDEN_MINUTEN_SEKUNDEN);
        }
        fachlichAllgemeinDto.setZeitzone(this.zeitzone.getSelectedItem().toString());
        fachlichAllgemeinDto.setLand(this.beobachtungsland.getSelectedInternalValue());
        String string = this.ort.getSelectedItem().toString();
        int n = string.indexOf(" (");
        if (n == -1) {
            JOptionPane.showMessageDialog(this, this.sprachcontainer.getString("h_einstellungen_fehler5"), this.sprachcontainer.getString("h_einstellungen_fehler5_titel"), 0);
            throw new IllegalArgumentException("keine Stadt mit Koordinate ausgew\u00e4hlt: " + string);
        }
        fachlichAllgemeinDto.setOrt(string.substring(0, n));
        fachlichAllgemeinDto.setKoordinate(KoordinatenUmwandler.parseKoordinateFromOldFormat(string));
        fachlichAllgemeinDto.setVotingActive(this.votingFunctionCheck.isSelected());
        fachlichAllgemeinDto.setUseFlickr(this.useFlickrCheckbox.isSelected());
        return fachlichAllgemeinDto;
    }

    private void beschrifteGUI() {
        this.sternbildspracheLabel.setText(this.sprachcontainer.getString("db_gui75"));
        this.koordinatenFormatLabel.setText(this.sprachcontainer.getString("db_gui112"));
        this.labelZeitzone.setText(this.sprachcontainer.getString("h_einstellungen_g9"));
        this.labelLand.setText(this.sprachcontainer.getString("h_einstellungen_g10"));
        this.labelOrt.setText(this.sprachcontainer.getString("h_einstellungen_g11"));
        this.ortHinzufuegenButton.setText(this.sprachcontainer.getString("h_einstellungen_g12"));
        this.rundenLabel.setText(this.sprachcontainer.getString("h_einstellungen_g13"));
        this.runden.setText(this.sprachcontainer.getString("h_einstellungen_g14"));
        this.votingFunctionLabel.setText(this.sprachcontainer.getString("h_einstellungen_g24"));
        this.useFlickrLabel.setText(this.sprachcontainer.getString("h_einstellungen_g26"));
    }

    private void fuelleLaenderComboBox() {
        this.beobachtungsland.removeAllItems();
        this.beobachtungsland.addItem(this.sprachcontainer.getString("land_d"), Land.DEUTSCHLAND);
        this.beobachtungsland.addItem(this.sprachcontainer.getString("land_oe"), Land.OESTERREICH);
        this.beobachtungsland.addItem(this.sprachcontainer.getString("land_s"), Land.SCHWEIZ);
        this.beobachtungsland.addItem(this.sprachcontainer.getString("land_andere"), Land.ANDERE);
        this.beobachtungsland.setSelectedIndex(0);
    }

    private void fuelleSternbildComboBox() {
        this.sternbildSprache.removeAllItems();
        for (SternbildSprache sternbildSprache : SternbildSprache.values()) {
            if (SternbildSprache.LATEINISCH_ABK.equals((Object)sternbildSprache)) continue;
            this.sternbildSprache.addItem(sternbildSprache.getSprache(), sternbildSprache);
        }
    }

    private void fuelleZeitzonenComboBox() {
        this.zeitzone.removeAllItems();
        this.zeitzone.addItem("GMT -12:00h");
        this.zeitzone.addItem("GMT -11:00h");
        this.zeitzone.addItem("GMT -10:00h");
        this.zeitzone.addItem("GMT -09:00h");
        this.zeitzone.addItem("GMT -08:00h");
        this.zeitzone.addItem("GMT -07:00h");
        this.zeitzone.addItem("GMT -06:00h");
        this.zeitzone.addItem("GMT -05:00h");
        this.zeitzone.addItem("GMT -04:00h");
        this.zeitzone.addItem("GMT -03:00h");
        this.zeitzone.addItem("GMT -02:00h");
        this.zeitzone.addItem("GMT -01:00h");
        this.zeitzone.addItem("GMT +00:00h");
        this.zeitzone.addItem("GMT +01:00h");
        this.zeitzone.addItem("GMT +02:00h");
        this.zeitzone.addItem("GMT +03:00h");
        this.zeitzone.addItem("GMT +03:30h");
        this.zeitzone.addItem("GMT +04:00h");
        this.zeitzone.addItem("GMT +04:30h");
        this.zeitzone.addItem("GMT +05:00h");
        this.zeitzone.addItem("GMT +05:30h");
        this.zeitzone.addItem("GMT +05:45h");
        this.zeitzone.addItem("GMT +06:00h");
        this.zeitzone.addItem("GMT +07:00h");
        this.zeitzone.addItem("GMT +08:00h");
        this.zeitzone.addItem("GMT +09:00h");
        this.zeitzone.addItem("GMT +10:00h");
        this.zeitzone.addItem("GMT +11:00h");
        this.zeitzone.addItem("GMT +12:00h");
        this.zeitzone.addItem("GMT +13:00h");
    }

    private void initComponents() {
        this.rundenLabel = new JLabel();
        this.runden = new JCheckBox();
        this.koordinatenFormatLabel = new JLabel();
        this.koordinatenFormatAuswahl = new JComboBox();
        this.zeitzone = new JComboBox();
        this.labelZeitzone = new JLabel();
        this.labelLand = new JLabel();
        this.labelOrt = new JLabel();
        this.ort = new JComboBox();
        this.ortHinzufuegenButton = new JButton();
        this.sternbildspracheLabel = new JLabel();
        this.votingFunctionLabel = new JLabel();
        this.votingFunctionCheck = new JCheckBox();
        this.useFlickrLabel = new JLabel();
        this.useFlickrCheckbox = new JCheckBox();
        this.setLayout(new GridBagLayout());
        this.rundenLabel.setText("zahlen runden?");
        this.rundenLabel.setHorizontalTextPosition(2);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.rundenLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.runden, gridBagConstraints);
        this.koordinatenFormatLabel.setText("koordinatenFormat");
        this.koordinatenFormatLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.koordinatenFormatLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 14;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.koordinatenFormatAuswahl, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.zeitzone, gridBagConstraints);
        this.labelZeitzone.setText("labelZeitzone");
        this.labelZeitzone.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelZeitzone, gridBagConstraints);
        this.labelLand.setText("labelLand");
        this.labelLand.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelLand, gridBagConstraints);
        this.labelOrt.setText("labelOrt");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelOrt, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 18;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.ort, gridBagConstraints);
        this.ortHinzufuegenButton.setText("ortHinzufuegenButton");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 19;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.ortHinzufuegenButton, gridBagConstraints);
        this.sternbildspracheLabel.setText("sternbildsprache:");
        this.sternbildspracheLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.sternbildspracheLabel, gridBagConstraints);
        this.votingFunctionLabel.setText("voting funktion an");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.votingFunctionLabel, gridBagConstraints);
        this.votingFunctionCheck.setSelected(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.votingFunctionCheck, gridBagConstraints);
        this.useFlickrLabel.setText("flickr");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.useFlickrLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.useFlickrCheckbox, gridBagConstraints);
    }

    public JButton getOrtHinzufuegenButton() {
        return this.ortHinzufuegenButton;
    }

    @Override
    public void setBeobachtungsstandort(BeobachtungsortDto beobachtungsortDto) {
        this.beobachtungsland.setSelectedItem((Object)beobachtungsortDto.getLand());
        this.ort.setSelectedItem(beobachtungsortDto.getOrtsname() + " (" + KoordinatenUmwandler.toStringOldFormat(beobachtungsortDto.getKoordinate()) + ")");
    }
}

