/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.konfiguration.neuerOrt;

import de.planetensuche.datamodel.api.IKoordinate;
import de.planetensuche.datamodel.impl.Koordinate;
import de.planetensuche.hauptprogramm.konfiguration.api.BeobachtungsortDto;
import de.planetensuche.hauptprogramm.konfiguration.neuerOrt.BeobachtungsortDialog;
import de.planetensuche.hauptprogramm.konfiguration.neuerOrt.IBeobachtungsortService;
import de.planetensuche.konfigurator.api.Land;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JOptionPane;

public final class BeobachtungsortControler {
    private final BeobachtungsortDialog dialog;
    private final IBeobachtungsortService service;

    public BeobachtungsortControler(IBeobachtungsortService iBeobachtungsortService) {
        this.service = iBeobachtungsortService;
        this.dialog = new BeobachtungsortDialog();
    }

    public void showDialog() {
        this.dialog.speichernButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                BeobachtungsortControler.this.pruefeEingabenUndSpeichere();
            }
        });
        this.dialog.setVisible(true);
    }

    private IKoordinate erzeugeKoordinate() {
        int n = Integer.parseInt(this.dialog.laengeStunden.getText());
        int n2 = Integer.parseInt(this.dialog.laengeMinuten.getText());
        double d = Double.parseDouble(this.dialog.laengeSekunden.getText());
        Koordinate koordinate = new Koordinate(n, n2, d);
        return koordinate;
    }

    private void pruefeEingabenUndSpeichere() {
        int n = 0;
        try {
            double d;
            int n2 = Integer.parseInt(this.dialog.laengeStunden.getText());
            if (n2 >= 360 || n2 < 0) {
                this.zeigeUngueltigeEingabeFehlermeldung("h_neuerort_f1");
                ++n;
            }
            if ((n2 = Integer.parseInt(this.dialog.laengeMinuten.getText())) >= 60 || n2 < 0) {
                this.zeigeUngueltigeEingabeFehlermeldung("h_neuerort_f2");
                ++n;
            }
            if ((d = Double.parseDouble(this.dialog.laengeSekunden.getText())) >= 60.0 || d < 0.0) {
                this.zeigeUngueltigeEingabeFehlermeldung("h_neuerort_f3");
                ++n;
            }
            if (this.dialog.ortsName.getText().length() < 3) {
                this.zeigeUngueltigeEingabeFehlermeldung("h_neuerort_f4");
                ++n;
            }
            if (this.dialog.landAlternativ.getText().length() < 3) {
                this.zeigeUngueltigeEingabeFehlermeldung("h_neuerort_f5");
                ++n;
            }
            if (this.dialog.ortsName.getText().indexOf(BeobachtungsortDialog.GRAD_ZEICHEN) > -1 || this.dialog.ortsName.getText().indexOf(40) > -1) {
                this.zeigeUngueltigeEingabeFehlermeldung("h_neuerort_f5");
                ++n;
            }
            if (n == 0) {
                this.speichereNeuenOrt();
                this.dialog.setVisible(false);
            }
        }
        catch (NumberFormatException numberFormatException) {
            this.loggeUndZeigeFehlermeldung(numberFormatException);
        }
        catch (IOException iOException) {
            this.loggeUndZeigeFehlermeldung(iOException);
        }
    }

    private void zeigeUngueltigeEingabeFehlermeldung(String string) {
        JOptionPane.showMessageDialog(this.dialog, this.dialog.getSprachcontainer().getString(string), this.dialog.getSprachcontainer().getString("ungueltige_eingabe"), 0);
    }

    private void loggeUndZeigeFehlermeldung(Exception exception) {
        this.dialog.getLogger().error(exception);
        JOptionPane.showMessageDialog(this.dialog, this.dialog.getSprachcontainer().getString("h_neuerort_f6") + "\n" + exception.toString(), this.dialog.getSprachcontainer().getString("h_neuerort_f7"), 0);
    }

    private void speichereNeuenOrt() throws IOException {
        try {
            Land land = Land.ANDERE;
            if (this.dialog.landComboBox.getSelectedItem().toString().equals(this.dialog.getSprachcontainer().getString("land_d"))) {
                land = Land.DEUTSCHLAND;
            } else if (this.dialog.landComboBox.getSelectedItem().toString().equals(this.dialog.getSprachcontainer().getString("land_oe"))) {
                land = Land.OESTERREICH;
            } else if (this.dialog.landComboBox.getSelectedItem().toString().equals(this.dialog.getSprachcontainer().getString("land_s"))) {
                land = Land.SCHWEIZ;
            }
            BeobachtungsortDto beobachtungsortDto = new BeobachtungsortDto();
            beobachtungsortDto.setLand(land);
            if (land == Land.ANDERE) {
                beobachtungsortDto.setLandName(this.dialog.landAlternativ.getText());
            }
            IKoordinate iKoordinate = this.erzeugeKoordinate();
            beobachtungsortDto.setKoordinate(iKoordinate);
            beobachtungsortDto.setOrtsname(this.dialog.ortsName.getText());
            this.service.save(beobachtungsortDto);
            JOptionPane.showMessageDialog(this.dialog, this.dialog.getSprachcontainer().getString("h_neuerort_m1"), this.dialog.getSprachcontainer().getString("h_neuerort_m_titel1"), 1);
        }
        catch (Exception exception) {
            this.dialog.getLogger().error(exception);
        }
    }
}

