/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.konfiguration.technisch;

import de.planetensuche.dateihelfer.ScriptWriter;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.hauptprogramm.konfiguration.technisch.IKonfigurationsServiceTechnisch;
import de.planetensuche.hauptprogramm.konfiguration.technisch.TechnischDto;
import de.planetensuche.konfigurator.api.IKonfigurator;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.io.IOException;

public final class KonfigurationsServiceTechnisch
implements IKonfigurationsServiceTechnisch {
    private final IKonfigurator konfigurator;

    public KonfigurationsServiceTechnisch(IKonfigurator iKonfigurator) {
        this.konfigurator = iKonfigurator;
    }

    @Override
    public TechnischDto read() throws IOException {
        TechnischDto technischDto = new TechnischDto();
        KonfigurationDTO konfigurationDTO = this.konfigurator.read();
        technischDto.setBrowserPfad(konfigurationDTO.getBrowserpfad());
        technischDto.setFilmFensterZeigen(konfigurationDTO.isFilmFensterZeigen());
        technischDto.setIntroZeigen(konfigurationDTO.isIntroZeigen());
        technischDto.setLogDateiInKb(konfigurationDTO.getLogFileInKb());
        technischDto.setSchriftgroesseInPixel(konfigurationDTO.getSchriftgroesseInPixel());
        technischDto.setSprache(konfigurationDTO.getSprache());
        technischDto.setUpdatesSuchen(konfigurationDTO.isNachUpdatesSuchen());
        technischDto.setAnonymeBenutzerstatistik(konfigurationDTO.isAnonymeBenutzerstatistikSenden());
        technischDto.setXmxInMb(konfigurationDTO.getXmxInMB());
        technischDto.setBildZoomAlgorithmus(konfigurationDTO.getBildZoomAlgorithmus());
        technischDto.setGuiTheme(konfigurationDTO.getGuiTheme());
        return technischDto;
    }

    @Override
    public void write(TechnischDto technischDto) throws IOException {
        KonfigurationDTO konfigurationDTO = this.konfigurator.read();
        konfigurationDTO.setSprache(technischDto.getSprache());
        konfigurationDTO.setSchriftgroesseInPixel(technischDto.getSchriftgroesseInPixel());
        konfigurationDTO.setNachUpdatesSuchen(technischDto.isUpdatesSuchen());
        konfigurationDTO.setAnonymeBenutzerstatistikSenden(technischDto.isAnonymeBenutzerstatistik());
        konfigurationDTO.setSendWindowAccess(technischDto.isAnonymeBenutzerstatistik());
        konfigurationDTO.setIntroZeigen(technischDto.isIntroZeigen());
        konfigurationDTO.setFilmFensterZeigen(technischDto.isFilmFensterZeigen());
        konfigurationDTO.setXmxInMB(technischDto.getXmxInMb());
        konfigurationDTO.setLogFileInKb(technischDto.getLogDateiInKb());
        konfigurationDTO.setBrowserpfad(technischDto.getBrowserPfad());
        konfigurationDTO.setBildZoomAlgorithmus(technischDto.getBildZoomAlgorithmus());
        konfigurationDTO.setGuiTheme(technischDto.getGuiTheme());
        this.konfigurator.write(konfigurationDTO);
        try {
            ScriptWriter scriptWriter = new ScriptWriter();
            scriptWriter.writeScripts(technischDto.getXmxInMb(), konfigurationDTO.getVersion());
        }
        catch (IOException iOException) {
            LoggingFactory.getLoggerForClass(this.getClass()).error(iOException);
        }
    }
}

