/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.konfiguration.technisch;

import de.planetensuche.guidesigner.GuiDesignerFabrik;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.hauptprogramm.konfiguration.technisch.TechnischDto;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.SwingUtilities;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileFilter;

public final class KonfigurationssubdialogTechnisch
extends JPanel {
    private final ISprachcontainer sprachcontainer = SprachcontainerFabrik.getSprachcontainer();
    private JRadioButton andere;
    private JComboBox angezeigteSprache;
    private JCheckBox autoupdate;
    private JCheckBox benutzerstatistik;
    private JComboBox bildzoomComboBox;
    private JLabel bildzoomLabel;
    private JTextField browserPfad;
    private ButtonGroup buttonGroup1;
    private JButton durchsuchenButton;
    private JCheckBox filmfensterAnzeigen;
    private JCheckBox introAnzeigen;
    private JLabel labelAutoupdate;
    private JLabel labelBenutzerstatistik;
    private JLabel labelFilmfensterAnzeigen;
    private JLabel labelGuiTheme;
    private JLabel labelIntroAnzeigen;
    private JLabel labelLogfile;
    private JLabel labelSchriftgroesse;
    private JLabel labelSprache;
    private JLabel labelXMX;
    private JSpinner logdateiGroesseInKb;
    private JComboBox schriftgroesse;
    private JRadioButton standard;
    private JComboBox themes;
    private JLabel webbrowser;
    private JSpinner xmxRamInMB;

    public KonfigurationssubdialogTechnisch() {
        this.initComponents();
        this.beschrifteGUI();
        this.fuelleSprachenComboBox();
        this.fuelleGuiThemeComboBox();
        this.fuelleBildzoomComboBox();
        this.fuelleSchriftgroesseComboBox();
        for (Component component : this.getComponents()) {
            GuiDesignerFabrik.getInstance().addComponent((JComponent)component, false);
        }
    }

    public void setzeDaten(TechnischDto technischDto) {
        this.angezeigteSprache.setSelectedItem(technischDto.getSprache());
        this.themes.setSelectedItem(technischDto.getGuiTheme());
        this.schriftgroesse.setSelectedItem(technischDto.getSchriftgroesseInPixel());
        this.autoupdate.setSelected(technischDto.isUpdatesSuchen());
        this.benutzerstatistik.setSelected(technischDto.isAnonymeBenutzerstatistik());
        this.introAnzeigen.setSelected(technischDto.isIntroZeigen());
        this.filmfensterAnzeigen.setSelected(technischDto.isFilmFensterZeigen());
        this.xmxRamInMB.setValue(technischDto.getXmxInMb());
        this.logdateiGroesseInKb.setValue(technischDto.getLogDateiInKb());
        this.bildzoomComboBox.setSelectedItem(technischDto.getBildZoomAlgorithmus());
        if (technischDto.getBrowserPfad() == null || "".equals(technischDto.getBrowserPfad()) || "null".equals(technischDto.getBrowserPfad())) {
            this.standard.setSelected(true);
            this.browserPfad.setEditable(false);
            this.browserPfad.setText("");
        } else {
            this.andere.setSelected(true);
            this.browserPfad.setEditable(true);
            this.browserPfad.setText(technischDto.getBrowserPfad());
        }
    }

    public TechnischDto holeDaten() throws IOException {
        TechnischDto technischDto = new TechnischDto();
        technischDto.setSprache(this.angezeigteSprache.getSelectedItem().toString());
        this.sprachcontainer.setAktuelleSprache(this.angezeigteSprache.getSelectedItem().toString());
        technischDto.setGuiTheme(this.themes.getSelectedItem().toString());
        int n = Integer.parseInt(this.schriftgroesse.getSelectedItem().toString());
        technischDto.setSchriftgroesseInPixel(n);
        if (GuiDesignerFabrik.getInstance().getSchriftgroesse() != n) {
            GuiDesignerFabrik.init(n);
            GuiDesignerFabrik.getInstance().updateComponents();
        }
        technischDto.setBildZoomAlgorithmus(this.bildzoomComboBox.getSelectedItem().toString());
        technischDto.setUpdatesSuchen(this.autoupdate.isSelected());
        technischDto.setAnonymeBenutzerstatistik(this.benutzerstatistik.isSelected());
        technischDto.setIntroZeigen(this.introAnzeigen.isSelected());
        technischDto.setFilmFensterZeigen(this.filmfensterAnzeigen.isSelected());
        technischDto.setXmxInMb(Integer.parseInt(this.xmxRamInMB.getValue().toString()));
        technischDto.setLogDateiInKb(Integer.parseInt(this.logdateiGroesseInKb.getValue().toString()));
        if (this.standard.isSelected()) {
            technischDto.setBrowserPfad("");
        } else {
            technischDto.setBrowserPfad(this.browserPfad.getText());
        }
        return technischDto;
    }

    private void beschrifteGUI() {
        this.labelSprache.setText(this.sprachcontainer.getString("h_einstellungen_g1"));
        this.labelGuiTheme.setText(this.sprachcontainer.getString("h_einstellungen_g25"));
        this.labelSchriftgroesse.setText(this.sprachcontainer.getString("h_einstellungen_g16"));
        this.labelAutoupdate.setText(this.sprachcontainer.getString("h_einstellungen_g2"));
        this.labelBenutzerstatistik.setText(this.sprachcontainer.getString("h_einstellungen_g22"));
        this.labelBenutzerstatistik.setToolTipText(this.sprachcontainer.getString("h_einstellungen_g23"));
        this.benutzerstatistik.setToolTipText(this.sprachcontainer.getString("h_einstellungen_g23"));
        this.labelXMX.setText(this.sprachcontainer.getString("h_einstellungen_g17"));
        this.labelLogfile.setText(this.sprachcontainer.getString("h_einstellungen_g3"));
        this.labelIntroAnzeigen.setText(this.sprachcontainer.getString("h_einstellungen_g18"));
        this.labelFilmfensterAnzeigen.setText(this.sprachcontainer.getString("h_einstellungen_g19"));
        this.bildzoomLabel.setText(this.sprachcontainer.getString("db_gui76"));
        this.webbrowser.setText(this.sprachcontainer.getString("h_einstellungen_g4"));
        this.standard.setText(this.sprachcontainer.getString("h_einstellungen_g5"));
        this.andere.setText(this.sprachcontainer.getString("h_einstellungen_g6"));
        this.browserPfad.setText(this.sprachcontainer.getString("h_einstellungen_g7"));
        this.durchsuchenButton.setText("");
        this.durchsuchenButton.setIcon(IconPoolDefault.OPEN.getImageIcon());
        this.durchsuchenButton.setToolTipText(this.sprachcontainer.getString("h_einstellungen_g8"));
    }

    private void fuelleBildzoomComboBox() {
        this.bildzoomComboBox.removeAllItems();
        this.bildzoomComboBox.addItem(this.sprachcontainer.getString("db_bild_standard"));
        this.bildzoomComboBox.addItem(this.sprachcontainer.getString("db_bild_schnell"));
        this.bildzoomComboBox.addItem(this.sprachcontainer.getString("db_bild_gut"));
    }

    private void fuelleSprachenComboBox() {
        for (String string : this.sprachcontainer.getUnterstuetzteSprachen()) {
            this.angezeigteSprache.addItem(string);
        }
    }

    private void fuelleSchriftgroesseComboBox() {
        this.schriftgroesse.removeAllItems();
        for (int i = 12; i < 17; ++i) {
            this.schriftgroesse.addItem(i);
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.introAnzeigen = new JCheckBox();
        this.labelLogfile = new JLabel();
        this.angezeigteSprache = new JComboBox();
        this.andere = new JRadioButton();
        this.logdateiGroesseInKb = new JSpinner();
        this.autoupdate = new JCheckBox();
        this.schriftgroesse = new JComboBox();
        this.browserPfad = new JTextField();
        this.xmxRamInMB = new JSpinner();
        this.durchsuchenButton = new JButton();
        this.labelXMX = new JLabel();
        this.labelSchriftgroesse = new JLabel();
        this.standard = new JRadioButton();
        this.labelSprache = new JLabel();
        this.filmfensterAnzeigen = new JCheckBox();
        this.webbrowser = new JLabel();
        this.labelIntroAnzeigen = new JLabel();
        this.labelAutoupdate = new JLabel();
        this.labelFilmfensterAnzeigen = new JLabel();
        this.bildzoomLabel = new JLabel();
        this.bildzoomComboBox = new JComboBox();
        this.labelBenutzerstatistik = new JLabel();
        this.benutzerstatistik = new JCheckBox();
        this.labelGuiTheme = new JLabel();
        this.themes = new JComboBox();
        this.setMinimumSize(new Dimension(353, 278));
        this.setPreferredSize(new Dimension(505, 368));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.introAnzeigen, gridBagConstraints);
        this.labelLogfile.setText("logdateiGroesseInKb");
        this.labelLogfile.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelLogfile, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.angezeigteSprache, gridBagConstraints);
        this.buttonGroup1.add(this.andere);
        this.andere.setText("andere");
        this.andere.setHorizontalTextPosition(4);
        this.andere.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KonfigurationssubdialogTechnisch.this.andereActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.andere, gridBagConstraints);
        this.logdateiGroesseInKb.setModel(new SpinnerNumberModel(512, 128, 2048, 128));
        this.logdateiGroesseInKb.setValue(128);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.logdateiGroesseInKb, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.autoupdate, gridBagConstraints);
        this.schriftgroesse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KonfigurationssubdialogTechnisch.this.schriftgroesseActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.schriftgroesse, gridBagConstraints);
        this.browserPfad.setText("browserPfad");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.browserPfad, gridBagConstraints);
        this.xmxRamInMB.setModel(new SpinnerNumberModel(1536, 1536, 4096, 256));
        this.xmxRamInMB.setValue(1536);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.xmxRamInMB, gridBagConstraints);
        this.durchsuchenButton.setText("durchsuchenButton");
        this.durchsuchenButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KonfigurationssubdialogTechnisch.this.durchsuchenButtonActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 13;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.durchsuchenButton, gridBagConstraints);
        this.labelXMX.setText("xmxRamInMB");
        this.labelXMX.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelXMX, gridBagConstraints);
        this.labelSchriftgroesse.setText("schriftgroesse");
        this.labelSchriftgroesse.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelSchriftgroesse, gridBagConstraints);
        this.buttonGroup1.add(this.standard);
        this.standard.setText("standard");
        this.standard.setHorizontalTextPosition(4);
        this.standard.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KonfigurationssubdialogTechnisch.this.standardActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 12;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.standard, gridBagConstraints);
        this.labelSprache.setText("angezeigteSprache");
        this.labelSprache.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelSprache, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.filmfensterAnzeigen, gridBagConstraints);
        this.webbrowser.setText("webbrowser");
        this.webbrowser.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.webbrowser, gridBagConstraints);
        this.labelIntroAnzeigen.setText("intro anzeigen:");
        this.labelIntroAnzeigen.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelIntroAnzeigen, gridBagConstraints);
        this.labelAutoupdate.setText("autoupdate:");
        this.labelAutoupdate.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelAutoupdate, gridBagConstraints);
        this.labelFilmfensterAnzeigen.setText("filmfenster anzeigen:");
        this.labelFilmfensterAnzeigen.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelFilmfensterAnzeigen, gridBagConstraints);
        this.bildzoomLabel.setText("bildzoom:");
        this.bildzoomLabel.setHorizontalTextPosition(2);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.bildzoomLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 10;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.bildzoomComboBox, gridBagConstraints);
        this.labelBenutzerstatistik.setText("anonyme Benutzerstatistik:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelBenutzerstatistik, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.benutzerstatistik, gridBagConstraints);
        this.labelGuiTheme.setText("theme");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.labelGuiTheme, gridBagConstraints);
        this.themes.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KonfigurationssubdialogTechnisch.this.themesActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = -1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        this.add((Component)this.themes, gridBagConstraints);
    }

    private void andereActionPerformed(ActionEvent actionEvent) {
        if (this.andere.isSelected()) {
            this.browserPfad.setEnabled(true);
        }
    }

    private void schriftgroesseActionPerformed(ActionEvent actionEvent) {
        GuiDesignerFabrik.init(Integer.parseInt(this.schriftgroesse.getSelectedItem().toString()));
        GuiDesignerFabrik.getInstance().updateComponents();
    }

    private void durchsuchenButtonActionPerformed(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileFilter(new FileFilter(this){

            @Override
            public boolean accept(File file) {
                return file.isDirectory() || file.getName().toLowerCase().endsWith(".exe");
            }

            @Override
            public String getDescription() {
                return "Ausfuehrbare Datei (.exe)";
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            this.browserPfad.setText(file.getAbsolutePath());
        }
    }

    private void standardActionPerformed(ActionEvent actionEvent) {
        if (this.standard.isSelected()) {
            this.browserPfad.setEnabled(false);
        }
    }

    private void themesActionPerformed(ActionEvent actionEvent) {
        try {
            if (this.themes.getSelectedItem() == null) {
                return;
            }
            GuiDesignerFabrik.getInstance().applyTheme(this.themes.getSelectedItem().toString());
            SwingUtilities.updateComponentTreeUI(this);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | RuntimeException | UnsupportedLookAndFeelException exception) {
            this.themes.removeItemAt(this.themes.getSelectedIndex());
            this.themes.repaint();
        }
    }

    private void fuelleGuiThemeComboBox() {
        List<String> list = GuiDesignerFabrik.getInstance().getAvailableThemeNames();
        list.forEach(string -> this.themes.addItem(string));
    }
}

