/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.threads;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.hauptprogramm.threads.api.IVotingLabel;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.web.connector.voting.VotingDtoV1;
import de.planetensuche.web.connector.voting.VotingService;
import java.util.Date;
import java.util.TimerTask;

public final class LastVotingTimerTask
extends TimerTask {
    private final ILogging logger = LoggingFactory.getLoggerForClass(LastVotingTimerTask.class);
    private final ISprachcontainer i18n;
    private final IVotingLabel votingLabel;
    private final VotingService service;
    private int errorCount;

    public LastVotingTimerTask(ISprachcontainer iSprachcontainer, IVotingLabel iVotingLabel, VotingService votingService) {
        this.i18n = iSprachcontainer;
        this.votingLabel = iVotingLabel;
        this.service = votingService;
    }

    @Override
    public void run() {
        try {
            this.logger.debug("query for last voting...");
            VotingDtoV1 votingDtoV1 = this.service.getLast();
            if (votingDtoV1 == null) {
                votingDtoV1 = this.service.getLast();
            }
            if (votingDtoV1 != null) {
                this.logger.debug("last vote available");
                String string = votingDtoV1.getCategory().name();
                Date date = votingDtoV1.getCreated();
                String string2 = votingDtoV1.getObjectName();
                String string3 = votingDtoV1.getUsername();
                String string4 = this.i18n.toLocalisedDate(date, 1);
                String string5 = this.i18n.getString("db_voting_category_" + string);
                this.logger.debug("category: " + string + " into " + string5);
                String string6 = this.i18n.getString("h_voting_lastVote");
                string6 = string6.replace("%1", string4);
                string6 = string6.replace("%2", string3);
                string6 = string6.replace("%3", string2);
                string6 = string6.replace("%4", string5);
                String string7 = " " + string6 + "...";
                this.votingLabel.setLastVotingText(string7);
            } else {
                String string = this.i18n.getString("h_voting_not_available");
                this.votingLabel.setLastVotingText(string);
                this.votingLabel.disableVotingOverview();
            }
        }
        catch (Exception exception) {
            ++this.errorCount;
            if (this.errorCount < 2) {
                this.logger.error("Fehler beim Laden des letzten Votings", exception);
            }
            this.logger.warn("Fehler beim Laden des letzten Votings", exception);
        }
    }
}

