/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.threads;

import de.planetensuche.datamodel.api.IKoordinate;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.hauptprogramm.threads.api.IZeitaktualisierGUI;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.util.GregorianCalendar;
import java.util.TimerTask;

public final class Zeitupdater
extends TimerTask {
    private final IKoordinate koordinate;
    private final String zeitzone;
    private GregorianCalendar gregorianCalendar;
    private int fehleranzahl;
    private int stunde;
    private int monat;
    private int jahr;
    private int tag;
    private String sec;
    private double b;
    private double theta0;
    private double geografischeLaenge;
    private String mi;
    private double s2;
    private String tmp;
    private final ISprachcontainer sprache;
    private final ILogging logging = LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG);
    private final IZeitaktualisierGUI gui;

    public Zeitupdater(ISprachcontainer iSprachcontainer, IKoordinate iKoordinate, String string, IZeitaktualisierGUI iZeitaktualisierGUI) {
        this.koordinate = iKoordinate;
        this.zeitzone = string;
        this.fehleranzahl = 0;
        this.sprache = iSprachcontainer;
        this.gui = iZeitaktualisierGUI;
    }

    @Override
    public void run() {
        if (this.sprache != null) {
            try {
                this.berechneUniversalTime();
                this.berechneJulianischesDatum();
                this.berechneMittlereGreenwichSternzeit();
                this.berechneMittlereLokaleSternzeit();
            }
            catch (Exception exception) {
                this.error(exception);
            }
        }
    }

    private void berechneMittlereLokaleSternzeit() {
        double d = this.koordinate.getStunden();
        double d2 = this.koordinate.getMinuten();
        double d3 = this.koordinate.getSekunden();
        this.geografischeLaenge = d + d2 / 60.0 + d3 / 3600.0;
        double d4 = this.theta0 + this.geografischeLaenge / 15.0;
        this.geografischeLaenge = (d4 - Math.floor(d4)) * 60.0;
        this.s2 = (this.geografischeLaenge - Math.floor(this.geografischeLaenge)) * 60.0;
        this.mi = this.geografischeLaenge < 10.0 ? "0" + Double.toString(Math.floor(this.geografischeLaenge)) : Double.toString(Math.floor(this.geografischeLaenge));
        this.mi = this.mi.substring(0, this.mi.length() - 2);
        this.sec = this.s2 < 10.0 ? "0" + Math.floor(this.s2) : Double.toString(Math.floor(this.s2));
        this.sec = this.sec.substring(0, this.sec.length() - 2);
        this.tmp = Double.toString(Math.floor(d4));
        this.tmp = this.tmp.substring(0, this.tmp.length() - 2);
        this.gui.setTextLokaleSternzeit(this.sprache.getString("mdsternzeit") + ": " + this.tmp + ":" + this.mi + ":" + this.sec);
    }

    private void berechneMittlereGreenwichSternzeit() {
        double d = Math.floor(365.25 * (double)this.jahr) + Math.floor(30.6001 * (double)(this.monat + 1)) + this.b + 1720996.5 + (double)this.tag;
        this.theta0 = 6.66452 + 0.0657098244 * (d - 2451544.5) + 1.00273790926 * ((double)this.stunde + (double)this.gregorianCalendar.get(12) / 60.0 + (double)this.gregorianCalendar.get(13) / 3600.0);
        while (this.theta0 > 24.0) {
            this.theta0 -= 24.0;
        }
        this.geografischeLaenge = (this.theta0 - Math.floor(this.theta0)) * 60.0;
        this.s2 = (this.geografischeLaenge - Math.floor(this.geografischeLaenge)) * 60.0;
        this.mi = this.geografischeLaenge < 10.0 ? "0" + Double.toString(Math.floor(this.geografischeLaenge)) : Double.toString(Math.floor(this.geografischeLaenge));
        this.mi = this.mi.substring(0, this.mi.length() - 2);
        this.sec = this.s2 < 10.0 ? "0" + Math.floor(this.s2) : Double.toString(Math.floor(this.s2));
        this.sec = this.sec.substring(0, this.sec.length() - 2);
        this.tmp = Double.toString(Math.floor(this.theta0));
        this.tmp = this.tmp.substring(0, this.tmp.length() - 2);
        this.gui.setTextGreenwichSternzeit(this.sprache.getString("mdgreenwich") + ": " + this.tmp + ":" + this.mi + ":" + this.sec);
    }

    private void berechneJulianischesDatum() {
        this.monat = this.gregorianCalendar.get(2) + 1;
        this.jahr = this.gregorianCalendar.get(1);
        this.tag = this.gregorianCalendar.get(5);
        if (this.monat <= 2) {
            this.monat += 12;
            --this.jahr;
        }
        this.b = Math.floor((double)this.jahr / 400.0) - Math.floor((double)this.jahr / 100.0);
        int n = this.gregorianCalendar.get(13);
        int n2 = this.gregorianCalendar.get(12);
        double d = Math.floor(365.25 * (double)this.jahr) + Math.floor(30.6001 * (double)(this.monat + 1)) + this.b + 1720996.5 + (double)this.tag + ((double)this.stunde + (double)n2 / 60.0 + (double)n / 3600.0) / 24.0;
        String string = String.valueOf(d);
        if (string.length() >= 13) {
            this.gui.setTextJD("JD: " + string.substring(0, 13));
        } else {
            this.gui.setTextJD("JD: " + string);
        }
    }

    private void berechneUniversalTime() {
        this.gregorianCalendar = new GregorianCalendar();
        int n = this.zeitzone.indexOf(43);
        int n2 = this.zeitzone.indexOf(45);
        String string = this.zeitzone.substring(5, 7);
        this.stunde = Integer.parseInt(string);
        int n3 = this.gregorianCalendar.get(12);
        int n4 = this.gregorianCalendar.get(13);
        Object object = n3 < 10 ? "0" + n3 : String.valueOf(n3);
        this.sec = n4 < 10 ? "0" + n4 : String.valueOf(n4);
        if (n != -1) {
            this.stunde = this.gregorianCalendar.get(11) - this.stunde < 0 ? this.gregorianCalendar.get(11) - this.stunde + 24 : this.gregorianCalendar.get(11) - this.stunde;
            this.gui.setTextUT("UT: " + this.stunde + ":" + (String)object + ":" + this.sec);
        } else if (n2 != -1) {
            this.stunde = this.gregorianCalendar.get(11) + this.stunde > 23 ? this.gregorianCalendar.get(11) + this.stunde - 24 : this.gregorianCalendar.get(11) + this.stunde;
            this.gui.setTextUT("UT: " + this.stunde + ":" + (String)object + ":" + this.sec);
        } else {
            this.error(new IllegalArgumentException("Fehler in der Zeitzone: " + this.zeitzone));
        }
    }

    private synchronized void error(Exception exception) {
        ++this.fehleranzahl;
        if (this.fehleranzahl >= 10) {
            this.logging.showErrorMessageBox(null, this.sprache.getString("zeitrechnung_fehler"), this.sprache.getString("fehler_titel"));
            boolean bl = this.cancel();
            if (!bl) {
                try {
                    this.logging.info("abbrechnen fehlgeschlagen. pausiere jetzt...");
                    this.wait(10000000L);
                }
                catch (InterruptedException interruptedException) {
                    this.logging.error(interruptedException);
                }
            }
        } else {
            this.logging.error(exception);
        }
    }
}

