/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.update;

import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.icons.IconPoolDevelopment;
import de.planetensuche.hauptprogramm.api.IHauptprogramm;
import de.planetensuche.hauptprogramm.update.VersionCheckerService;
import de.planetensuche.konfigurator.api.KonfigurationDTO;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.apache.commons.lang3.tuple.Pair;
import org.netbeans.lib.awtextra.AbsoluteConstraints;
import org.netbeans.lib.awtextra.AbsoluteLayout;

public final class UpdateDialog
extends Basisdialog {
    private final IHauptprogramm hauptprogramm;
    private final KonfigurationDTO configDto;
    private JLabel bildInternetPc;
    private JLabel bildInternetPc2;
    private JLabel bildLokalerPc;
    private JLabel bildLokalerPc2;
    private JTextField internetJreVersionTextFeld;
    private JTextField internetPsVersionTextFeld;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JTextField lokaleJreVersionTextfeld;
    private JTextField lokalePsVersionTextfeld;
    private JButton pruefeAufUpdates;
    private JTextField statusJre;
    private JTextField statusPs;

    public UpdateDialog(IHauptprogramm iHauptprogramm, KonfigurationDTO konfigurationDTO) {
        super(BasisdialogId.HAUPTPROGRAMM_UPDATE);
        this.hauptprogramm = iHauptprogramm;
        this.configDto = konfigurationDTO;
        this.initComponents();
        this.getLogger().info("Updaten gestartet");
        this.setTitle(this.i18n.getString("h_updaten_titel"));
        this.jLabel1.setText(this.i18n.getString("h_versionen"));
        this.jLabel4.setText(this.i18n.getString("h_jre_versionen"));
        this.jLabel2.setText(this.i18n.getString("h_version_lokal"));
        this.jLabel5.setText(this.jLabel2.getText());
        this.jLabel3.setText(this.i18n.getString("h_version_inet"));
        this.jLabel6.setText(this.jLabel3.getText());
        this.statusPs.setText(this.i18n.getString("h_start_klicken"));
        this.statusJre.setText(this.statusPs.getText());
        this.pruefeAufUpdates.setText(this.i18n.getString("h_start_button"));
        this.bildLokalerPc.setText(null);
        this.bildLokalerPc.setIcon(IconPoolDevelopment.PC.getImageIcon());
        this.bildLokalerPc.setSize(24, 24);
        this.bildLokalerPc2.setText(null);
        this.bildLokalerPc2.setIcon(this.bildLokalerPc.getIcon());
        this.bildLokalerPc2.setSize(this.bildLokalerPc.getSize());
        this.bildInternetPc.setText(null);
        this.bildInternetPc.setIcon(IconPoolDevelopment.SERVER.getImageIcon());
        this.bildInternetPc.setSize(24, 24);
        this.bildInternetPc2.setText(null);
        this.bildInternetPc2.setIcon(this.bildInternetPc.getIcon());
        this.bildInternetPc2.setSize(this.bildInternetPc.getSize());
        for (int i = 0; i < this.getContentPane().getComponentCount(); ++i) {
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(i), false);
        }
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.lokalePsVersionTextfeld = new JTextField();
        this.internetPsVersionTextFeld = new JTextField();
        this.pruefeAufUpdates = new JButton();
        this.statusPs = new JTextField();
        this.bildLokalerPc = new JLabel();
        this.bildInternetPc = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.lokaleJreVersionTextfeld = new JTextField();
        this.internetJreVersionTextFeld = new JTextField();
        this.statusJre = new JTextField();
        this.bildLokalerPc2 = new JLabel();
        this.bildInternetPc2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setTitle("Updatefunktion");
        this.setAlwaysOnTop(true);
        this.setResizable(false);
        this.getContentPane().setLayout(new AbsoluteLayout());
        this.jLabel1.setFont(new Font("Liberation Sans", 1, 15));
        this.jLabel1.setText("Ps Versionen:");
        this.getContentPane().add((Component)this.jLabel1, new AbsoluteConstraints(48, 21, 233, 24));
        this.jLabel2.setText("auf Ihrem PC:");
        this.getContentPane().add((Component)this.jLabel2, new AbsoluteConstraints(48, 51, 178, 28));
        this.jLabel3.setText("im Internet:");
        this.getContentPane().add((Component)this.jLabel3, new AbsoluteConstraints(248, 51, 179, 28));
        this.lokalePsVersionTextfeld.setEditable(false);
        this.getContentPane().add((Component)this.lokalePsVersionTextfeld, new AbsoluteConstraints(48, 85, 178, 28));
        this.internetPsVersionTextFeld.setEditable(false);
        this.getContentPane().add((Component)this.internetPsVersionTextFeld, new AbsoluteConstraints(248, 85, 179, 28));
        this.pruefeAufUpdates.setText("start");
        this.pruefeAufUpdates.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                UpdateDialog.this.pruefeAufUpdatesActionPerformed(actionEvent);
            }
        });
        this.getContentPane().add((Component)this.pruefeAufUpdates, new AbsoluteConstraints(330, 320, 97, 25));
        this.statusPs.setEditable(false);
        this.statusPs.setText("Bitte klicken Sie auf start");
        this.statusPs.setPreferredSize(new Dimension(185, 24));
        this.getContentPane().add((Component)this.statusPs, new AbsoluteConstraints(48, 119, 379, 28));
        this.bildLokalerPc.setText("bild");
        this.getContentPane().add((Component)this.bildLokalerPc, new AbsoluteConstraints(15, 87, -1, -1));
        this.bildInternetPc.setText("bild");
        this.getContentPane().add((Component)this.bildInternetPc, new AbsoluteConstraints(438, 87, -1, -1));
        this.jLabel4.setFont(new Font("Liberation Sans", 1, 15));
        this.jLabel4.setText("JRE versions:");
        this.getContentPane().add((Component)this.jLabel4, new AbsoluteConstraints(50, 170, 370, -1));
        this.jLabel5.setText("auf Ihrem PC:");
        this.getContentPane().add((Component)this.jLabel5, new AbsoluteConstraints(50, 200, 178, 28));
        this.jLabel6.setText("im Internet:");
        this.getContentPane().add((Component)this.jLabel6, new AbsoluteConstraints(250, 200, 179, 28));
        this.lokaleJreVersionTextfeld.setEditable(false);
        this.getContentPane().add((Component)this.lokaleJreVersionTextfeld, new AbsoluteConstraints(50, 230, 178, 28));
        this.internetJreVersionTextFeld.setEditable(false);
        this.getContentPane().add((Component)this.internetJreVersionTextFeld, new AbsoluteConstraints(250, 230, 179, 28));
        this.statusJre.setEditable(false);
        this.statusJre.setText("Bitte klicken Sie auf start");
        this.statusJre.setPreferredSize(new Dimension(185, 24));
        this.getContentPane().add((Component)this.statusJre, new AbsoluteConstraints(50, 270, 379, 28));
        this.bildLokalerPc2.setText("bild");
        this.getContentPane().add((Component)this.bildLokalerPc2, new AbsoluteConstraints(10, 230, -1, -1));
        this.bildInternetPc2.setText("bild");
        this.getContentPane().add((Component)this.bildInternetPc2, new AbsoluteConstraints(440, 230, -1, -1));
        this.setSize(new Dimension(492, 398));
        this.setLocationRelativeTo(null);
    }

    private void pruefeAufUpdatesActionPerformed(ActionEvent actionEvent) {
        Executors.newSingleThreadExecutor().submit(() -> this.runCheckForUpdates());
    }

    private void runCheckForUpdates() throws HeadlessException {
        try {
            this.statusPs.setText(this.i18n.getString("bitte_warten") + "...");
            this.statusJre.setText(this.i18n.getString("bitte_warten") + "...");
            this.lokalePsVersionTextfeld.setText(this.configDto.getVersion());
            this.lokaleJreVersionTextfeld.setText(JavaVersionHelperUtil.getInstalledJavaVersion());
            VersionCheckerService versionCheckerService = new VersionCheckerService(this.configDto.getUpdateUrl());
            this.checkPlanetensucheVersion(versionCheckerService);
            if (JavaVersionHelperUtil.isLocalJreAvailable()) {
                this.checkJreVersion(versionCheckerService);
            } else {
                this.internetJreVersionTextFeld.setEnabled(false);
                this.statusJre.setText(this.i18n.getString("h_no_lokal_jre"));
            }
        }
        catch (UnknownHostException unknownHostException) {
            this.statusPs.setText(this.i18n.getString("update_abgebrochen"));
            JOptionPane.showMessageDialog(this, this.i18n.getString("bug_m9"), this.i18n.getString("update_abgebrochen"), 0);
        }
        catch (Exception exception) {
            this.statusPs.setText(this.i18n.getString("update_abgebrochen"));
            this.getLogger().error(exception);
            String string = this.i18n.getString("update_fehler") + "\n" + exception.toString();
            JOptionPane.showMessageDialog(this, string, this.i18n.getString("fehler_titel"), 0);
        }
    }

    private void checkJreVersion(VersionCheckerService versionCheckerService) throws HeadlessException, IOException {
        Pair<Integer, Integer> pair = versionCheckerService.getJreMajorMinorInternetVersion(this.configDto.getHomepageHostname());
        Integer n = pair.getLeft();
        Integer n2 = pair.getRight();
        this.internetJreVersionTextFeld.setText(n + ".0." + n2);
        if (JavaVersionHelperUtil.isVersionNewer(n, n2)) {
            this.statusJre.setText(this.i18n.getString("neue_version1") + " " + this.internetJreVersionTextFeld.getText() + " " + this.i18n.getString("neue_version2"));
            String string = this.i18n.getString("neue_version1") + " " + this.internetJreVersionTextFeld.getText() + " " + this.i18n.getString("neue_version2") + "\n" + this.i18n.getString("neue_version3");
            int n3 = JOptionPane.showConfirmDialog(this, string, this.i18n.getString("neue_version_titel"), 0);
            if (n3 == 0) {
                this.openUpdaterAndCloseMainProgram();
            }
        } else {
            this.statusJre.setText(this.i18n.getString("neue_version_ok"));
        }
    }

    private void checkPlanetensucheVersion(VersionCheckerService versionCheckerService) throws IOException, HeadlessException {
        int n = versionCheckerService.getLocaleVersion(this.configDto.getVersion());
        int n2 = versionCheckerService.getInternetVersionInt();
        this.internetPsVersionTextFeld.setText(versionCheckerService.getInternetVersionString());
        if (n2 > n) {
            this.statusPs.setText(this.i18n.getString("neue_version1") + " " + this.internetPsVersionTextFeld.getText() + " " + this.i18n.getString("neue_version2"));
            String string = this.i18n.getString("neue_version1") + " " + this.internetPsVersionTextFeld.getText() + " " + this.i18n.getString("neue_version2") + "\n" + this.i18n.getString("neue_version3");
            int n3 = JOptionPane.showConfirmDialog(this, string, this.i18n.getString("neue_version_titel"), 0);
            if (n3 == 0) {
                this.openUpdaterAndCloseMainProgram();
            }
        } else {
            this.statusPs.setText(this.i18n.getString("neue_version_ok"));
        }
    }

    private void openUpdaterAndCloseMainProgram() throws IOException {
        this.setVisible(false);
        String string = JavaVersionHelperUtil.getCurrentJavaPath() + " -Xmx2560m -XX:+UseStringDeduplication -jar updater.jar " + this.configDto.getVersion();
        Runtime.getRuntime().exec(string);
        this.hauptprogramm.programmSchliessen(this, 0);
    }
}

