/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.update;

import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.errorlogger.api.Modulnummer;
import de.planetensuche.hauptprogramm.api.IHauptprogramm;
import de.planetensuche.hauptprogramm.update.VersionCheckerService;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import java.io.IOException;
import javax.swing.JOptionPane;

public final class UpdateHintergrundsucher
extends Thread {
    private final ILogging logging = LoggingFactory.getLoggerForModule(Modulnummer.HAUPTLOG);
    private final String mainVersion;
    private final VersionCheckerService versionChecker;
    private final ISprachcontainer i18n;
    private final IHauptprogramm hauptprogramm;
    private final int xmx;

    public UpdateHintergrundsucher(String string, ISprachcontainer iSprachcontainer, IHauptprogramm iHauptprogramm, String string2, int n) {
        this.mainVersion = string;
        this.versionChecker = new VersionCheckerService(string2);
        this.i18n = iSprachcontainer;
        this.hauptprogramm = iHauptprogramm;
        this.xmx = n;
    }

    @Override
    public void run() {
        try {
            int n;
            int n2 = this.versionChecker.getInternetVersionInt();
            int n3 = this.versionChecker.getLocaleVersion(this.mainVersion);
            this.logging.info("lokal: v" + n3 + ", Inet: v" + n2);
            if (n2 > n3 && (n = JOptionPane.showConfirmDialog(null, this.i18n.getString("neue_version1") + " " + this.i18n.getString("neue_version2") + "\n" + this.i18n.getString("neue_version3"), this.i18n.getString("neue_version_titel"), 0)) == 0) {
                Runtime.getRuntime().exec(JavaVersionHelperUtil.getCurrentJavaPath() + " -Xmx" + this.xmx + "m -XX:+UseStringDeduplication -jar updater.jar " + this.mainVersion);
                this.hauptprogramm.programmSchliessen(null, 0);
            }
        }
        catch (IOException | UnsupportedOperationException exception) {
            this.logging.warn("Fehler beim Ermitteln neuer Updates!", exception);
        }
    }
}

