/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.update;

import de.planetensuche.core.Check;
import de.planetensuche.core.JavaVersionHelperUtil;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class VersionCheckerService {
    private final String updateTxtUrlAsString;
    private final ILogging logger;
    private String latestInetVersion;

    public VersionCheckerService(String string) {
        this.updateTxtUrlAsString = string;
        this.logger = LoggingFactory.getLoggerForClass(VersionCheckerService.class);
    }

    public Pair<Integer, Integer> getJreMajorMinorInternetVersion(String string) throws MalformedURLException, IOException {
        URL uRL = new URL("https://www." + string + "/jre/update.txt");
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));){
            String[] stringArray;
            String string2;
            int n = 0;
            int n2 = 0;
            while ((string2 = bufferedReader.readLine()) != null) {
                String string3;
                String string4;
                if (!Check.isFilled(string2) || (stringArray = string2.split(";")).length < 4 || !(string4 = System.getProperty("os.name").toLowerCase()).contains(string3 = stringArray[2].toLowerCase())) continue;
                int n3 = Integer.parseInt(stringArray[0]);
                int n4 = Integer.parseInt(stringArray[1]);
                if (!JavaVersionHelperUtil.isVersionCompatible(n3)) continue;
                n = n3;
                n2 = n4;
            }
            stringArray = Pair.of(n, n2);
            return stringArray;
        }
    }

    public int getInternetVersionInt() throws IOException {
        URL uRL = new URL(this.updateTxtUrlAsString);
        List<String> list = IOUtils.readLines(uRL.openStream(), "utf8");
        try {
            return this.extractInternetVersionFromList(list);
        }
        catch (IllegalStateException illegalStateException) {
            this.logger.debug("query url '" + String.valueOf(uRL) + "', lines: " + String.valueOf(list), illegalStateException);
            throw illegalStateException;
        }
    }

    int extractInternetVersionFromList(List<String> list) throws NumberFormatException {
        if (Check.isEmpty(list)) {
            throw new IllegalArgumentException("no version information in update file!");
        }
        this.latestInetVersion = list.get(list.size() - 1);
        if (Check.isEmpty(this.latestInetVersion)) {
            return this.extractInternetVersionFromList(list.subList(0, list.size() - 1));
        }
        int n = this.latestInetVersion.indexOf(59);
        if (n == -1) {
            throw new IllegalStateException("update file is corrupt, line '" + this.latestInetVersion + "'");
        }
        this.latestInetVersion = this.latestInetVersion.substring(0, n);
        int n2 = Integer.parseInt(this.latestInetVersion);
        return n2;
    }

    public String getInternetVersionString() throws IOException {
        if (this.latestInetVersion == null) {
            this.getInternetVersionInt();
        }
        String string = this.latestInetVersion.substring(0, 1);
        String string2 = this.latestInetVersion.substring(1);
        String string3 = string + "." + string2;
        return string3;
    }

    public int getLocaleVersion(String string) {
        switch (string.length()) {
            case 5: {
                String string2 = string.substring(0, 1);
                String string3 = string.substring(2, 3);
                String string4 = string.substring(4, 5);
                int n = Integer.parseInt(string2 + string3 + string4);
                return n;
            }
            case 4: {
                return Integer.parseInt(string.substring(0, 1) + string.substring(2, 4));
            }
            case 3: {
                return Integer.parseInt(string.substring(0, 1) + "0" + string.substring(2, 3));
            }
        }
        throw new IllegalArgumentException("Die Version '" + string + "' hat nicht die richtige Laenge!");
    }
}

