/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.voting;

import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.components.jtable.IconRenderer;
import de.planetensuche.guidesigner.components.jtable.JTableExtended;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;

public final class VotingDialog
extends Basisdialog {
    private final List<String> header;
    private JScrollPane alienWorldScrollPane;
    private JTableExtended alienWorldTable;
    private JScrollPane deepSkyScrollPane;
    private JTableExtended deepSkyTable;
    private JScrollPane exoplanetScrollPane;
    private JTableExtended exoplanetTable;
    private JScrollPane pictureScrollPane;
    private JTableExtended pictureTable;
    private JScrollPane sunSystemScrollPane;
    private JTableExtended sunSystemTable;

    public VotingDialog() {
        super(BasisdialogId.HAUPTPROGRAMM_VOTING);
        this.initComponents();
        this.exoplanetTable.disableDragColumns();
        this.exoplanetTable.disableEditMode();
        this.exoplanetTable.setAutoResizeMode(0);
        this.exoplanetTable.setRowHeight(24);
        this.exoplanetTable.setDefaultRenderer(ImageIcon.class, new IconRenderer());
        this.alienWorldTable.disableDragColumns();
        this.alienWorldTable.disableEditMode();
        this.alienWorldTable.setAutoResizeMode(0);
        this.alienWorldTable.setRowHeight(24);
        this.alienWorldTable.setDefaultRenderer(ImageIcon.class, new IconRenderer());
        this.deepSkyTable.disableDragColumns();
        this.deepSkyTable.disableEditMode();
        this.deepSkyTable.setAutoResizeMode(0);
        this.deepSkyTable.setRowHeight(24);
        this.deepSkyTable.setDefaultRenderer(ImageIcon.class, new IconRenderer());
        this.sunSystemTable.disableDragColumns();
        this.sunSystemTable.disableEditMode();
        this.sunSystemTable.setAutoResizeMode(0);
        this.sunSystemTable.setRowHeight(24);
        this.sunSystemTable.setDefaultRenderer(ImageIcon.class, new IconRenderer());
        this.pictureTable.disableDragColumns();
        this.pictureTable.disableEditMode();
        this.pictureTable.setAutoResizeMode(0);
        this.pictureTable.setRowHeight(24);
        this.pictureTable.setDefaultRenderer(ImageIcon.class, new IconRenderer());
        this.remove(this.exoplanetScrollPane);
        this.remove(this.alienWorldScrollPane);
        this.remove(this.deepSkyScrollPane);
        this.remove(this.sunSystemScrollPane);
        this.remove(this.pictureScrollPane);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = this.createGridBagConstraint();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 23;
        this.exoplanetScrollPane.setSize(200, 100);
        this.add((Component)this.exoplanetScrollPane, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = this.createGridBagConstraint();
        gridBagConstraints2.gridx = 2;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.gridheight = 1;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.anchor = 24;
        this.add((Component)this.alienWorldScrollPane, gridBagConstraints2);
        GridBagConstraints gridBagConstraints3 = this.createGridBagConstraint();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.gridheight = 1;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.anchor = 21;
        this.add((Component)this.deepSkyScrollPane, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = this.createGridBagConstraint();
        gridBagConstraints4.gridx = 2;
        gridBagConstraints4.gridy = 1;
        gridBagConstraints4.gridheight = 1;
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.anchor = 22;
        this.add((Component)this.sunSystemScrollPane, gridBagConstraints4);
        GridBagConstraints gridBagConstraints5 = this.createGridBagConstraint();
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 2;
        gridBagConstraints5.gridheight = 1;
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.anchor = 25;
        this.add((Component)this.pictureScrollPane, gridBagConstraints5);
        this.header = new ArrayList<String>();
        this.header.add(this.getSprachcontainer().getString("h_voting_objektname"));
        this.header.add(this.getSprachcontainer().getString("h_voting_kategorie"));
        this.header.add(this.getSprachcontainer().getString("h_voting_user"));
        this.header.add(this.getSprachcontainer().getString("h_voting_country"));
        this.header.add(this.getSprachcontainer().getString("h_voting_date"));
        this.header.add(this.getSprachcontainer().getString("h_voting_info"));
        this.setTitle(this.i18n.getString("h_voting_overview"));
        this.resizeToDesktopSize();
        this.addWindowStateListener(windowEvent -> this.resizeColumnWidth());
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                VotingDialog.this.resizeColumnWidth();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
            }

            @Override
            public void componentShown(ComponentEvent componentEvent) {
            }

            @Override
            public void componentHidden(ComponentEvent componentEvent) {
            }
        });
    }

    private GridBagConstraints createGridBagConstraint() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets.set(10, 10, 10, 10);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        return gridBagConstraints;
    }

    public void resizeColumnWidth() {
        this.resizeColumnWidthForTable(this.exoplanetTable, this.exoplanetScrollPane);
        this.resizeColumnWidthForTable(this.alienWorldTable, this.alienWorldScrollPane);
        this.resizeColumnWidthForTable(this.deepSkyTable, this.deepSkyScrollPane);
        this.resizeColumnWidthForTable(this.pictureTable, this.pictureScrollPane);
        this.resizeColumnWidthForTable(this.sunSystemTable, this.sunSystemScrollPane);
    }

    public void resizeColumnWidthForTable(JTableExtended jTableExtended, JScrollPane jScrollPane) {
        int n;
        if (jTableExtended.getColumnCount() == 0) {
            return;
        }
        int n2 = jScrollPane.getWidth() - 10;
        TableColumnModel tableColumnModel = jTableExtended.getColumnModel();
        for (n = 0; n < jTableExtended.getColumnCount(); ++n) {
            int n3 = 120;
            for (int i = 0; i < jTableExtended.getRowCount(); ++i) {
                TableCellRenderer tableCellRenderer = jTableExtended.getCellRenderer(i, n);
                Component component = jTableExtended.prepareRenderer(tableCellRenderer, i, n);
                n3 = Math.max(component.getPreferredSize().width + 1, n3);
            }
            if (n3 > 300) {
                n3 = 300;
            }
            if (n3 < 120) {
                n3 = 120;
            }
            n2 -= n3;
            tableColumnModel.getColumn(n).setPreferredWidth(n3);
        }
        n = tableColumnModel.getColumn(0).getPreferredWidth();
        tableColumnModel.getColumn(0).setPreferredWidth(n + n2);
    }

    public void setAlienTableData(List<List<Object>> list) {
        this.alienWorldTable.setTableContentWithIcon(list, this.header);
    }

    public void setExoplanetTableData(List<List<Object>> list) {
        this.exoplanetTable.setTableContentWithIcon(list, this.header);
    }

    public void setDeepSkyTableData(List<List<Object>> list) {
        this.deepSkyTable.setTableContentWithIcon(list, this.header);
    }

    public void setSunSystemTableData(List<List<Object>> list) {
        this.sunSystemTable.setTableContentWithIcon(list, this.header);
    }

    public void setPictureTableData(List<List<Object>> list) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(this.getSprachcontainer().getString("h_voting_objektname_pic"));
        arrayList.add(this.getSprachcontainer().getString("h_voting_kategorie"));
        arrayList.add(this.getSprachcontainer().getString("h_voting_user"));
        arrayList.add(this.getSprachcontainer().getString("h_voting_country"));
        arrayList.add(this.getSprachcontainer().getString("h_voting_date"));
        arrayList.add(this.getSprachcontainer().getString("h_voting_info"));
        this.pictureTable.setTableContentWithIcon(list, arrayList);
    }

    public JTableExtended getAlienWorldTable() {
        return this.alienWorldTable;
    }

    public JTableExtended getExoplanetTable() {
        return this.exoplanetTable;
    }

    public JTableExtended getDeepSkyTable() {
        return this.deepSkyTable;
    }

    public JTableExtended getSunSystemTable() {
        return this.sunSystemTable;
    }

    public JTableExtended getPictureTable() {
        return this.pictureTable;
    }

    private void initComponents() {
        this.exoplanetScrollPane = new JScrollPane();
        this.exoplanetTable = new JTableExtended();
        this.alienWorldScrollPane = new JScrollPane();
        this.alienWorldTable = new JTableExtended();
        this.deepSkyScrollPane = new JScrollPane();
        this.deepSkyTable = new JTableExtended();
        this.sunSystemScrollPane = new JScrollPane();
        this.sunSystemTable = new JTableExtended();
        this.pictureScrollPane = new JScrollPane();
        this.pictureTable = new JTableExtended();
        this.exoplanetTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.exoplanetScrollPane.setViewportView(this.exoplanetTable);
        this.alienWorldTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.alienWorldScrollPane.setViewportView(this.alienWorldTable);
        this.deepSkyTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.deepSkyScrollPane.setViewportView(this.deepSkyTable);
        this.sunSystemTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.sunSystemScrollPane.setViewportView(this.sunSystemTable);
        this.pictureTable.setModel(new DefaultTableModel(new Object[][]{new Object[0], new Object[0], new Object[0], new Object[0]}, new String[0]));
        this.pictureScrollPane.setViewportView(this.pictureTable);
        GroupLayout groupLayout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.pictureScrollPane, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.exoplanetScrollPane, -2, 401, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sunSystemScrollPane, -2, 452, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGap(397, 397, 397).addComponent(this.alienWorldScrollPane, -2, 452, -2)).addComponent(this.deepSkyScrollPane, -2, 452, -2)).addContainerGap(-1, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.exoplanetScrollPane, -1, 192, Short.MAX_VALUE).addComponent(this.alienWorldScrollPane, -2, 0, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 127, Short.MAX_VALUE).addComponent(this.deepSkyScrollPane, -2, 137, -2)).addGroup(GroupLayout.Alignment.TRAILING, groupLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.sunSystemScrollPane, GroupLayout.Alignment.TRAILING, -2, 372, -2).addComponent(this.pictureScrollPane, GroupLayout.Alignment.TRAILING, -2, -1, -2)))).addContainerGap()));
        this.pack();
    }
}

