/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.voting;

import de.planetensuche.datenbank.api.IStart;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.jtable.JTableExtended;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.hauptprogramm.voting.DatenbankModulStarter;
import de.planetensuche.hauptprogramm.voting.VotingDialog;
import de.planetensuche.hauptprogramm.voting.VotingTableIconClickHandler;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import de.planetensuche.web.connector.voting.VotingCategory;
import de.planetensuche.web.connector.voting.VotingDtoV1;
import de.planetensuche.web.connector.voting.VotingService;
import java.awt.event.MouseListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;

public final class VotingDialogControler {
    private final ILogging logger;
    private final VotingService votingservice;
    private final VotingDialog dialog;
    private final ISprachcontainer i18n;
    private final DatenbankModulStarter dbLoader;
    private IStart dbService;
    private boolean dataLoaded;

    public VotingDialogControler(VotingService votingService, DatenbankModulStarter datenbankModulStarter) {
        if (votingService == null) {
            throw new IllegalArgumentException("votingService is null");
        }
        if (datenbankModulStarter == null) {
            throw new IllegalArgumentException("moduleLoader is null");
        }
        this.logger = LoggingFactory.getLoggerForClass(VotingDialogControler.class);
        this.votingservice = votingService;
        this.dialog = new VotingDialog();
        this.i18n = SprachcontainerFabrik.getSprachcontainer();
        this.dbLoader = datenbankModulStarter;
        this.addIconClickListener();
    }

    private void addIconClickListener() {
        this.dialog.getAlienWorldTable().addMouseListener(this.createTableMouseListener(this.dialog.getAlienWorldTable()));
        this.dialog.getDeepSkyTable().addMouseListener(this.createTableMouseListener(this.dialog.getDeepSkyTable()));
        this.dialog.getExoplanetTable().addMouseListener(this.createTableMouseListener(this.dialog.getExoplanetTable()));
        this.dialog.getPictureTable().addMouseListener(this.createTableMouseListener(this.dialog.getPictureTable()));
        this.dialog.getSunSystemTable().addMouseListener(this.createTableMouseListener(this.dialog.getSunSystemTable()));
    }

    public void showDialog() {
        if (!this.dataLoaded) {
            this.logger.debug("row count <1");
            if (!this.loadData()) {
                return;
            }
            this.dataLoaded = true;
        } else {
            this.logger.debug("row count >=1");
        }
        this.dialog.setVisible(true);
        SwingUtilities.invokeLater(() -> this.dialog.resizeColumnWidth());
    }

    private boolean loadData() {
        try {
            List<List<Object>> list;
            List<List<Object>> list2;
            List<List<Object>> list3;
            List<List<Object>> list4;
            List<List<Object>> list5 = this.getTableData(VotingCategory.EXOPLANET);
            if (list5 != null) {
                this.dialog.setExoplanetTableData(list5);
            }
            if ((list4 = this.getTableData(VotingCategory.ALIEN_HOME)) != null) {
                this.dialog.setAlienTableData(list4);
            }
            if ((list3 = this.getTableData(VotingCategory.DEEP_SKY)) != null) {
                this.dialog.setDeepSkyTableData(list3);
            }
            if ((list2 = this.getTableData(VotingCategory.SUN_SYSTEM)) != null) {
                this.dialog.setSunSystemTableData(list2);
            }
            if ((list = this.getTableData(VotingCategory.PICTURE)) != null) {
                this.dialog.setPictureTableData(list);
            }
            return true;
        }
        catch (Exception exception) {
            this.dialog.getLogger().error(this.i18n.getString("h_voting_fehler1"), exception);
            return false;
        }
    }

    private MouseListener createTableMouseListener(JTableExtended jTableExtended) {
        return new VotingTableIconClickHandler(this.dbService, this.dbLoader, this.dialog, jTableExtended);
    }

    private List<List<Object>> getTableData(VotingCategory votingCategory) {
        List<VotingDtoV1> list = this.votingservice.getTop10(votingCategory);
        if (list != null && !list.isEmpty()) {
            this.logger.debug("category " + String.valueOf((Object)votingCategory) + " results in " + list.size() + " entries");
            ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
            for (VotingDtoV1 votingDtoV1 : list) {
                List<Object> list2 = this.transformToLine(votingDtoV1);
                arrayList.add(list2);
            }
            return arrayList;
        }
        return null;
    }

    private List<Object> transformToLine(VotingDtoV1 votingDtoV1) {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(votingDtoV1.getObjectName());
        arrayList.add(this.i18n.getString("db_voting_category_" + String.valueOf((Object)votingDtoV1.getCategory())));
        arrayList.add(votingDtoV1.getUsername());
        if (votingDtoV1.getCountryCode() == null) {
            arrayList.add("");
        } else {
            arrayList.add(votingDtoV1.getCountryCode());
        }
        arrayList.add(this.i18n.toLocalisedDate(votingDtoV1.getCreated(), 1));
        ImageIcon imageIcon = IconPoolDefault.INFO.getImageIcon();
        arrayList.add(imageIcon);
        return arrayList;
    }
}

