/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.hauptprogramm.voting;

import de.planetensuche.datenbank.api.IStart;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.jtable.JTableExtended;
import de.planetensuche.hauptprogramm.api.DbInitializedListener;
import de.planetensuche.hauptprogramm.voting.DatenbankModulStarter;
import de.planetensuche.hauptprogramm.voting.VotingDialog;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import javax.swing.table.TableModel;

public final class VotingTableIconClickHandler
implements MouseListener {
    private static final int ICON_COLUMN_INDEX = 5;
    private final ILogging logger;
    private IStart dbService;
    private final DatenbankModulStarter dbLoader;
    private final VotingDialog dialog;
    private final JTableExtended table;

    public VotingTableIconClickHandler(IStart iStart, DatenbankModulStarter datenbankModulStarter, VotingDialog votingDialog, JTableExtended jTableExtended) {
        this.dbService = iStart;
        this.dbLoader = datenbankModulStarter;
        this.dialog = votingDialog;
        this.table = jTableExtended;
        this.logger = LoggingFactory.getLoggerForClass(VotingTableIconClickHandler.class);
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.table.getSelectedColumn() == 5) {
            int n = this.table.getSelectedRow();
            String string = this.getObjectNameFromSelectedRow(n);
            this.logger.debug("objektname= '" + string + "'");
            this.openDatabase(string, n);
        }
    }

    private void openDatabase(String string, int n) {
        DbInitializedListener dbInitializedListener = () -> {
            try {
                Thread.sleep(500L);
                this.dialog.setVisible(false);
                this.dbService.springeZuObjekt(string);
            }
            catch (InterruptedException | SQLException exception) {
                this.logger.error("objektname '" + string + "' from row " + n, exception);
            }
        };
        if (this.dbService == null) {
            this.dbService = this.dbLoader.starteDatenbank(this.dialog, dbInitializedListener);
        } else {
            this.dbLoader.starteDatenbank(this.dialog, dbInitializedListener);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    private String getObjectNameFromSelectedRow(int n) {
        TableModel tableModel = this.table.getModel();
        String string = (String)tableModel.getValueAt(n, 0);
        int n2 = string.indexOf("@");
        if (n2 > 0) {
            string = string.substring(n2 + 1, string.length());
        }
        return string;
    }
}

