/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.konfigurator.impl;

import com.google.common.io.Files;
import de.planetensuche.konfigurator.api.IDatenbankkonfiguration;
import de.planetensuche.konfigurator.helfer.DateiSchreiber;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.List;

@Deprecated
public final class Datenbankkonfiguration
implements IDatenbankkonfiguration {
    private final File datenbankConfig;
    private String datenbankName;
    private long datenbankAenderungsDatum;
    private String bildZoomAlgo;
    private String sternbildSprache;

    protected Datenbankkonfiguration() {
        this.datenbankConfig = new File("conf" + File.separator + "datenbank.conf");
    }

    protected Datenbankkonfiguration(File file) {
        this.datenbankConfig = file;
    }

    @Override
    public void lesen() throws IOException {
        List<String> list = Files.readLines(this.datenbankConfig, Charset.forName("UTF-8"));
        for (String string : list) {
            String[] stringArray = string.split("=");
            if (stringArray.length != 2) continue;
            if ("sternbild".equals(stringArray[0])) {
                this.sternbildSprache = stringArray[1];
                continue;
            }
            if ("id".equals(stringArray[0])) {
                this.datenbankAenderungsDatum = Long.parseLong(stringArray[1]);
                continue;
            }
            if ("src".equals(stringArray[0])) {
                this.datenbankName = stringArray[1];
                continue;
            }
            if (!"bildzoom".equals(stringArray[0])) continue;
            this.bildZoomAlgo = stringArray[1];
        }
    }

    @Override
    public void schreiben() throws IOException {
        DateiSchreiber dateiSchreiber = new DateiSchreiber(this.datenbankConfig);
        dateiSchreiber.schreibeZeile("sternbild=" + this.sternbildSprache);
        dateiSchreiber.schreibeZeile("id=" + this.datenbankAenderungsDatum);
        dateiSchreiber.schreibeZeile("src=" + this.datenbankName);
        dateiSchreiber.schreibeZeile("bildzoom=" + this.bildZoomAlgo);
        dateiSchreiber.schliessen();
    }

    @Override
    public String getDatenbankName() {
        return this.datenbankName;
    }

    @Override
    public String getBildZoomAlgorithmus() {
        return this.bildZoomAlgo;
    }

    @Override
    public String getSpracheDerSternbilder() {
        return this.sternbildSprache;
    }

    @Override
    public long getDatenbankDatum() {
        return this.datenbankAenderungsDatum;
    }

    @Override
    public void setDatenbankName(String string) {
        this.datenbankName = string;
    }

    @Override
    public void setBildZoomAlgorithmus(String string) {
        this.bildZoomAlgo = string;
    }

    @Override
    public void setSpracheDerSternbilder(String string) {
        this.sternbildSprache = string;
    }

    @Override
    public void setDatenbankDatum(long l) {
        this.datenbankAenderungsDatum = l;
    }

    @Override
    public void ladeStandardKonfiguration() {
        this.bildZoomAlgo = "standard";
        this.datenbankAenderungsDatum = 1L;
        this.datenbankName = "database";
        this.sternbildSprache = "lateinisch";
    }
}

