/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.leben;

import de.planetensuche.guidesigner.IPlanetensucheModul;
import de.planetensuche.guidesigner.components.Basisdialog;
import de.planetensuche.guidesigner.components.BasisdialogId;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.konfigurator.api.PlanetensucheFeature;
import de.planetensuche.konfigurator.impl.FeatureRepository;
import de.planetensuche.leben.ProtokollDialog;
import de.planetensuche.leben.Wahrscheinlichkeitsberechnung;
import de.planetensuche.leben.beispiele.Enceladus;
import de.planetensuche.leben.beispiele.Erde;
import de.planetensuche.leben.beispiele.Europa;
import de.planetensuche.leben.beispiele.GJ581e;
import de.planetensuche.leben.beispiele.Ganymed;
import de.planetensuche.leben.beispiele.HD209458b;
import de.planetensuche.leben.beispiele.Mars;
import de.planetensuche.leben.beispiele.Titan;
import de.planetensuche.leben.datenmodel.Lebensraum;
import de.planetensuche.leben.datenmodel.ObjektKategorie;
import de.planetensuche.leben.neu.WahrscheinlichkeitsrechnerControler;
import de.planetensuche.leben.neu.api.Wahrscheinlichkeitsergebnis;
import de.planetensuche.leben.util.BruchRechner;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public final class LebenMainGui
extends Basisdialog
implements IPlanetensucheModul {
    private static final String JA = "leb_gui11";
    private Lebensraum lebenskriterien = new Lebensraum();
    private List<Wahrscheinlichkeitsergebnis> ergebnis;
    private JCheckBox auswahl1;
    private JCheckBox auswahl2;
    private JCheckBox auswahl3;
    private JCheckBox auswahl4;
    private JCheckBox auswahl5;
    private JCheckBox auswahl6;
    private JCheckBox auswahl7;
    private JComboBox auswahlbox;
    private JTextArea beschreibung;
    private JTextField eingabe1;
    private JTextField eingabe2;
    private JTextField eingabe3;
    private JTextField eingabe4;
    private JMenuItem hilfeMenu;
    private JLabel jLabel1;
    private JList jList1;
    private JMenu jMenu1;
    private JMenu jMenu2;
    private JMenuBar jMenuBar1;
    private JMenuItem jMenuItem1;
    private JMenuItem jMenuItem2;
    private JMenuItem jMenuItem3;
    private JMenuItem jMenuItem4;
    private JMenuItem jMenuItem5;
    private JMenuItem jMenuItem7;
    private JMenuItem jMenuItem8;
    private JMenuItem jMenuItem9;
    private JPanel jPanelEingabefelder;
    private JPanel jPanelKriterien;
    private JScrollPane jScrollPane1;
    private JCheckBox krit1;
    private JCheckBox krit2;
    private JCheckBox krit3;
    private JCheckBox krit4;
    private JCheckBox krit5;
    private JCheckBox krit6;
    private JCheckBox krit7;
    private JLabel label1;
    private JLabel label2;
    private JLabel label3;
    private JLabel label4;
    private JLabel label5;
    private JLabel label6;
    private JLabel label7;
    private JButton protokolleButton;
    private JScrollPane scrollPaneKategorien;
    private JButton speichernButton;

    public LebenMainGui() {
        super(BasisdialogId.LEBEN_HAUPTFENSTER);
    }

    private void disableAllInputFields() {
        this.auswahl1.setVisible(false);
        this.auswahl2.setVisible(false);
        this.auswahl3.setVisible(false);
        this.auswahl4.setVisible(false);
        this.auswahl5.setVisible(false);
        this.auswahl6.setVisible(false);
        this.auswahl7.setVisible(false);
        this.auswahlbox.setVisible(false);
        this.eingabe1.setVisible(false);
        this.eingabe2.setVisible(false);
        this.eingabe3.setVisible(false);
        this.eingabe4.setVisible(false);
        this.speichernButton.setEnabled(false);
        this.label1.setVisible(false);
        this.label2.setVisible(false);
        this.label3.setVisible(false);
        this.label4.setVisible(false);
        this.label5.setVisible(false);
        this.label6.setVisible(false);
        this.label7.setVisible(false);
    }

    private void alleFragenBeantwortet(boolean bl) {
        this.krit1.setSelected(bl);
        this.krit2.setSelected(bl);
        this.krit3.setSelected(bl);
        this.krit4.setSelected(bl);
        this.krit5.setSelected(bl);
        this.krit6.setSelected(bl);
        this.krit7.setSelected(bl);
    }

    private void initComponents() {
        this.scrollPaneKategorien = new JScrollPane();
        this.jList1 = new JList();
        this.jPanelKriterien = new JPanel();
        this.jLabel1 = new JLabel();
        this.krit1 = new JCheckBox();
        this.krit2 = new JCheckBox();
        this.krit3 = new JCheckBox();
        this.krit4 = new JCheckBox();
        this.krit5 = new JCheckBox();
        this.krit6 = new JCheckBox();
        this.krit7 = new JCheckBox();
        this.jPanelEingabefelder = new JPanel();
        this.label2 = new JLabel();
        this.label1 = new JLabel();
        this.eingabe3 = new JTextField();
        this.auswahl6 = new JCheckBox();
        this.label3 = new JLabel();
        this.eingabe4 = new JTextField();
        this.eingabe1 = new JTextField();
        this.eingabe2 = new JTextField();
        this.auswahlbox = new JComboBox();
        this.auswahl7 = new JCheckBox();
        this.auswahl1 = new JCheckBox();
        this.auswahl2 = new JCheckBox();
        this.label4 = new JLabel();
        this.label5 = new JLabel();
        this.auswahl3 = new JCheckBox();
        this.auswahl4 = new JCheckBox();
        this.auswahl5 = new JCheckBox();
        this.label6 = new JLabel();
        this.label7 = new JLabel();
        this.speichernButton = new JButton();
        this.protokolleButton = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.beschreibung = new JTextArea();
        this.jMenuBar1 = new JMenuBar();
        this.jMenu1 = new JMenu();
        this.jMenuItem1 = new JMenuItem();
        this.jMenuItem5 = new JMenuItem();
        this.jMenuItem2 = new JMenuItem();
        this.jMenuItem3 = new JMenuItem();
        this.jMenuItem4 = new JMenuItem();
        this.jMenuItem8 = new JMenuItem();
        this.jMenuItem7 = new JMenuItem();
        this.jMenuItem9 = new JMenuItem();
        this.jMenu2 = new JMenu();
        this.hilfeMenu = new JMenuItem();
        this.getContentPane().setLayout(new GridBagLayout());
        this.jList1.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                LebenMainGui.this.jList1MouseClicked(mouseEvent);
            }
        });
        this.scrollPaneKategorien.setViewportView(this.jList1);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 197;
        gridBagConstraints.ipady = 217;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.getContentPane().add((Component)this.scrollPaneKategorien, gridBagConstraints);
        this.jPanelKriterien.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jPanelKriterien.setLayout(new GridBagLayout());
        this.jLabel1.setText("Einstellungen abgespeichert:");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.ipadx = 62;
        gridBagConstraints.ipady = 10;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(10, 10, 0, 10);
        this.jPanelKriterien.add((Component)this.jLabel1, gridBagConstraints);
        this.krit1.setText("Daten ueber den Stern");
        this.krit1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.krit1.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.ipadx = 63;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 10, 0, 0);
        this.jPanelKriterien.add((Component)this.krit1, gridBagConstraints);
        this.krit2.setText("Daten ueber das Sonnensystem");
        this.krit2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.krit2.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.ipadx = 29;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(26, 10, 0, 10);
        this.jPanelKriterien.add((Component)this.krit2, gridBagConstraints);
        this.krit3.setText("Beschaffenheit des Koerpers");
        this.krit3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.krit3.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.ipadx = 45;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 10, 0, 10);
        this.jPanelKriterien.add((Component)this.krit3, gridBagConstraints);
        this.krit4.setText("Entfernung und Temperatur");
        this.krit4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.krit4.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.ipadx = 49;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 10, 0, 10);
        this.jPanelKriterien.add((Component)this.krit4, gridBagConstraints);
        this.krit5.setText("Atmosphaere");
        this.krit5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.krit5.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridheight = 5;
        gridBagConstraints.ipadx = 89;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 10, 0, 0);
        this.jPanelKriterien.add((Component)this.krit5, gridBagConstraints);
        this.krit6.setText("Oberflaechenbeschaffenheit");
        this.krit6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.krit6.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 11;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 6;
        gridBagConstraints.ipadx = 45;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 10, 0, 10);
        this.jPanelKriterien.add((Component)this.krit6, gridBagConstraints);
        this.krit7.setText("wichtige Elemente");
        this.krit7.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.krit7.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 16;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.ipadx = 67;
        gridBagConstraints.ipady = 9;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(16, 10, 6, 0);
        this.jPanelKriterien.add((Component)this.krit7, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipady = 50;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 0, 9, 0);
        this.getContentPane().add((Component)this.jPanelKriterien, gridBagConstraints);
        this.jPanelEingabefelder.setLayout(null);
        this.label2.setText("jLabel1");
        this.jPanelEingabefelder.add(this.label2);
        this.label2.setBounds(280, 300, 280, 24);
        this.label1.setText("jLabel1");
        this.jPanelEingabefelder.add(this.label1);
        this.label1.setBounds(280, 270, 280, 24);
        this.jPanelEingabefelder.add(this.eingabe3);
        this.eingabe3.setBounds(360, 270, 110, 24);
        this.auswahl6.setText("jCheckBox1");
        this.auswahl6.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jPanelEingabefelder.add(this.auswahl6);
        this.auswahl6.setBounds(460, 290, 210, 24);
        this.label3.setText("jLabel1");
        this.jPanelEingabefelder.add(this.label3);
        this.label3.setBounds(280, 330, 280, 24);
        this.jPanelEingabefelder.add(this.eingabe4);
        this.eingabe4.setBounds(520, 260, 110, 24);
        this.jPanelEingabefelder.add(this.eingabe1);
        this.eingabe1.setBounds(570, 280, 100, 24);
        this.jPanelEingabefelder.add(this.eingabe2);
        this.eingabe2.setBounds(570, 310, 100, 24);
        this.auswahlbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.auswahlboxActionPerformed(actionEvent);
            }
        });
        this.jPanelEingabefelder.add(this.auswahlbox);
        this.auswahlbox.setBounds(560, 340, 130, 24);
        this.auswahl7.setText("jCheckBox1");
        this.auswahl7.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jPanelEingabefelder.add(this.auswahl7);
        this.auswahl7.setBounds(460, 320, 210, 24);
        this.auswahl1.setText("ja/nein");
        this.auswahl1.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jPanelEingabefelder.add(this.auswahl1);
        this.auswahl1.setBounds(400, 370, 280, 24);
        this.auswahl2.setText("ja/nein");
        this.auswahl2.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jPanelEingabefelder.add(this.auswahl2);
        this.auswahl2.setBounds(400, 390, 200, 24);
        this.label4.setText("jLabel1");
        this.jPanelEingabefelder.add(this.label4);
        this.label4.setBounds(280, 360, 280, 24);
        this.label5.setText("jLabel1");
        this.jPanelEingabefelder.add(this.label5);
        this.label5.setBounds(280, 390, 300, 24);
        this.auswahl3.setText("jCheckBox1");
        this.auswahl3.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jPanelEingabefelder.add(this.auswahl3);
        this.auswahl3.setBounds(400, 410, 220, 24);
        this.auswahl4.setText("jCheckBox1");
        this.auswahl4.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jPanelEingabefelder.add(this.auswahl4);
        this.auswahl4.setBounds(400, 430, 200, 24);
        this.auswahl5.setText("jCheckBox1");
        this.auswahl5.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jPanelEingabefelder.add(this.auswahl5);
        this.auswahl5.setBounds(400, 450, 220, 24);
        this.label6.setText("jLabel2");
        this.jPanelEingabefelder.add(this.label6);
        this.label6.setBounds(280, 420, 300, 24);
        this.label7.setText("jLabel2");
        this.jPanelEingabefelder.add(this.label7);
        this.label7.setBounds(280, 450, 290, 24);
        this.speichernButton.setText("uebernehmen");
        this.speichernButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.speichernButtonActionPerformed(actionEvent);
            }
        });
        this.jPanelEingabefelder.add(this.speichernButton);
        this.speichernButton.setBounds(440, 210, 140, 24);
        this.protokolleButton.setText("Protokolle");
        this.protokolleButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.protokolleButtonActionPerformed(actionEvent);
            }
        });
        this.jPanelEingabefelder.add(this.protokolleButton);
        this.protokolleButton.setBounds(440, 180, 140, 24);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 584;
        gridBagConstraints.ipady = 239;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(6, 5, 9, 8);
        this.getContentPane().add((Component)this.jPanelEingabefelder, gridBagConstraints);
        this.jScrollPane1.setHorizontalScrollBarPolicy(31);
        this.beschreibung.setColumns(20);
        this.beschreibung.setEditable(false);
        this.beschreibung.setLineWrap(true);
        this.beschreibung.setRows(5);
        this.beschreibung.setWrapStyleWord(true);
        this.jScrollPane1.setViewportView(this.beschreibung);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 5, 0, 5);
        this.getContentPane().add((Component)this.jScrollPane1, gridBagConstraints);
        this.jMenu1.setText("Beispiele");
        this.jMenuItem1.setText("Erde (Standard)");
        this.jMenuItem1.setToolTipText("L\u00e4dt die Daten der Erde ins Programm");
        this.jMenuItem1.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.jMenuItem1ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem1);
        this.jMenuItem5.setText("Mars");
        this.jMenuItem5.setToolTipText("L\u00e4dt die Daten von Mars ins Programm");
        this.jMenuItem5.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.jMenuItem5ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem5);
        this.jMenuItem2.setText("Titan");
        this.jMenuItem2.setToolTipText("L\u00e4dt die Daten von Titan ins Programm");
        this.jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.jMenuItem2ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem2);
        this.jMenuItem3.setText("Ganymed");
        this.jMenuItem3.setToolTipText("L\u00e4dt die Daten von Ganymed ins Programm");
        this.jMenuItem3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.jMenuItem3ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem3);
        this.jMenuItem4.setText("Europa");
        this.jMenuItem4.setToolTipText("L\u00e4dt die Daten von Europa ins Programm");
        this.jMenuItem4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.jMenuItem4ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem4);
        this.jMenuItem8.setText("Enceladus");
        this.jMenuItem8.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.jMenuItem8ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem8);
        this.jMenuItem7.setText("Gliese 581 e");
        this.jMenuItem7.setToolTipText("L\u00e4dt die Daten von GL 581 c ins Programm");
        this.jMenuItem7.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.jMenuItem7ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem7);
        this.jMenuItem9.setText("HD 209458 b");
        this.jMenuItem9.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.jMenuItem9ActionPerformed(actionEvent);
            }
        });
        this.jMenu1.add(this.jMenuItem9);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu2.setText("Hilfe");
        this.hilfeMenu.setText("Info");
        this.hilfeMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LebenMainGui.this.hilfeMenuActionPerformed(actionEvent);
            }
        });
        this.jMenu2.add(this.hilfeMenu);
        this.jMenuBar1.add(this.jMenu2);
        this.setJMenuBar(this.jMenuBar1);
        this.setSize(new Dimension(834, 554));
        this.setLocationRelativeTo(null);
    }

    private void jMenuItem7ActionPerformed(ActionEvent actionEvent) {
        this.lebenskriterien = new GJ581e().getDaten();
        this.alleFragenBeantwortet(true);
        JOptionPane.showMessageDialog(this, this.i18n.getString("leb_m7"), this.i18n.getString("leb_m7_titel"), 1);
    }

    private void hilfeMenuActionPerformed(ActionEvent actionEvent) {
        JOptionPane.showMessageDialog(this, this.i18n.getString("leb_m8") + " \u00a9 by Gerd Guehne", "Programminfo", 1, null);
    }

    private void jMenuItem5ActionPerformed(ActionEvent actionEvent) {
        this.lebenskriterien = new Mars().getDaten();
        this.alleFragenBeantwortet(true);
        JOptionPane.showMessageDialog(this, this.i18n.getString("leb_m9"), this.i18n.getString("leb_m9_titel"), 1);
    }

    private void jMenuItem4ActionPerformed(ActionEvent actionEvent) {
        this.lebenskriterien = new Europa().getDaten();
        this.alleFragenBeantwortet(true);
        JOptionPane.showMessageDialog(this, this.i18n.getString("leb_m9"), this.i18n.getString("leb_m9_titel"), 1);
    }

    private void jMenuItem3ActionPerformed(ActionEvent actionEvent) {
        this.lebenskriterien = new Ganymed().getDaten();
        this.alleFragenBeantwortet(true);
        JOptionPane.showMessageDialog(this, this.i18n.getString("leb_m9"), this.i18n.getString("leb_m9_titel"), 1);
    }

    private void speichernButtonActionPerformed(ActionEvent actionEvent) {
        switch (this.jList1.getSelectedIndex()) {
            case 1: {
                if (this.auswahlbox.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(this, this.i18n.getString("leb_f5"), this.i18n.getString("leb_f4_titel"), 0);
                    return;
                }
                this.lebenskriterien.setNaheDemGalaxienzentrum(this.auswahl1.isSelected());
                this.lebenskriterien.setNaheEinesSternentstehungsgebiets(this.auswahl2.isSelected());
                this.lebenskriterien.setSpektraltyp(this.auswahlbox.getSelectedItem().toString());
                this.lebenskriterien.setMasseDesSterns(this.i18n.parseDouble(this.eingabe1.getText()));
                this.lebenskriterien.setAbsoluteHelligkeitDesSterns(this.i18n.parseDouble(this.eingabe2.getText()));
                this.krit1.setSelected(true);
                break;
            }
            case 2: {
                if (this.auswahlbox.getSelectedIndex() == -1) {
                    JOptionPane.showMessageDialog(this, this.i18n.getString("leb_f4"), this.i18n.getString("leb_f4_titel"), 0);
                    return;
                }
                if (this.auswahlbox.getSelectedIndex() == -1 || this.auswahlbox.getSelectedIndex() == 0) {
                    this.lebenskriterien.setKategorie(ObjektKategorie.PLANET);
                } else {
                    this.lebenskriterien.setKategorie(ObjektKategorie.MOND);
                }
                this.lebenskriterien.setObjektNochInDerEntstehungsphase(this.auswahl1.isSelected());
                this.lebenskriterien.setObjektHatEinenGasplanet(this.auswahl2.isSelected());
                this.lebenskriterien.setObjektHatEinenMond(this.auswahl3.isSelected());
                this.krit2.setSelected(true);
                break;
            }
            case 3: {
                this.lebenskriterien.setDurchmesserInKm(this.i18n.parseDouble(this.eingabe1.getText()));
                this.lebenskriterien.setMasseInKg(this.i18n.parseDouble(this.eingabe2.getText()));
                this.lebenskriterien.setMagnetfeldVorhanden(this.auswahl1.isSelected());
                this.lebenskriterien.setAtmosphaereVorhanden(this.auswahl2.isSelected());
                this.krit3.setSelected(true);
                break;
            }
            case 4: {
                double d = this.i18n.parseDouble(this.eingabe3.getText());
                double d2 = this.i18n.parseDouble(this.eingabe4.getText());
                if (d < d2) {
                    JOptionPane.showMessageDialog(this, this.i18n.getString("leb_f1"), this.i18n.getString("db_f4_titel"), 0);
                    return;
                }
                this.lebenskriterien.setAphelInAE(this.i18n.parseDouble(this.eingabe1.getText()));
                this.lebenskriterien.setPerihelInAE(this.i18n.parseDouble(this.eingabe2.getText()));
                this.lebenskriterien.setOberflaechentemperaturMax(d);
                this.lebenskriterien.setOberflaechentemperaturMin(d2);
                this.krit4.setSelected(true);
                break;
            }
            case 5: {
                this.lebenskriterien.setSchwefelVorhanden(this.auswahl1.isSelected());
                this.lebenskriterien.setWasserdampfVorhanden(this.auswahl2.isSelected());
                this.lebenskriterien.setSauerstoffVorhanden(this.auswahl3.isSelected());
                this.lebenskriterien.setKohlenstoffdioxidVorhanden(this.auswahl4.isSelected());
                this.lebenskriterien.setWasserstoffVorhanden(this.auswahl5.isSelected());
                this.lebenskriterien.setStickstoffVorhanden(this.auswahl6.isSelected());
                this.lebenskriterien.setMethanVorhanden(this.auswahl7.isSelected());
                this.krit5.setSelected(true);
                break;
            }
            case 6: {
                this.lebenskriterien.setVulkanismusVorhanden(this.auswahl1.isSelected());
                this.lebenskriterien.setKryovulkanismusVorhanden(this.auswahl2.isSelected());
                this.lebenskriterien.setVieleKratereinschlaegeVorhanden(this.auswahl3.isSelected());
                this.lebenskriterien.setOzeanVorhanden(this.auswahl4.isSelected());
                this.krit6.setSelected(true);
                break;
            }
            case 7: {
                this.lebenskriterien.setMagnesiumVorhanden(this.auswahl1.isSelected());
                this.lebenskriterien.setKaliumVorhanden(this.auswahl2.isSelected());
                this.lebenskriterien.setNatriumVorhanden(this.auswahl3.isSelected());
                this.lebenskriterien.setEisenVorhanden(this.auswahl4.isSelected());
                this.lebenskriterien.setPhosphorVorhanden(this.auswahl5.isSelected());
                this.krit7.setSelected(true);
                break;
            }
        }
        JOptionPane.showMessageDialog(this, this.i18n.getString("db_m277"), this.i18n.getString("db_m277_titel"), 1);
    }

    private void jMenuItem2ActionPerformed(ActionEvent actionEvent) {
        this.lebenskriterien = new Titan().getDaten();
        this.alleFragenBeantwortet(true);
        JOptionPane.showMessageDialog(this, this.i18n.getString("leb_m9"), this.i18n.getString("leb_m9_titel"), 1);
    }

    private void jMenuItem1ActionPerformed(ActionEvent actionEvent) {
        this.lebenskriterien = new Erde();
        this.alleFragenBeantwortet(true);
        JOptionPane.showMessageDialog(this, this.i18n.getString("leb_m9"), this.i18n.getString("leb_m9_titel"), 1);
    }

    public static String clearHTML(String string) {
        return string.replaceAll("<html>", "").replaceAll("</html>", "");
    }

    private void zeigeEinfuehrung() {
        this.beschreibung.setText(LebenMainGui.clearHTML(this.i18n.getString("leb_m1") + "\n\n" + this.i18n.getString("leb_m2") + "\n\n" + this.i18n.getString("leb_m3") + "\n\n" + this.i18n.getString("leb_m4") + "\n\n" + this.i18n.getString("leb_m5")));
    }

    private void zeigeKriterienSternUndGalaxie(int n, int n2) {
        this.beschreibung.setText(LebenMainGui.clearHTML(this.i18n.getString("leb_gui2") + "\n\n" + this.i18n.getString("leb_m10") + "\n\n" + this.i18n.getString("leb_m11") + "\n\n" + this.i18n.getString("leb_m12")));
        this.label1.setText(this.i18n.getString("leb_m13"));
        this.label1.setVisible(true);
        this.auswahl1.setText(this.i18n.getString(JA));
        this.auswahl1.setSelected(this.lebenskriterien.isNaheDemGalaxienzentrum());
        this.auswahl1.setBounds(n, n2, 100, 20);
        this.auswahl1.setVisible(true);
        this.label2.setText(this.i18n.getString("leb_m14"));
        this.label2.setVisible(true);
        this.auswahl2.setText(this.i18n.getString(JA));
        this.auswahl2.setSelected(this.lebenskriterien.isNaheEinesSternentstehungsgebiets());
        this.auswahl2.setBounds(n, n2 + 30, 100, 20);
        this.auswahl2.setVisible(true);
        this.label3.setText(this.i18n.getString("leb_m15"));
        this.label3.setVisible(true);
        this.auswahlbox.removeAllItems();
        this.auswahlbox.addItem("O");
        this.auswahlbox.addItem("B");
        this.auswahlbox.addItem("A");
        this.auswahlbox.addItem("F");
        this.auswahlbox.addItem("G");
        this.auswahlbox.addItem("K");
        this.auswahlbox.addItem("M");
        this.auswahlbox.setSelectedItem(this.lebenskriterien.getSpektraltyp());
        this.auswahlbox.setBounds(n, n2 + 60, 100, 20);
        this.auswahlbox.setVisible(true);
        this.label4.setText(this.i18n.getString("leb_m16"));
        this.label4.setVisible(true);
        this.eingabe1.setText(Double.toString(this.lebenskriterien.getMasseDesSterns()));
        this.eingabe1.setBounds(n, n2 + 90, 100, 24);
        this.eingabe1.setVisible(true);
        this.label5.setText(this.i18n.getString("leb_m17"));
        this.label5.setVisible(true);
        this.eingabe2.setText(Double.toString(this.lebenskriterien.getAbsoluteHelligkeitDesSterns()));
        this.eingabe2.setBounds(n, n2 + 120, 100, 24);
        this.eingabe2.setVisible(true);
        this.speichernButton.setEnabled(true);
    }

    private void zeigeKriterienKoerper(int n, int n2) {
        String string = this.i18n.getString("leb_gui3") + "\n\n" + this.i18n.getString("leb_m18") + "\n\n" + this.i18n.getString("leb_m19") + "\n\n" + this.i18n.getString("leb_m20") + "\n\n" + this.i18n.getString("leb_m21");
        this.beschreibung.setText(LebenMainGui.clearHTML(string));
        this.label1.setText(this.i18n.getString("leb_gui12"));
        this.label1.setVisible(true);
        this.auswahlbox.removeAllItems();
        this.auswahlbox.addItem("Planet");
        this.auswahlbox.addItem("Mond");
        this.auswahlbox.setSelectedItem((Object)this.lebenskriterien.getKategorie());
        this.auswahlbox.setBounds(n, n2, 100, 20);
        this.auswahlbox.setVisible(true);
        this.label2.setText(this.i18n.getString("leb_m22"));
        this.label2.setVisible(true);
        this.auswahl1.setText(this.i18n.getString(JA));
        this.auswahl1.setSelected(this.lebenskriterien.isObjektNochInDerEntstehungsphase());
        this.auswahl1.setBounds(n, n2 + 30, 100, 20);
        this.auswahl1.setVisible(true);
        this.label3.setText(this.i18n.getString("leb_m23"));
        this.label3.setVisible(true);
        this.auswahl2.setText(this.i18n.getString(JA));
        this.auswahl2.setSelected(this.lebenskriterien.isObjektHatEinenGasplanet());
        this.auswahl2.setBounds(n, n2 + 60, 100, 20);
        this.auswahl2.setVisible(true);
        this.label4.setText(this.i18n.getString("leb_m24"));
        this.label4.setVisible(true);
        this.auswahl3.setText(this.i18n.getString(JA));
        this.auswahl3.setSelected(this.lebenskriterien.isObjektHatEinenMond());
        this.auswahl3.setBounds(n, n2 + 90, 100, 20);
        this.auswahl3.setVisible(true);
        this.speichernButton.setEnabled(true);
    }

    private void zeigeKriterienKoerperPhysik(int n, int n2) {
        this.beschreibung.setText(LebenMainGui.clearHTML(this.i18n.getString("leb_gui4") + "\n\n" + this.i18n.getString("leb_m26") + "\n\n" + this.i18n.getString("leb_m27") + "\n\n" + this.i18n.getString("leb_m28") + "\n\n" + this.i18n.getString("leb_m29")));
        this.label1.setText(this.i18n.getString("leb_gui13"));
        this.label1.setVisible(true);
        this.eingabe1.setText(Double.toString(this.lebenskriterien.getDurchmesserInKm()));
        this.eingabe1.setBounds(n, n2, 100, 24);
        this.eingabe1.setVisible(true);
        this.label2.setText(this.i18n.getString("leb_gui34"));
        this.label2.setVisible(true);
        this.eingabe2.setText(Double.toString(this.lebenskriterien.getMasseInKg()));
        this.eingabe2.setBounds(n, n2 + 30, 100, 24);
        this.eingabe2.setVisible(true);
        this.label3.setText(this.i18n.getString("leb_gui35"));
        this.label3.setVisible(true);
        this.auswahl1.setText(this.i18n.getString(JA));
        this.auswahl1.setSelected(this.lebenskriterien.isMagnetfeldVorhanden());
        this.auswahl1.setBounds(n, n2 + 60, 100, 20);
        this.auswahl1.setVisible(true);
        this.label4.setText(this.i18n.getString("leb_gui36"));
        this.label4.setVisible(true);
        this.auswahl2.setText(this.i18n.getString(JA));
        this.auswahl2.setSelected(this.lebenskriterien.isAtmosphaereVorhanden());
        this.auswahl2.setBounds(n, n2 + 90, 100, 20);
        this.auswahl2.setVisible(true);
        this.speichernButton.setEnabled(true);
    }

    private void zeigeKriterienBahnparameterUndTemperatur(int n, int n2) {
        this.beschreibung.setText(LebenMainGui.clearHTML(this.i18n.getString("leb_gui5") + "\n\n" + this.i18n.getString("leb_m30") + "\n\n" + this.i18n.getString("leb_m31") + "\n\n" + this.i18n.getString("leb_m32")));
        this.label1.setText(this.i18n.getString("leb_gui14"));
        this.label1.setVisible(true);
        this.eingabe1.setText(Double.toString(this.lebenskriterien.getAphelInAE()));
        this.eingabe1.setBounds(n, n2, 100, 24);
        this.eingabe1.setVisible(true);
        this.label2.setText(this.i18n.getString("leb_gui15"));
        this.label2.setVisible(true);
        this.eingabe2.setText(Double.toString(this.lebenskriterien.getPerihelInAE()));
        this.eingabe2.setBounds(n, n2 + 30, 100, 24);
        this.eingabe2.setVisible(true);
        this.label3.setText(this.i18n.getString("leb_gui16"));
        this.label3.setVisible(true);
        this.eingabe3.setText(Double.toString(this.lebenskriterien.getOberflaechentemperaturMax()));
        this.eingabe3.setBounds(n, n2 + 60, 100, 24);
        this.eingabe3.setVisible(true);
        this.label4.setText(this.i18n.getString("leb_gui17"));
        this.label4.setVisible(true);
        this.eingabe4.setText(Double.toString(this.lebenskriterien.getOberflaechentemperaturMin()));
        this.eingabe4.setBounds(n, n2 + 90, 100, 24);
        this.eingabe4.setVisible(true);
        this.speichernButton.setEnabled(true);
    }

    private void zeigeKriterienWichtigerElemente(int n, int n2) {
        this.beschreibung.setText(LebenMainGui.clearHTML(this.i18n.getString("leb_gui6") + "\n\n" + this.i18n.getString("leb_m33") + "\n\n" + this.i18n.getString("leb_m34") + "\n\n" + this.i18n.getString("leb_m35") + "\n\n" + this.i18n.getString("leb_m36") + "\n\n" + this.i18n.getString("leb_m37")));
        this.label1.setText(this.i18n.getString("leb_gui18"));
        this.label1.setVisible(true);
        this.auswahl1.setText(this.i18n.getString(JA));
        this.auswahl1.setSelected(this.lebenskriterien.isSchwefelVorhanden());
        this.auswahl1.setBounds(n, n2, 100, 20);
        this.auswahl1.setVisible(true);
        this.label2.setText(this.i18n.getString("leb_gui19"));
        this.label2.setVisible(true);
        this.auswahl2.setText(this.i18n.getString(JA));
        this.auswahl2.setSelected(this.lebenskriterien.isWasserdampfVorhanden());
        this.auswahl2.setBounds(n, n2 + 30, 100, 20);
        this.auswahl2.setVisible(true);
        this.label3.setText(this.i18n.getString("leb_gui20"));
        this.label3.setVisible(true);
        this.auswahl3.setText(this.i18n.getString(JA));
        this.auswahl3.setSelected(this.lebenskriterien.isSauerstoffVorhanden());
        this.auswahl3.setBounds(n, n2 + 60, 100, 20);
        this.auswahl3.setVisible(true);
        this.label4.setText(this.i18n.getString("leb_gui21"));
        this.label4.setVisible(true);
        this.auswahl4.setText(this.i18n.getString(JA));
        this.auswahl4.setSelected(this.lebenskriterien.isKohlenstoffdioxidVorhanden());
        this.auswahl4.setBounds(n, n2 + 90, 100, 20);
        this.auswahl4.setVisible(true);
        this.label5.setText(this.i18n.getString("leb_gui22"));
        this.label5.setVisible(true);
        this.auswahl5.setText(this.i18n.getString(JA));
        this.auswahl5.setSelected(this.lebenskriterien.isWasserstoffVorhanden());
        this.auswahl5.setBounds(n, n2 + 120, 100, 20);
        this.auswahl5.setVisible(true);
        this.label6.setText(this.i18n.getString("leb_gui23"));
        this.label6.setVisible(true);
        this.auswahl6.setText(this.i18n.getString(JA));
        this.auswahl6.setSelected(this.lebenskriterien.isStickstoffVorhanden());
        this.auswahl6.setBounds(n, n2 + 150, 100, 20);
        this.auswahl6.setVisible(true);
        this.label7.setText(this.i18n.getString("leb_gui24"));
        this.label7.setVisible(true);
        this.auswahl7.setText(this.i18n.getString(JA));
        this.auswahl7.setSelected(this.lebenskriterien.isMethanVorhanden());
        this.auswahl7.setBounds(n, n2 + 180, 100, 20);
        this.auswahl7.setVisible(true);
        this.speichernButton.setEnabled(true);
        if (!this.lebenskriterien.isAtmosphaereVorhanden()) {
            this.auswahl1.setSelected(false);
            this.auswahl2.setSelected(false);
            this.auswahl3.setSelected(false);
            this.auswahl4.setSelected(false);
            this.auswahl5.setSelected(false);
            this.auswahl6.setSelected(false);
            this.auswahl7.setSelected(false);
            JOptionPane.showMessageDialog(this, this.i18n.getString("leb_m38"), this.i18n.getString("leb_m75_titel"), 2);
        }
    }

    private void zeigeKriterienGeologischAktiv(int n, int n2) {
        this.beschreibung.setText(LebenMainGui.clearHTML(this.i18n.getString("leb_gui7") + "\n\n" + this.i18n.getString("leb_m39") + "\n\n" + this.i18n.getString("leb_m40") + "\n\n" + this.i18n.getString("leb_m41") + "\n\n" + this.i18n.getString("leb_m42") + "\n\n" + this.i18n.getString("leb_m43") + "\n\n" + this.i18n.getString("leb_m44") + "\n\n" + this.i18n.getString("leb_m45") + "\n\n" + this.i18n.getString("leb_m46")));
        this.label1.setText(this.i18n.getString("leb_gui25"));
        this.label1.setVisible(true);
        this.auswahl1.setText(this.i18n.getString(JA));
        this.auswahl1.setSelected(this.lebenskriterien.isVulkanismusVorhanden());
        this.auswahl1.setBounds(n, n2, 100, 20);
        this.auswahl1.setVisible(true);
        this.label2.setText(this.i18n.getString("leb_gui26"));
        this.label2.setVisible(true);
        this.auswahl2.setText(this.i18n.getString(JA));
        this.auswahl2.setSelected(this.lebenskriterien.isKryovulkanismusVorhanden());
        this.auswahl2.setBounds(n, n2 + 30, 100, 20);
        this.auswahl2.setVisible(true);
        this.label3.setText(this.i18n.getString("leb_gui27"));
        this.label3.setVisible(true);
        this.auswahl3.setText(this.i18n.getString(JA));
        this.auswahl3.setSelected(this.lebenskriterien.isVieleKratereinschlaegeVorhanden());
        this.auswahl3.setBounds(n, n2 + 60, 100, 20);
        this.auswahl3.setVisible(true);
        this.label4.setText(this.i18n.getString("leb_gui28"));
        this.label4.setVisible(true);
        this.auswahl4.setText(this.i18n.getString(JA));
        this.auswahl4.setSelected(this.lebenskriterien.isOzeanVorhanden());
        this.auswahl4.setBounds(n, n2 + 90, 100, 20);
        this.auswahl4.setVisible(true);
        this.speichernButton.setEnabled(true);
    }

    private void zeigeKriterienWeitererWichtigerElemente(int n, int n2) {
        this.beschreibung.setText(LebenMainGui.clearHTML(this.i18n.getString("leb_gui8") + "\n\n" + this.i18n.getString("leb_m47") + "\n\n" + this.i18n.getString("leb_m48") + "\n\n" + this.i18n.getString("leb_m49")));
        this.label1.setText(this.i18n.getString("leb_gui29"));
        this.label1.setVisible(true);
        this.auswahl1.setText(this.i18n.getString(JA));
        this.auswahl1.setSelected(this.lebenskriterien.isMagnesiumVorhanden());
        this.auswahl1.setBounds(n, n2, 100, 20);
        this.auswahl1.setVisible(true);
        this.label2.setText(this.i18n.getString("leb_gui30"));
        this.label2.setVisible(true);
        this.auswahl2.setText(this.i18n.getString(JA));
        this.auswahl2.setSelected(this.lebenskriterien.isKaliumVorhanden());
        this.auswahl2.setBounds(n, n2 + 30, 100, 20);
        this.auswahl2.setVisible(true);
        this.label3.setText(this.i18n.getString("leb_gui31"));
        this.label3.setVisible(true);
        this.auswahl3.setText(this.i18n.getString(JA));
        this.auswahl3.setSelected(this.lebenskriterien.isNatriumVorhanden());
        this.auswahl3.setBounds(n, n2 + 60, 100, 20);
        this.auswahl3.setVisible(true);
        this.label4.setText(this.i18n.getString("leb_gui32"));
        this.label4.setVisible(true);
        this.auswahl4.setText(this.i18n.getString(JA));
        this.auswahl4.setSelected(this.lebenskriterien.isEisenVorhanden());
        this.auswahl4.setBounds(n, n2 + 90, 100, 20);
        this.auswahl4.setVisible(true);
        this.label5.setText(this.i18n.getString("leb_gui33"));
        this.label5.setVisible(true);
        this.auswahl5.setText(this.i18n.getString(JA));
        this.auswahl5.setSelected(this.lebenskriterien.isPhosphorVorhanden());
        this.auswahl5.setBounds(n, n2 + 120, 100, 20);
        this.auswahl5.setVisible(true);
        this.speichernButton.setEnabled(true);
    }

    private void jList1MouseClicked(MouseEvent mouseEvent) {
        this.disableAllInputFields();
        this.protokolleButton.setVisible(false);
        int n = 450;
        int n2 = 10;
        this.label1.setBounds(10, n2, 400, 20);
        this.label2.setBounds(10, n2 + 30, 400, 20);
        this.label3.setBounds(10, n2 + 60, 400, 20);
        this.label4.setBounds(10, n2 + 90, 400, 20);
        this.label5.setBounds(10, n2 + 120, 400, 20);
        this.label6.setBounds(10, n2 + 150, 400, 20);
        this.label7.setBounds(10, n2 + 180, 400, 20);
        switch (this.jList1.getSelectedIndex()) {
            case 0: {
                this.zeigeEinfuehrung();
                break;
            }
            case 1: {
                this.zeigeKriterienSternUndGalaxie(n, n2);
                break;
            }
            case 2: {
                this.zeigeKriterienKoerper(n, n2);
                break;
            }
            case 3: {
                this.zeigeKriterienKoerperPhysik(n, n2);
                break;
            }
            case 4: {
                this.zeigeKriterienBahnparameterUndTemperatur(n, n2);
                break;
            }
            case 5: {
                this.zeigeKriterienWichtigerElemente(n, n2);
                break;
            }
            case 6: {
                this.zeigeKriterienGeologischAktiv(n, n2);
                break;
            }
            case 7: {
                this.zeigeKriterienWeitererWichtigerElemente(n, n2);
                break;
            }
            case 8: {
                boolean bl;
                boolean bl2 = this.krit3.isSelected() && this.krit4.isSelected() && this.krit5.isSelected() && this.krit6.isSelected() && this.krit7.isSelected();
                boolean bl3 = bl = this.krit1.isSelected() && this.krit2.isSelected() && bl2;
                if (bl) {
                    this.berechneErgebnis();
                    break;
                }
                JOptionPane.showMessageDialog(this, this.i18n.getString("leb_f3"), this.i18n.getString("db_f4_titel"), 0);
                break;
            }
        }
        this.beschreibung.setCaretPosition(0);
    }

    private void berechneErgebnis() {
        this.speichernButton.setEnabled(false);
        FeatureRepository featureRepository = new FeatureRepository();
        boolean bl = featureRepository.isFeatureActive(PlanetensucheFeature.WAHRSCHEINLICHKEITSRECHNUNG_II);
        if (bl) {
            this.protokolleButton.setVisible(true);
            this.beschreibung.setText(this.i18n.getString("leb_m50") + "\n\n");
            int n = 0;
            BruchRechner bruchRechner = new BruchRechner();
            WahrscheinlichkeitsrechnerControler wahrscheinlichkeitsrechnerControler = new WahrscheinlichkeitsrechnerControler();
            this.ergebnis = wahrscheinlichkeitsrechnerControler.starteAnalyse(this.lebenskriterien);
            List<Wahrscheinlichkeitsergebnis> list = wahrscheinlichkeitsrechnerControler.starteAnalyse(new Erde());
            for (Wahrscheinlichkeitsergebnis wahrscheinlichkeitsergebnis : this.ergebnis) {
                if (!wahrscheinlichkeitsergebnis.isIstLebenMoeglich()) continue;
                String string = wahrscheinlichkeitsergebnis.getLebensform().getName();
                this.beschreibung.append("Leben m\u00f6glich f\u00fcr: " + string);
                this.beschreibung.append("\n");
                this.beschreibung.append("Wahrscheinlichkeit: " + wahrscheinlichkeitsergebnis.getWahrscheinlichkeit());
                this.beschreibung.append("\n");
                for (Wahrscheinlichkeitsergebnis wahrscheinlichkeitsergebnis2 : list) {
                    if (!wahrscheinlichkeitsergebnis2.getLebensform().getName().equals(string)) continue;
                    double d = wahrscheinlichkeitsergebnis.getWahrscheinlichkeit() - wahrscheinlichkeitsergebnis2.getWahrscheinlichkeit();
                    this.beschreibung.append("Leben ist damit um " + bruchRechner.getBruch(d) + " unwahrscheinlicher, als auf der Erde.");
                }
                this.beschreibung.append("\n\n");
                ++n;
            }
            if (n == 0) {
                this.beschreibung.append(this.i18n.getString("leb_m54") + " " + this.lebenskriterien.getName() + " " + this.i18n.getString("leb_m55"));
            }
        } else {
            Wahrscheinlichkeitsberechnung wahrscheinlichkeitsberechnung = new Wahrscheinlichkeitsberechnung(this.i18n);
            wahrscheinlichkeitsberechnung.berechneUndZeigeErgebnisAn(this.lebenskriterien, this.beschreibung);
        }
        this.beschreibung.setCaretPosition(0);
        this.alleFragenBeantwortet(false);
    }

    private void jMenuItem8ActionPerformed(ActionEvent actionEvent) {
        this.lebenskriterien = new Enceladus().getDaten();
        this.alleFragenBeantwortet(true);
        JOptionPane.showMessageDialog(this, this.i18n.getString("leb_m9"), this.i18n.getString("leb_m9_titel"), 1);
    }

    private void auswahlboxActionPerformed(ActionEvent actionEvent) {
        if (this.auswahlbox.getSelectedIndex() > -1) {
            switch (this.auswahlbox.getSelectedItem().toString()) {
                case "Mond": {
                    this.label4.setText(this.i18n.getString("leb_m24"));
                    break;
                }
                case "Planet": {
                    this.label4.setText(this.i18n.getString("leb_m25"));
                    break;
                }
                default: {
                    this.label4.setText("error");
                }
            }
        }
    }

    private void jMenuItem9ActionPerformed(ActionEvent actionEvent) {
        this.lebenskriterien = new HD209458b().getDaten();
        this.alleFragenBeantwortet(true);
        JOptionPane.showMessageDialog(this, this.i18n.getString("leb_m7"), this.i18n.getString("leb_m7_titel"), 1);
    }

    private void protokolleButtonActionPerformed(ActionEvent actionEvent) {
        for (Wahrscheinlichkeitsergebnis wahrscheinlichkeitsergebnis : this.ergebnis) {
            ProtokollDialog protokollDialog = new ProtokollDialog(wahrscheinlichkeitsergebnis.getLebensform().getName(), wahrscheinlichkeitsergebnis.getProtokoll());
            protokollDialog.setVisible(true);
        }
    }

    @Override
    public void showDialog() {
        int n;
        if (this.scrollPaneKategorien != null) {
            this.setVisible(true);
            return;
        }
        this.initComponents();
        this.protokolleButton.setVisible(false);
        this.disableAllInputFields();
        this.jList1.setSelectedIndex(0);
        this.zeigeEinfuehrung();
        this.beschreibung.setCaretPosition(0);
        this.setTitle(this.i18n.getString("leb_fenster"));
        this.jMenu1.setText(this.i18n.getString("leb_menu1"));
        this.jMenuItem1.setText(this.i18n.getString("leb_menu2"));
        this.jMenu2.setText(this.i18n.getString("db_menu_19"));
        this.hilfeMenu.setText(this.i18n.getString("db_menu_25"));
        this.hilfeMenu.setIcon(IconPoolDefault.INFO.getImageIcon());
        this.jList1.setModel(new AbstractListModel(){
            private String[] strings;
            {
                this.strings = new String[]{LebenMainGui.this.i18n.getString("leb_gui1"), LebenMainGui.this.i18n.getString("leb_gui2"), LebenMainGui.this.i18n.getString("leb_gui3"), LebenMainGui.this.i18n.getString("leb_gui4"), LebenMainGui.this.i18n.getString("leb_gui5"), LebenMainGui.this.i18n.getString("leb_gui6"), LebenMainGui.this.i18n.getString("leb_gui7"), LebenMainGui.this.i18n.getString("leb_gui8"), LebenMainGui.this.i18n.getString("leb_gui9")};
            }

            @Override
            public int getSize() {
                return this.strings.length;
            }

            @Override
            public Object getElementAt(int n) {
                return this.strings[n];
            }
        });
        this.jLabel1.setText(this.i18n.getString("leb_gui10"));
        this.krit1.setText(this.i18n.getString("leb_gui2"));
        this.krit2.setText(this.i18n.getString("leb_gui3"));
        this.krit3.setText(this.i18n.getString("leb_gui4"));
        this.krit4.setText(this.i18n.getString("leb_gui5"));
        this.krit5.setText(this.i18n.getString("leb_gui6"));
        this.krit6.setText(this.i18n.getString("leb_gui7"));
        this.krit7.setText(this.i18n.getString("leb_gui8"));
        this.speichernButton.setText(null);
        this.speichernButton.setIcon(IconPoolDefault.SAVE.getImageIcon());
        this.speichernButton.setToolTipText(this.i18n.getString("db_gui90"));
        this.speichernButton.setBounds(500, 210, 24, 24);
        for (n = 0; n < this.getContentPane().getComponentCount(); ++n) {
            this.getGuiDesigner().addComponent((JComponent)this.getContentPane().getComponent(n), false);
        }
        for (n = 0; n < this.jPanelKriterien.getComponentCount(); ++n) {
            this.getGuiDesigner().addComponent((JComponent)this.jPanelKriterien.getComponent(n), false);
        }
        this.getGuiDesigner().addComponent(this.jList1, false);
        this.getGuiDesigner().addComponent(this.beschreibung, false);
        this.setVisible(true);
    }
}

