/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.leben;

import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.leben.LebenMainGui;
import de.planetensuche.leben.berechnungen.formeln.PunkteBerechner;
import de.planetensuche.leben.berechnungen.lebensformen.LebensformenBewerter;
import de.planetensuche.leben.berechnungen.lebensformen.api.Lebensformen;
import de.planetensuche.leben.datenmodel.Lebensraum;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import javax.swing.JOptionPane;
import javax.swing.JTextArea;

public final class Wahrscheinlichkeitsberechnung {
    private final ILogging logging = LoggingFactory.getLoggerForClass(this.getClass());
    private final ISprachcontainer sprache;

    public Wahrscheinlichkeitsberechnung(ISprachcontainer iSprachcontainer) {
        this.sprache = iSprachcontainer;
    }

    public void berechneUndZeigeErgebnisAn(Lebensraum lebensraum, JTextArea jTextArea) {
        try {
            jTextArea.setText(this.sprache.getString("leb_gui9") + ":\n\n" + this.sprache.getString("leb_m50") + "\n\n");
            PunkteBerechner punkteBerechner = new PunkteBerechner();
            int n = punkteBerechner.berechnePunkteFuerAlleKriterien(lebensraum);
            Lebensformen lebensformen = new Lebensformen();
            if (n > 0) {
                LebensformenBewerter lebensformenBewerter = new LebensformenBewerter();
                lebensformen = lebensformenBewerter.bewerteHimmelskoerper(lebensraum, lebensformen);
            }
            this.gibErgebnisInTextfeldAus(n, jTextArea, lebensraum, lebensformen);
        }
        catch (Exception exception) {
            this.logging.error(exception);
            JOptionPane.showMessageDialog(null, this.sprache.getString("leb_f2") + "\n" + exception.toString(), this.sprache.getString("leb_f2_titel"), 0);
        }
    }

    private void gibErgebnisInTextfeldAus(int n, JTextArea jTextArea, Lebensraum lebensraum, Lebensformen lebensformen) {
        if (n > 0) {
            jTextArea.setText(jTextArea.getText() + this.sprache.getString("leb_m51") + " " + String.valueOf((Object)lebensraum.getKategorie()) + " " + this.sprache.getString("leb_m52") + " " + n + " " + this.sprache.getString("leb_m53") + ".\n");
        }
        if (n <= 0) {
            jTextArea.setText(jTextArea.getText() + this.sprache.getString("leb_m54") + " " + String.valueOf((Object)lebensraum.getKategorie()) + " " + this.sprache.getString("leb_m55"));
        } else if (n > 0 && n <= 50) {
            jTextArea.setText(jTextArea.getText() + this.sprache.getString("leb_m56") + " " + String.valueOf((Object)lebensraum.getKategorie()) + " " + this.sprache.getString("leb_m57"));
        } else if (n > 50 && n <= 80) {
            jTextArea.setText(jTextArea.getText() + this.sprache.getString("leb_m58"));
        } else if (n > 80) {
            jTextArea.setText(jTextArea.getText() + this.sprache.getString("leb_m59") + " " + String.valueOf((Object)lebensraum.getKategorie()) + " " + this.sprache.getString("leb_m60"));
        }
        if (n > 0) {
            String string = this.verketteExtremophile(lebensformen);
            if (string.endsWith(", ")) {
                string = string.substring(0, string.length() - 2);
            }
            jTextArea.setText(jTextArea.getText() + this.sprache.getString("leb_m61") + " " + String.valueOf((Object)lebensraum.getKategorie()) + " " + this.sprache.getString("leb_m62") + string + "\n\n" + this.sprache.getString("leb_m63") + "\n" + this.sprache.getString("leb_m64") + "\n" + this.sprache.getString("leb_m65") + "\n" + this.sprache.getString("leb_m66") + "\n" + this.sprache.getString("leb_m67") + "\n" + this.sprache.getString("leb_m68") + "\n" + this.sprache.getString("leb_m69") + "\n" + this.sprache.getString("leb_m70") + "\n" + this.sprache.getString("leb_m71") + "\n" + this.sprache.getString("leb_m72") + "\n" + this.sprache.getString("leb_m73") + "\n" + this.sprache.getString("leb_m74"));
        }
        jTextArea.setText(LebenMainGui.clearHTML(jTextArea.getText()));
    }

    private String verketteExtremophile(Lebensformen lebensformen) {
        StringBuilder stringBuilder = new StringBuilder(11);
        if (lebensformen.isThermophile()) {
            stringBuilder.append("Thermophile, ");
        }
        if (lebensformen.isPsychrophile()) {
            stringBuilder.append("Psychrophile, ");
        }
        if (lebensformen.isHalophile()) {
            stringBuilder.append("Halophile, ");
        }
        if (lebensformen.isAlkaliphile()) {
            stringBuilder.append("Alkaliphile, ");
        }
        if (lebensformen.isAcidophile()) {
            stringBuilder.append("Acidophile, ");
        }
        if (lebensformen.isBarophile()) {
            stringBuilder.append("Barophile, ");
        }
        if (lebensformen.isEndolithe()) {
            stringBuilder.append("Endolithe, ");
        }
        if (lebensformen.isOligotrophe()) {
            stringBuilder.append("Oligotrophe, ");
        }
        if (lebensformen.isToxitolerante()) {
            stringBuilder.append("Toxitolerante, ");
        }
        if (lebensformen.isXerotolerante()) {
            stringBuilder.append("Xerotolerante, ");
        }
        if (lebensformen.isRadiophile()) {
            stringBuilder.append("Radiophile");
        }
        return stringBuilder.toString();
    }
}

