/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.leben.berechnungen.formeln;

import de.planetensuche.leben.berechnungen.formeln.AtmosphaerenFabrik;
import de.planetensuche.leben.berechnungen.formeln.ElementeFabrik;
import de.planetensuche.leben.berechnungen.formeln.HimmelskoerperFabrik;
import de.planetensuche.leben.berechnungen.formeln.PlanetensystemFabrik;
import de.planetensuche.leben.berechnungen.formeln.SternumgebungFabrik;
import de.planetensuche.leben.berechnungen.formeln.api.IFormel;
import de.planetensuche.leben.datenmodel.Lebensraum;
import java.util.ArrayList;
import java.util.List;

public final class PunkteBerechner {
    private final List<IFormel> alleFormeln = new ArrayList<IFormel>(5);

    public PunkteBerechner() {
        this.alleFormeln.addAll(AtmosphaerenFabrik.getFormeln());
        this.alleFormeln.addAll(ElementeFabrik.getFormeln());
        this.alleFormeln.addAll(HimmelskoerperFabrik.getFormeln());
        this.alleFormeln.addAll(PlanetensystemFabrik.getFormeln());
        this.alleFormeln.addAll(SternumgebungFabrik.getFormeln());
    }

    public int berechnePunkteFuerAlleKriterien(Lebensraum lebensraum) {
        int n = 0;
        for (IFormel iFormel : this.alleFormeln) {
            n += iFormel.getPunkte(lebensraum);
        }
        return n;
    }
}

