/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.leben.neu.extremophile;

import de.planetensuche.leben.datenmodel.Lebensraum;
import de.planetensuche.leben.neu.api.ILebensformenRepository;
import de.planetensuche.leben.neu.api.Lebensform;
import de.planetensuche.leben.neu.api.Wahrscheinlichkeitsergebnis;
import de.planetensuche.leben.neu.kriterien.AllgemeineKriterienPruefer;
import de.planetensuche.leben.neu.kriterien.Kriterien;
import de.planetensuche.leben.util.BewertungssystemRechner;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractExtremophile
implements Lebensform {
    int anzahlSpezielleBedingungenErfuellt;
    int anzahlSpezielleBedingungenNichtErfuellt;
    Map<Kriterien, Boolean> protokoll = new HashMap<Kriterien, Boolean>();
    private Wahrscheinlichkeitsergebnis ergebnis;

    void init(ILebensformenRepository iLebensformenRepository) {
        iLebensformenRepository.registriere(this);
    }

    @Override
    public Wahrscheinlichkeitsergebnis bewerteLebensraum(Lebensraum lebensraum) {
        this.ergebnis = new Wahrscheinlichkeitsergebnis();
        this.ergebnis.setLebensform(this);
        this.ergebnis.setLebensraum(lebensraum);
        AllgemeineKriterienPruefer allgemeineKriterienPruefer = new AllgemeineKriterienPruefer();
        BewertungssystemRechner bewertungssystemRechner = new BewertungssystemRechner();
        int n = 0;
        double d = 0.0;
        boolean bl = allgemeineKriterienPruefer.sindAlleAllgemeinenKriterienErfuellt(lebensraum);
        this.protokoll = allgemeineKriterienPruefer.getProtokoll();
        if (bl) {
            int n2 = allgemeineKriterienPruefer.getAnzahlKriterien();
            bl = this.sindSpezielleBedingungenErfuellt(lebensraum);
            if (bl) {
                d = bewertungssystemRechner.berechneWahrscheinlichkeit(n2 += this.anzahlSpezielleBedingungenErfuellt, n += this.anzahlSpezielleBedingungenNichtErfuellt);
            }
        }
        this.ergebnis.setIstLebenMoeglich(bl);
        this.ergebnis.setWahrscheinlichkeit(d);
        this.ergebnis.setProtokoll(this.protokoll);
        return this.ergebnis;
    }

    int getAnzahlNichtErfuellterKriterien(boolean ... blArray) {
        int n = 0;
        for (boolean bl : blArray) {
            if (bl) continue;
            ++n;
        }
        return n;
    }

    public Wahrscheinlichkeitsergebnis getErgebnis() {
        return this.ergebnis;
    }

    public abstract boolean sindSpezielleBedingungenErfuellt(Lebensraum var1);
}

