/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.leben.neu.extremophile;

import com.google.inject.Inject;
import de.planetensuche.leben.datenmodel.Lebensraum;
import de.planetensuche.leben.neu.api.ILebensformenRepository;
import de.planetensuche.leben.neu.extremophile.AbstractExtremophile;
import de.planetensuche.leben.neu.kriterien.Kriterien;

public final class Acidophilie
extends AbstractExtremophile {
    @Inject
    public Acidophilie(ILebensformenRepository iLebensformenRepository) {
        this.init(iLebensformenRepository);
    }

    @Override
    public boolean sindSpezielleBedingungenErfuellt(Lebensraum lebensraum) {
        this.protokoll.put(Kriterien.VULKANISMUS, lebensraum.isVulkanismusVorhanden());
        this.protokoll.put(Kriterien.ATMOSPHAERE, lebensraum.isAtmosphaereVorhanden());
        this.protokoll.put(Kriterien.SCHWEFEL, lebensraum.isSchwefelVorhanden());
        this.protokoll.put(Kriterien.WASSERDAMPF, lebensraum.isWasserdampfVorhanden());
        this.anzahlSpezielleBedingungenNichtErfuellt = this.getAnzahlNichtErfuellterKriterien(lebensraum.isVulkanismusVorhanden(), lebensraum.isAtmosphaereVorhanden(), lebensraum.isSchwefelVorhanden(), lebensraum.isWasserdampfVorhanden());
        if (this.anzahlSpezielleBedingungenNichtErfuellt == 0) {
            this.anzahlSpezielleBedingungenErfuellt += 4;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Acidophilie";
    }
}

