/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.leben.neu.extremophile;

import com.google.inject.Inject;
import de.planetensuche.leben.datenmodel.Lebensraum;
import de.planetensuche.leben.neu.api.ILebensformenRepository;
import de.planetensuche.leben.neu.extremophile.AbstractExtremophile;
import de.planetensuche.leben.neu.kriterien.Kriterien;

public final class Endolithe
extends AbstractExtremophile {
    @Inject
    public Endolithe(ILebensformenRepository iLebensformenRepository) {
        this.init(iLebensformenRepository);
    }

    @Override
    public boolean sindSpezielleBedingungenErfuellt(Lebensraum lebensraum) {
        this.protokoll.put(Kriterien.SCHWEFEL, lebensraum.isSchwefelVorhanden());
        this.protokoll.put(Kriterien.EISEN, lebensraum.isEisenVorhanden());
        this.protokoll.put(Kriterien.KOHLENSTOFFDIOXID, lebensraum.isKohlenstoffdioxidVorhanden());
        this.protokoll.put(Kriterien.WASSERDAMPF, lebensraum.isWasserdampfVorhanden());
        this.protokoll.put(Kriterien.OZEAN, lebensraum.isOzeanVorhanden());
        this.protokoll.put(Kriterien.TEMPERATUR, lebensraum.getOberflaechentemperaturMax() < 113.0);
        this.anzahlSpezielleBedingungenNichtErfuellt = this.getAnzahlNichtErfuellterKriterien(lebensraum.isSchwefelVorhanden(), lebensraum.isEisenVorhanden(), lebensraum.isKohlenstoffdioxidVorhanden(), lebensraum.isWasserdampfVorhanden() || lebensraum.isOzeanVorhanden(), lebensraum.getOberflaechentemperaturMax() < 113.0);
        if (this.anzahlSpezielleBedingungenNichtErfuellt == 0) {
            this.anzahlSpezielleBedingungenErfuellt += 5;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Endolithe";
    }
}

