/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.leben.neu.extremophile;

import com.google.inject.Inject;
import de.planetensuche.leben.datenmodel.Lebensraum;
import de.planetensuche.leben.neu.api.ILebensformenRepository;
import de.planetensuche.leben.neu.extremophile.AbstractExtremophile;
import de.planetensuche.leben.neu.kriterien.Kriterien;

public final class Oligotrophe
extends AbstractExtremophile {
    @Inject
    public Oligotrophe(ILebensformenRepository iLebensformenRepository) {
        this.init(iLebensformenRepository);
    }

    @Override
    public boolean sindSpezielleBedingungenErfuellt(Lebensraum lebensraum) {
        this.protokoll.put(Kriterien.OZEAN, lebensraum.isOzeanVorhanden());
        this.protokoll.put(Kriterien.WASSERDAMPF, lebensraum.isWasserdampfVorhanden());
        this.protokoll.put(Kriterien.TEMPERATUR, lebensraum.getOberflaechentemperaturMax() > 0.0);
        this.anzahlSpezielleBedingungenNichtErfuellt = this.getAnzahlNichtErfuellterKriterien(lebensraum.isOzeanVorhanden() || lebensraum.isWasserdampfVorhanden(), lebensraum.getOberflaechentemperaturMax() > 0.0);
        if (this.anzahlSpezielleBedingungenNichtErfuellt == 0) {
            this.anzahlSpezielleBedingungenErfuellt = 2;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Oligotrophe";
    }
}

