/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.leben.neu.extremophile;

import com.google.inject.Inject;
import de.planetensuche.leben.datenmodel.Lebensraum;
import de.planetensuche.leben.neu.api.ILebensformenRepository;
import de.planetensuche.leben.neu.extremophile.AbstractExtremophile;
import de.planetensuche.leben.neu.kriterien.Kriterien;

public final class Thermophile
extends AbstractExtremophile {
    @Inject
    public Thermophile(ILebensformenRepository iLebensformenRepository) {
        this.init(iLebensformenRepository);
    }

    @Override
    public boolean sindSpezielleBedingungenErfuellt(Lebensraum lebensraum) {
        if (this.istHeisserWasserplanet(lebensraum)) {
            this.anzahlSpezielleBedingungenErfuellt += 4;
            return true;
        }
        if (this.sindGeysireMoeglich(lebensraum)) {
            this.anzahlSpezielleBedingungenErfuellt += 5;
            return true;
        }
        if (this.sindSchwarzeRaucherMoeglich(lebensraum)) {
            this.anzahlSpezielleBedingungenErfuellt += 3;
            return true;
        }
        this.anzahlSpezielleBedingungenNichtErfuellt += 3;
        return false;
    }

    private boolean istHeisserWasserplanet(Lebensraum lebensraum) {
        this.protokoll.put(Kriterien.TEMPERATUR, lebensraum.getOberflaechentemperaturMax() < 150.0 && lebensraum.getOberflaechentemperaturMin() >= 45.0);
        this.protokoll.put(Kriterien.WASSERDAMPF, lebensraum.isWasserdampfVorhanden());
        this.protokoll.put(Kriterien.SCHWEFEL, lebensraum.isSchwefelVorhanden());
        return lebensraum.isAtmosphaereVorhanden() && lebensraum.isWasserdampfVorhanden() && lebensraum.getOberflaechentemperaturMin() >= 45.0 && lebensraum.getOberflaechentemperaturMax() < 150.0 && lebensraum.isSchwefelVorhanden();
    }

    private boolean sindSchwarzeRaucherMoeglich(Lebensraum lebensraum) {
        this.protokoll.put(Kriterien.VULKANISMUS, lebensraum.isVulkanismusVorhanden());
        this.protokoll.put(Kriterien.OZEAN, lebensraum.isOzeanVorhanden());
        this.protokoll.put(Kriterien.SCHWEFEL, lebensraum.isSchwefelVorhanden());
        return lebensraum.isVulkanismusVorhanden() && lebensraum.isOzeanVorhanden() && lebensraum.isSchwefelVorhanden();
    }

    private boolean sindGeysireMoeglich(Lebensraum lebensraum) {
        this.protokoll.put(Kriterien.VULKANISMUS, lebensraum.isVulkanismusVorhanden());
        this.protokoll.put(Kriterien.ATMOSPHAERE, lebensraum.isAtmosphaereVorhanden());
        this.protokoll.put(Kriterien.WASSERDAMPF, lebensraum.isWasserdampfVorhanden());
        this.protokoll.put(Kriterien.SCHWEFEL, lebensraum.isSchwefelVorhanden());
        return lebensraum.isVulkanismusVorhanden() && lebensraum.isAtmosphaereVorhanden() && lebensraum.isWasserdampfVorhanden() && lebensraum.isSchwefelVorhanden();
    }

    @Override
    public String getName() {
        return "Thermophile";
    }
}

