/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.leben.neu.extremophile;

import com.google.inject.Inject;
import de.planetensuche.leben.datenmodel.Lebensraum;
import de.planetensuche.leben.neu.api.ILebensformenRepository;
import de.planetensuche.leben.neu.extremophile.AbstractExtremophile;
import de.planetensuche.leben.neu.kriterien.Kriterien;

public final class Xerophilie
extends AbstractExtremophile {
    @Inject
    public Xerophilie(ILebensformenRepository iLebensformenRepository) {
        this.init(iLebensformenRepository);
    }

    @Override
    public boolean sindSpezielleBedingungenErfuellt(Lebensraum lebensraum) {
        this.protokoll.put(Kriterien.ATMOSPHAERE, lebensraum.isAtmosphaereVorhanden());
        this.protokoll.put(Kriterien.WASSERDAMPF, lebensraum.isWasserdampfVorhanden());
        this.protokoll.put(Kriterien.TEMPERATUR, lebensraum.getOberflaechentemperaturMax() > 0.0);
        this.anzahlSpezielleBedingungenNichtErfuellt = this.getAnzahlNichtErfuellterKriterien(lebensraum.isAtmosphaereVorhanden(), lebensraum.isWasserdampfVorhanden(), lebensraum.getOberflaechentemperaturMax() > 0.0);
        if (this.anzahlSpezielleBedingungenNichtErfuellt == 0) {
            this.anzahlSpezielleBedingungenErfuellt += 3;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Xerophilie";
    }
}

