/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.leben.neu.kriterien;

import de.planetensuche.leben.datenmodel.Lebensraum;
import de.planetensuche.leben.datenmodel.ObjektKategorie;
import de.planetensuche.leben.neu.kriterien.Kriterien;
import java.util.HashMap;
import java.util.Map;

public final class AllgemeineKriterienPruefer {
    private final int anzahlKriterien = 11;
    private int anzahlErfuellterKriterien;
    private Map<Kriterien, Boolean> protokoll;

    public boolean sindAlleAllgemeinenKriterienErfuellt(Lebensraum lebensraum) {
        this.protokoll = new HashMap<Kriterien, Boolean>();
        this.protokoll.put(Kriterien.NAHE_GALAXIENZENTRUM, Boolean.FALSE);
        this.protokoll.put(Kriterien.NAHE_STERNENTSTEHUNGSGEBIET, Boolean.FALSE);
        this.protokoll.put(Kriterien.OBJEKT_IN_ENTSTEHUNG, Boolean.FALSE);
        this.protokoll.put(Kriterien.OBJEKT_HAT_EINEN_GASPLANET, Boolean.FALSE);
        this.protokoll.put(Kriterien.OBJEKT_HAT_EINEN_MOND, Boolean.FALSE);
        this.protokoll.put(Kriterien.WASSERDAMPF, Boolean.FALSE);
        this.protokoll.put(Kriterien.OZEAN, Boolean.FALSE);
        this.protokoll.put(Kriterien.KOHLENSTOFFDIOXID, Boolean.FALSE);
        this.protokoll.put(Kriterien.WASSERSTOFF, Boolean.FALSE);
        this.protokoll.put(Kriterien.STICKSTOFF, Boolean.FALSE);
        this.protokoll.put(Kriterien.SCHWEFEL, Boolean.FALSE);
        this.protokoll.put(Kriterien.PHOSPHOR, Boolean.FALSE);
        if (!lebensraum.isNaheDemGalaxienzentrum()) {
            this.protokolliereKriteriumErfuellt(Kriterien.NAHE_GALAXIENZENTRUM);
        }
        if (!lebensraum.isNaheEinesSternentstehungsgebiets()) {
            this.protokolliereKriteriumErfuellt(Kriterien.NAHE_STERNENTSTEHUNGSGEBIET);
        }
        if (!lebensraum.isObjektNochInDerEntstehungsphase()) {
            this.protokolliereKriteriumErfuellt(Kriterien.OBJEKT_IN_ENTSTEHUNG);
        }
        if (lebensraum.isObjektHatEinenGasplanet()) {
            this.protokolliereKriteriumErfuellt(Kriterien.OBJEKT_HAT_EINEN_GASPLANET);
        }
        if (lebensraum.getKategorie().equals((Object)ObjektKategorie.PLANET) && lebensraum.isObjektHatEinenMond() || lebensraum.getKategorie().equals((Object)ObjektKategorie.MOND)) {
            this.protokolliereKriteriumErfuellt(Kriterien.OBJEKT_HAT_EINEN_MOND);
        }
        if (lebensraum.isWasserdampfVorhanden() || lebensraum.isOzeanVorhanden()) {
            ++this.anzahlErfuellterKriterien;
            this.protokoll.put(Kriterien.OZEAN, lebensraum.isOzeanVorhanden());
            this.protokoll.put(Kriterien.WASSERDAMPF, lebensraum.isWasserdampfVorhanden());
        }
        if (lebensraum.isWasserstoffVorhanden()) {
            this.protokolliereKriteriumErfuellt(Kriterien.WASSERSTOFF);
        }
        if (lebensraum.isKohlenstoffdioxidVorhanden()) {
            this.protokolliereKriteriumErfuellt(Kriterien.KOHLENSTOFFDIOXID);
        }
        if (lebensraum.isStickstoffVorhanden()) {
            this.protokolliereKriteriumErfuellt(Kriterien.STICKSTOFF);
        }
        if (lebensraum.isSchwefelVorhanden()) {
            this.protokolliereKriteriumErfuellt(Kriterien.SCHWEFEL);
        }
        if (lebensraum.isPhosphorVorhanden()) {
            this.protokolliereKriteriumErfuellt(Kriterien.PHOSPHOR);
        }
        return this.anzahlErfuellterKriterien == 11;
    }

    public Map<Kriterien, Boolean> getProtokoll() {
        return this.protokoll;
    }

    public int getAnzahlKriterien() {
        return 11;
    }

    private void protokolliereKriteriumErfuellt(Kriterien kriterien) {
        ++this.anzahlErfuellterKriterien;
        this.protokoll.put(kriterien, Boolean.TRUE);
    }
}

