/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.neuronalnet.api;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.impl.SternbildFinder;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.cache.ISternbildSpracheCache;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.guidesigner.components.jtable.JTableExtended;
import de.planetensuche.guidesigner.icons.IconPoolDefault;
import de.planetensuche.guidesigner.statusfenster.AsyncLoadingScreenCallbackExecutor;
import de.planetensuche.neuronalnet.api.ExoplanetPredictionDialog;
import de.planetensuche.neuronalnet.api.IExoplanetPredictionDbService;
import de.planetensuche.neuronalnet.api.NeuronalNetworkViewer;
import de.planetensuche.neuronalnet.api.StarDetailDialog;
import de.planetensuche.neuronalnet.core.DataAccessException;
import de.planetensuche.neuronalnet.core.ExoplanetPredictionI18nService;
import de.planetensuche.neuronalnet.core.ROLFNeuronalNetwork;
import de.planetensuche.neuronalnet.core.TrainingSetDbService;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.jfree.chart.ChartPanel;

public final class ExoplanetPredictionController {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(ExoplanetPredictionController.class);
    private static final int ICON_COLUMN_INDEX = 5;
    private final ISprachcontainer sprachcontainer = SprachcontainerFabrik.getSprachcontainer();
    private final IExoplanetPredictionDbService exoplanetPredictionDbService;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;
    private ExoplanetPredictionDialog dialog;
    private ROLFNeuronalNetwork knnMasseMetal;
    private ROLFNeuronalNetwork knnAbsMagTemperatur;
    private final StarDetailDialog starDetailDialog;
    private final ExoplanetPredictionI18nService i18nService;
    private final IDatenbankverbinder dbVerbinder;
    private final IIdCacheDAO idCacheDao;

    public ExoplanetPredictionController(IExoplanetPredictionDbService iExoplanetPredictionDbService, IPlanetensucheObjektRepository iPlanetensucheObjektRepository, SternbildFinder sternbildFinder, ISternbildSpracheCache iSternbildSpracheCache, ISternbilderRepository iSternbilderRepository, StarDetailDialog starDetailDialog, IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO) {
        this.i18nService = new ExoplanetPredictionI18nService(sternbildFinder, iSternbildSpracheCache, iSternbilderRepository);
        this.exoplanetPredictionDbService = iExoplanetPredictionDbService;
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
        this.starDetailDialog = starDetailDialog;
        this.dbVerbinder = iDatenbankverbinder;
        this.idCacheDao = iIdCacheDAO;
    }

    public void hideDialog() {
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    public void showDialog() {
        if (this.dialog != null) {
            this.dialog.setVisible(true);
            return;
        }
        this.dialog = new ExoplanetPredictionDialog();
        this.dialog.setVisible(true);
        this.dialog.init(new ArrayList<List<Object>>());
        this.dialog.getjMenuShowKnnMagTeff().addActionListener(actionEvent -> {
            NeuronalNetworkViewer neuronalNetworkViewer = new NeuronalNetworkViewer();
            ChartPanel chartPanel = neuronalNetworkViewer.createChart(this.knnAbsMagTemperatur, this.dialog.getSprachcontainer().getString("db_m53"), this.dialog.getSprachcontainer().getString("db_m55"));
            JFrame jFrame = new JFrame(this.sprachcontainer.getString("knn_menu_knn1"));
            jFrame.add(chartPanel);
            jFrame.pack();
            jFrame.setDefaultCloseOperation(2);
            jFrame.setVisible(true);
        });
        this.dialog.getjMenuShowKnnMassMetal().addActionListener(actionEvent -> {
            NeuronalNetworkViewer neuronalNetworkViewer = new NeuronalNetworkViewer();
            ChartPanel chartPanel = neuronalNetworkViewer.createChart(this.knnMasseMetal, this.dialog.getSprachcontainer().getString("db_m120"), this.dialog.getSprachcontainer().getString("db_m101"));
            JFrame jFrame = new JFrame(this.sprachcontainer.getString("knn_menu_knn2"));
            jFrame.add(chartPanel);
            jFrame.pack();
            jFrame.setDefaultCloseOperation(2);
            jFrame.setVisible(true);
        });
        this.dialog.getjMenuInfo().addActionListener(actionEvent -> {
            String string = this.sprachcontainer.getHtmlString("knn_description");
            JLabel jLabel = new JLabel(string);
            JFrame jFrame = new JFrame(this.sprachcontainer.getString("knn_description_titel"));
            jFrame.add(jLabel);
            jFrame.pack();
            jFrame.setExtendedState(6);
            jFrame.setDefaultCloseOperation(2);
            jFrame.setVisible(true);
        });
        this.dialog.getjMenuItem1().addActionListener(actionEvent -> this.loadDataAsync(500));
        this.dialog.getjMenuItem2().addActionListener(actionEvent -> this.loadDataAsync(1000));
        this.dialog.getjMenuItem3().addActionListener(actionEvent -> this.loadDataAsync(2000));
        this.dialog.getjMenuItem4().addActionListener(actionEvent -> this.loadDataAsync(5000));
        this.loadDataAsync(500);
    }

    private void loadDataAsync(int n) {
        AsyncLoadingScreenCallbackExecutor asyncLoadingScreenCallbackExecutor = new AsyncLoadingScreenCallbackExecutor();
        asyncLoadingScreenCallbackExecutor.execute(this.dialog, () -> {
            try {
                long l = System.currentTimeMillis();
                this.createAndTraineeAINetworks();
                LOGGER.debug("neuronales netzwerk trainiert nach " + (System.currentTimeMillis() - l) + " ms");
                ArrayList<List<Object>> arrayList = new ArrayList<List<Object>>();
                this.addStarsWithPlanets(arrayList);
                LOGGER.debug("sterne mit planeten gefunden nach " + (System.currentTimeMillis() - l) + " ms");
                this.addStarsWithoutPlanets(arrayList, n);
                LOGGER.debug("sterne ohne planeten gefunden nach " + (System.currentTimeMillis() - l) + " ms");
                if (LOGGER.isDebugEnabled()) {
                    long l2 = System.currentTimeMillis() - l;
                    LOGGER.debug("laden von " + arrayList.size() + " Prognosen dauerte " + l2 + " ms");
                }
                SwingUtilities.invokeLater(() -> {
                    this.dialog.init(arrayList);
                    final JTableExtended jTableExtended = this.dialog.getTable();
                    jTableExtended.setCellSelectionEnabled(false);
                    jTableExtended.setColumnSelectionAllowed(false);
                    jTableExtended.setRowSelectionAllowed(true);
                    jTableExtended.setSelectionMode(0);
                    jTableExtended.addMouseListener(new MouseListener(){

                        @Override
                        public void mouseClicked(MouseEvent mouseEvent) {
                            if (jTableExtended.getSelectedColumn() == 5) {
                                int n = jTableExtended.getSelectedRow();
                                String string = (String)jTableExtended.getModel().getValueAt(n, 0);
                                ExoplanetPredictionController.this.starDetailDialog.showDetails(string);
                            }
                        }

                        @Override
                        public void mousePressed(MouseEvent mouseEvent) {
                        }

                        @Override
                        public void mouseReleased(MouseEvent mouseEvent) {
                        }

                        @Override
                        public void mouseEntered(MouseEvent mouseEvent) {
                        }

                        @Override
                        public void mouseExited(MouseEvent mouseEvent) {
                        }
                    });
                });
            }
            catch (DataAccessException | RuntimeException | SQLException exception) {
                LOGGER.error("showDialog()", exception);
            }
        });
    }

    private void addStarsWithoutPlanets(List<List<Object>> list, int n) {
        List<IPlanetensucheObjekt> list2 = this.exoplanetPredictionDbService.listStarsWithoutPlanets(n);
        if (list2 == null) {
            LOGGER.debug("no stars without planets found");
            return;
        }
        LOGGER.debug(list2.size() + " stars without planets found");
        ImageIcon imageIcon = IconPoolDefault.INFO.getImageIcon();
        for (IPlanetensucheObjekt iPlanetensucheObjekt : list2) {
            ArrayList<Object> arrayList;
            Boolean bl = this.isRocketPlanet(iPlanetensucheObjekt);
            String string = iPlanetensucheObjekt.getObjektNamen().get(0);
            if (bl != null && bl.booleanValue()) {
                arrayList = new ArrayList<Object>();
                arrayList.add(string);
                arrayList.add(this.i18nService.formatDistance(iPlanetensucheObjekt.getEntfernung()));
                arrayList.add(this.i18nService.getSternbildName(iPlanetensucheObjekt));
                arrayList.add(this.dialog.getSprachcontainer().getString("knn_prediction_rocky"));
                arrayList.add(this.dialog.getSprachcontainer().getString("knn_current_nothing"));
                arrayList.add(imageIcon);
                list.add(arrayList);
                continue;
            }
            if (bl == null || bl.booleanValue()) continue;
            arrayList = new ArrayList();
            arrayList.add(string);
            arrayList.add(this.i18nService.formatDistance(iPlanetensucheObjekt.getEntfernung()));
            arrayList.add(this.i18nService.getSternbildName(iPlanetensucheObjekt));
            arrayList.add(this.dialog.getSprachcontainer().getString("knn_prediction_gas"));
            arrayList.add(this.dialog.getSprachcontainer().getString("knn_current_nothing"));
            arrayList.add(imageIcon);
            list.add(arrayList);
        }
    }

    private void addStarsWithPlanets(List<List<Object>> list) throws SQLException {
        int n = LocalDate.now().getYear();
        List<IPlanetensucheObjekt> list2 = this.exoplanetPredictionDbService.listStarsWithPlanets(n);
        if (list2 == null) {
            LOGGER.debug("no stars with planets found in discovery year " + n);
            return;
        }
        LOGGER.debug(list2.size() + " stars with planets found in discovery year " + n);
        ImageIcon imageIcon = IconPoolDefault.INFO.getImageIcon();
        for (IPlanetensucheObjekt iPlanetensucheObjekt : list2) {
            ArrayList<Object> arrayList;
            StringBuilder stringBuilder = new StringBuilder();
            Set<Integer> set = iPlanetensucheObjekt.getWirdUmkreistVonIDs();
            for (Integer n2 : set) {
                arrayList = this.planetensucheObjektRepository.read(n2);
                if (stringBuilder.length() > 0) {
                    stringBuilder.append(", ");
                }
                String string = arrayList.getObjektNamen().get(0);
                String string2 = this.dialog.getSprachcontainer().toLocalisedDate(arrayList.getEntdeckungsdatum());
                String string3 = this.i18nService.getPlanetSize((IPlanetensucheObjekt)((Object)arrayList));
                stringBuilder.append(string).append(" (").append(string3).append(string2).append(")");
            }
            Boolean bl = this.isRocketPlanet(iPlanetensucheObjekt);
            String object2 = iPlanetensucheObjekt.getObjektNamen().get(0);
            if (bl != null && bl.booleanValue()) {
                arrayList = new ArrayList<Object>();
                arrayList.add(object2);
                arrayList.add(this.i18nService.formatDistance(iPlanetensucheObjekt.getEntfernung()));
                arrayList.add(this.i18nService.getSternbildName(iPlanetensucheObjekt));
                arrayList.add(this.dialog.getSprachcontainer().getString("knn_prediction_rocky"));
                arrayList.add(stringBuilder.toString());
                arrayList.add(imageIcon);
                list.add(arrayList);
                continue;
            }
            if (bl != null && !bl.booleanValue()) {
                arrayList = new ArrayList();
                arrayList.add(object2);
                arrayList.add(this.i18nService.formatDistance(iPlanetensucheObjekt.getEntfernung()));
                arrayList.add(this.i18nService.getSternbildName(iPlanetensucheObjekt));
                arrayList.add(this.dialog.getSprachcontainer().getString("knn_prediction_gas"));
                arrayList.add(stringBuilder.toString());
                arrayList.add(imageIcon);
                list.add(arrayList);
                continue;
            }
            arrayList = new ArrayList();
            arrayList.add(object2);
            arrayList.add(this.i18nService.formatDistance(iPlanetensucheObjekt.getEntfernung()));
            arrayList.add(this.i18nService.getSternbildName(iPlanetensucheObjekt));
            arrayList.add(this.dialog.getSprachcontainer().getString("knn_prediction_no_planets"));
            arrayList.add(stringBuilder.toString());
            arrayList.add(imageIcon);
            list.add(arrayList);
        }
    }

    private void createAndTraineeAINetworks() throws DataAccessException {
        this.knnMasseMetal = new ROLFNeuronalNetwork(this.dialog.getSprachcontainer().getString("knn_chart_mass_metal"), 0.0036);
        this.knnAbsMagTemperatur = new ROLFNeuronalNetwork(this.dialog.getSprachcontainer().getString("knn_chart_teff_absMag"), 175.4);
        TrainingSetDbService trainingSetDbService = new TrainingSetDbService(this.dbVerbinder, this.idCacheDao);
        trainingSetDbService.learnStarMassMetalEarthlike(this.knnMasseMetal);
        trainingSetDbService.learnAbsMagTEff(this.knnAbsMagTemperatur);
    }

    private Boolean isRocketPlanet(IPlanetensucheObjekt iPlanetensucheObjekt) {
        double d;
        double d2;
        double d3 = iPlanetensucheObjekt.getEntfernung() / 3.262;
        double d4 = iPlanetensucheObjekt.getScheinbareHelligkeit();
        double d5 = iPlanetensucheObjekt.getTemperatur();
        if (this.knnAbsMagTemperatur.inCluster(d5, d2 = (d = -1.0 * (5.0 * Math.log10(d3) - 5.0 - d4)) * 1000.0)) {
            double d6 = iPlanetensucheObjekt.getMetallizitaet();
            double d7 = iPlanetensucheObjekt.getMasse();
            return this.knnMasseMetal.inCluster(d6, d7);
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Stern " + iPlanetensucheObjekt.getObjektNamen().get(0) + " kann keinen Exoplaneten haben? (" + iPlanetensucheObjekt.getTemperatur() + " kelvin, " + iPlanetensucheObjekt.getMetallizitaet() + " f/e, " + iPlanetensucheObjekt.getMasse() + " Msun, " + d + " absMag (" + d3 + " pc))");
        }
        return null;
    }
}

