/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.neuronalnet.api;

import com.google.inject.Injector;
import de.planetensuche.datamodel.impl.SternbildFinder;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.cache.ISternbildSpracheCache;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.neuronalnet.api.ExoplanetPredictionController;
import de.planetensuche.neuronalnet.api.IExoplanetPredictionDbService;
import de.planetensuche.neuronalnet.api.NeuronalNetworkModules;
import de.planetensuche.neuronalnet.api.StarDetailDialog;

public final class ExoplanetPredictionControllerFactory {
    public ExoplanetPredictionController create(Injector injector, SternbildFinder sternbildFinder, StarDetailDialog starDetailDialog) {
        Injector injector2 = injector.createChildInjector(new NeuronalNetworkModules());
        IExoplanetPredictionDbService iExoplanetPredictionDbService = injector2.getInstance(IExoplanetPredictionDbService.class);
        IPlanetensucheObjektRepository iPlanetensucheObjektRepository = injector.getInstance(IPlanetensucheObjektRepository.class);
        ISternbildSpracheCache iSternbildSpracheCache = injector.getInstance(ISternbildSpracheCache.class);
        ISternbilderRepository iSternbilderRepository = injector.getInstance(ISternbilderRepository.class);
        IDatenbankverbinder iDatenbankverbinder = injector.getInstance(IDatenbankverbinder.class);
        IIdCacheDAO iIdCacheDAO = injector.getInstance(IIdCacheDAO.class);
        return new ExoplanetPredictionController(iExoplanetPredictionDbService, iPlanetensucheObjektRepository, sternbildFinder, iSternbildSpracheCache, iSternbilderRepository, starDetailDialog, iDatenbankverbinder, iIdCacheDAO);
    }
}

