/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.neuronalnet.core;

import com.google.inject.Inject;
import com.querydsl.core.types.Expression;
import com.querydsl.core.types.OrderSpecifier;
import com.querydsl.core.types.SubQueryExpression;
import com.querydsl.sql.SQLExpressions;
import com.querydsl.sql.SQLQuery;
import de.planetensuche.core.Check;
import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datenbankkern.api.IDatenbankverbinder;
import de.planetensuche.datenbankkern.api.cache.IIdCacheDAO;
import de.planetensuche.datenbankkern.api.repos.IPlanetensucheObjektRepository;
import de.planetensuche.datenbankkern.querydsl5.QDaten;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.neuronalnet.api.IExoplanetPredictionDbService;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public final class ExoplanetPredictionDbService
implements IExoplanetPredictionDbService {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(ExoplanetPredictionDbService.class);
    private final IDatenbankverbinder datenbankverbinder;
    private final QDaten qDaten = QDaten.daten;
    private final IIdCacheDAO idCacheDao;
    private final IPlanetensucheObjektRepository planetensucheObjektRepository;

    @Inject
    public ExoplanetPredictionDbService(IDatenbankverbinder iDatenbankverbinder, IIdCacheDAO iIdCacheDAO, IPlanetensucheObjektRepository iPlanetensucheObjektRepository) {
        this.datenbankverbinder = iDatenbankverbinder;
        this.idCacheDao = iIdCacheDAO;
        this.planetensucheObjektRepository = iPlanetensucheObjektRepository;
    }

    @Override
    public List<IPlanetensucheObjekt> listStarsWithoutPlanets(int n) {
        try {
            long l = System.currentTimeMillis();
            List<Integer> list = ((SQLQuery)((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).where(this.qDaten.metallizitaet.gt(-100.0).and(this.qDaten.id.notIn((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(this.qDaten.zugehoerigkeit).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungbestaetigt.isTrue())))).and(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsSterne())).and(this.qDaten.masse.gt(0.0)).and(this.qDaten.sh.gt(-100.0)).and(this.qDaten.entfernung.gt(0.0)).and(this.qDaten.ra.gt(0.0)).and(this.qDaten.decl.gt(-100.0)).and(this.qDaten.temperatur.gt(0.0)))).orderBy((OrderSpecifier<?>)this.qDaten.entfernung.asc())).limit(n)).fetch();
            LOGGER.debug("query " + (System.currentTimeMillis() - l) + " ms");
            l = System.currentTimeMillis();
            ArrayList<IPlanetensucheObjekt> arrayList = new ArrayList<IPlanetensucheObjekt>();
            if (Check.isFilled(list)) {
                arrayList.addAll(this.planetensucheObjektRepository.read(list));
            }
            LOGGER.debug("nachladen " + (System.currentTimeMillis() - l) + " ms");
            return arrayList;
        }
        catch (SQLException sQLException) {
            LOGGER.error("listStarsWithoutPlanets()", sQLException);
            return null;
        }
    }

    @Override
    public List<IPlanetensucheObjekt> listStarsWithPlanets(int n) {
        try {
            List<Integer> list = ((SQLQuery)((SQLQuery)((SQLQuery)this.datenbankverbinder.getQueryFactory().select((Expression)this.qDaten.id).from((Expression<?>)this.qDaten)).where(this.qDaten.id.in((SubQueryExpression)((SQLQuery)SQLExpressions.selectDistinct(this.qDaten.zugehoerigkeit).from((Expression<?>)this.qDaten)).where(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsPlaneten()).and(this.qDaten.entdeckungsdatum.endsWith("" + n)).and(this.qDaten.entdeckungbestaetigt.isTrue()))).and(this.qDaten.metallizitaet.gt(-100.0)).and(this.qDaten.objektid.in((Collection<Integer>)this.idCacheDao.getObjekttypenidsSterne())).and(this.qDaten.masse.gt(0.0)).and(this.qDaten.entfernung.gt(0.0)).and(this.qDaten.ra.gt(0.0)).and(this.qDaten.decl.gt(-100.0)))).orderBy((OrderSpecifier<?>)this.qDaten.entfernung.asc())).fetch();
            ArrayList<IPlanetensucheObjekt> arrayList = new ArrayList<IPlanetensucheObjekt>();
            if (Check.isFilled(list)) {
                arrayList.addAll(this.planetensucheObjektRepository.read(list));
            }
            return arrayList;
        }
        catch (SQLException sQLException) {
            LOGGER.error("listStarsWithPlanets(" + n + ")", sQLException);
            return null;
        }
    }
}

