/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.neuronalnet.core;

import de.planetensuche.datamodel.api.IPlanetensucheObjekt;
import de.planetensuche.datamodel.api.ISternbild;
import de.planetensuche.datamodel.api.SternbildSprache;
import de.planetensuche.datamodel.impl.SternbildFinder;
import de.planetensuche.datenbankkern.api.cache.ISternbildSpracheCache;
import de.planetensuche.datenbankkern.api.repos.ISternbilderRepository;
import de.planetensuche.errorlogger.api.ILogging;
import de.planetensuche.errorlogger.api.LoggingFactory;
import de.planetensuche.sprachcontainer.api.ISprachcontainer;
import de.planetensuche.sprachcontainer.impl.SprachcontainerFabrik;
import java.sql.SQLException;

public final class ExoplanetPredictionI18nService {
    private static final ILogging LOGGER = LoggingFactory.getLoggerForClass(ExoplanetPredictionI18nService.class);
    private final ISprachcontainer i18n = SprachcontainerFabrik.getSprachcontainer();
    private final SternbildFinder sternbildFinder;
    private final ISternbildSpracheCache stbCache;
    private final ISternbilderRepository stbRepository;

    public ExoplanetPredictionI18nService(SternbildFinder sternbildFinder, ISternbildSpracheCache iSternbildSpracheCache, ISternbilderRepository iSternbilderRepository) {
        this.sternbildFinder = sternbildFinder;
        this.stbCache = iSternbildSpracheCache;
        this.stbRepository = iSternbilderRepository;
    }

    public String getSternbildName(IPlanetensucheObjekt iPlanetensucheObjekt) {
        if (iPlanetensucheObjekt.isSternbildUnbekannt()) {
            String string = this.sternbildFinder.getSternbildCodeFuerKoordinate(iPlanetensucheObjekt.getRA(), iPlanetensucheObjekt.getDECL());
            if (string == null || string.isEmpty() || string.startsWith("unb")) {
                String string2 = iPlanetensucheObjekt.getObjektNamen().get(0);
                LOGGER.warn("Sternbild f\u00fcr Stern '" + string2 + "' nicht ermittelbar: ra " + iPlanetensucheObjekt.getRA() + ", decl " + iPlanetensucheObjekt.getDECL());
                return "";
            }
            try {
                ISternbild iSternbild = this.stbRepository.getSternbild(string);
                return this.getSternbildFuerCode(iSternbild, string);
            }
            catch (SQLException sQLException) {
                LOGGER.error(sQLException);
            }
        } else {
            if (this.stbCache.getSternbildSprache().name().equals(SternbildSprache.DEUTSCH.name())) {
                return iPlanetensucheObjekt.getSternbildDTBezeichnung();
            }
            if (this.stbCache.getSternbildSprache().name().equals(SternbildSprache.ENGLISCH.name())) {
                return iPlanetensucheObjekt.getSternbildENGBezeichnung();
            }
            if (this.stbCache.getSternbildSprache().name().equals(SternbildSprache.LATEINISCH.name())) {
                return iPlanetensucheObjekt.getSternbildLATBezeichnung();
            }
            return iPlanetensucheObjekt.getSternbildCode();
        }
        return "";
    }

    private String getSternbildFuerCode(ISternbild iSternbild, String string) {
        if (iSternbild == null) {
            return string;
        }
        if (this.stbCache.getSternbildSprache().name().equals(SternbildSprache.DEUTSCH.name())) {
            return iSternbild.getSternbildDTBezeichnung();
        }
        if (this.stbCache.getSternbildSprache().name().equals(SternbildSprache.ENGLISCH.name())) {
            return iSternbild.getSternbildENGBezeichnung();
        }
        if (this.stbCache.getSternbildSprache().name().equals(SternbildSprache.LATEINISCH.name())) {
            return iSternbild.getSternbildLATBezeichnung();
        }
        return string;
    }

    public String getPlanetSize(IPlanetensucheObjekt iPlanetensucheObjekt) {
        Object object = "";
        if (!iPlanetensucheObjekt.isMasseUnbekannt()) {
            object = iPlanetensucheObjekt.getMasse() < 0.03 ? this.formatMass(iPlanetensucheObjekt.getMasse() * 318.0) + " " + this.i18n.getString("knn_earth_mass") + ", " : this.formatMass(iPlanetensucheObjekt.getMasse()) + " " + this.i18n.getString("knn_jup_mass") + ", ";
        } else if (!iPlanetensucheObjekt.isDurchmesserUnbekannt()) {
            object = iPlanetensucheObjekt.getDurchmesser() < 0.15 ? this.formatMass(iPlanetensucheObjekt.getDurchmesser() * 12.0) + " " + this.i18n.getString("knn_earth_diameter") + ", " : this.formatMass(iPlanetensucheObjekt.getDurchmesser()) + " " + this.i18n.getString("knn_jup_diameter") + ", ";
        }
        return object;
    }

    public String formatDistance(double d) {
        if (d < 1.0) {
            return "";
        }
        String string = this.i18n.toLocalisedDouble(d);
        return string;
    }

    public String formatMass(double d) {
        if (d <= 0.0) {
            return "";
        }
        String string = this.i18n.toLocalisedDouble(d);
        return string;
    }
}

