/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.neuronalnet.core;

public final class ROLFNeuron {
    private double x;
    private double y;
    private double radi;
    private final double radiusMultiplicator;

    public ROLFNeuron(double d, double d2, double d3, double d4) {
        this.x = d;
        this.y = d2;
        this.radi = d3;
        this.radiusMultiplicator = d4;
    }

    public boolean match(double d, double d2) {
        double d3 = this.x - this.radi;
        double d4 = this.x + this.radi;
        double d5 = this.y - this.radi;
        double d6 = this.y + this.radi;
        boolean bl = d > d3 && d < d4;
        boolean bl2 = d2 > d5 && d2 < d6;
        return bl && bl2;
    }

    public double distance(double d, double d2) {
        double d3 = d < this.x ? this.x - d : d - this.x;
        d3 = d2 < this.y ? (d3 += this.y - d2) : (d3 += d2 - this.y);
        return d3;
    }

    public void moveToPointAndIncreaseRadi(double d, double d2) {
        this.x = this.x < d ? (this.x += (d - this.x) / 10.0) : (this.x -= (this.x - d) / 10.0);
        this.y = this.y < d2 ? (this.y += (d2 - this.y) / 10.0) : (this.y -= (this.y - d2) / 10.0);
        this.radi += Math.cos(this.radi) * this.radiusMultiplicator;
    }

    public void decreaseRadi(double d, double d2) {
        double d3 = this.radi / 20.0;
        for (int i = 0; i < 10; ++i) {
            if (this.match(d, d2)) {
                this.radi -= d3;
                continue;
            }
            return;
        }
    }

    public double getX() {
        return this.x;
    }

    public double getY() {
        return this.y;
    }

    public double getRadius() {
        return this.radi;
    }
}

