/*
 * Decompiled with CFR 0.152.
 */
package de.planetensuche.neuronalnet.core;

import de.planetensuche.neuronalnet.core.ROLFNeuron;
import java.util.ArrayList;
import java.util.List;

public final class ROLFNeuronalNetwork {
    private final List<ROLFNeuron> network = new ArrayList<ROLFNeuron>();
    private final String desc;
    private final double radiusMultiplicator;

    public ROLFNeuronalNetwork(String string, double d) {
        this.desc = string;
        this.radiusMultiplicator = d;
    }

    public void learn(double d, double d2, boolean bl) {
        ROLFNeuron rOLFNeuron = this.findNearst(d, d2);
        if (rOLFNeuron == null && bl) {
            rOLFNeuron = new ROLFNeuron(d, d2, (Math.random() + 0.01) * this.radiusMultiplicator, this.radiusMultiplicator);
            this.network.add(rOLFNeuron);
        } else if (rOLFNeuron != null && bl) {
            rOLFNeuron.moveToPointAndIncreaseRadi(d, d2);
        } else if (rOLFNeuron != null && !bl) {
            rOLFNeuron.decreaseRadi(d, d2);
        }
    }

    public boolean inCluster(double d, double d2) {
        ROLFNeuron rOLFNeuron = this.findNearst(d, d2);
        return rOLFNeuron != null;
    }

    public int getSize() {
        return this.network.size();
    }

    public double[][] getDataPoints() {
        double[][] dArray = new double[this.network.size()][3];
        int n = 0;
        for (ROLFNeuron rOLFNeuron : this.network) {
            dArray[n][0] = rOLFNeuron.getX();
            dArray[n][1] = rOLFNeuron.getY();
            dArray[n][2] = rOLFNeuron.getRadius();
            ++n;
        }
        return dArray;
    }

    private ROLFNeuron findNearst(double d, double d2) {
        ArrayList<ROLFNeuron> arrayList = new ArrayList<ROLFNeuron>();
        for (ROLFNeuron rOLFNeuron : this.network) {
            if (!rOLFNeuron.match(d, d2)) continue;
            arrayList.add(rOLFNeuron);
        }
        double d3 = 1.0E11;
        ROLFNeuron rOLFNeuron = null;
        for (ROLFNeuron rOLFNeuron2 : arrayList) {
            double d4 = rOLFNeuron2.distance(d, d2);
            if (!(d4 < d3)) continue;
            rOLFNeuron = rOLFNeuron2;
            d3 = d4;
        }
        return rOLFNeuron;
    }

    public String getDesc() {
        return this.desc;
    }
}

